/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPac4jAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPac4jAuthenticationHandler.class);
    private String principalAttributeId;
    private boolean isTypedIdUsed;

    public AbstractPac4jAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    protected AuthenticationHandlerExecutionResult createResult(ClientCredential credentials, UserProfile profile) throws GeneralSecurityException {
        if (profile == null) {
            throw new FailedLoginException("Authentication did not produce a user profile for: " + credentials);
        }
        String id = this.determinePrincipalIdFrom(profile);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new FailedLoginException("No identifier found for this user profile: " + profile);
        }
        credentials.setUserProfile(profile);
        credentials.setTypedIdUsed(this.isTypedIdUsed);
        Principal principal = this.principalFactory.createPrincipal(id, new LinkedHashMap(profile.getAttributes()));
        LOGGER.debug("Constructed authenticated principal [{}] based on user profile [{}]", (Object)principal, (Object)profile);
        return this.createHandlerResult((Credential)credentials, principal, new ArrayList(0));
    }

    protected String determinePrincipalIdFrom(UserProfile profile) {
        String id;
        if (StringUtils.isNotBlank((CharSequence)this.principalAttributeId) && profile.containsAttribute(this.principalAttributeId)) {
            id = profile.getAttribute(this.principalAttributeId).toString();
            LOGGER.debug("Delegated authentication indicates usage of attribute [{}] for the identifier [{}]", (Object)this.principalAttributeId, (Object)id);
        } else if (this.isTypedIdUsed) {
            id = profile.getTypedId();
            LOGGER.debug("Delegated authentication indicates usage of typed profile id [{}]", (Object)id);
        } else {
            id = profile.getId();
        }
        return id;
    }

    @Generated
    public void setPrincipalAttributeId(String principalAttributeId) {
        this.principalAttributeId = principalAttributeId;
    }

    @Generated
    public void setTypedIdUsed(boolean isTypedIdUsed) {
        this.isTypedIdUsed = isTypedIdUsed;
    }
}

