/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.DelegatedClientWebflowManager;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAuthenticationWebApplicationServiceFactory
extends WebApplicationServiceFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationWebApplicationServiceFactory.class);
    private final Clients clients;
    private final DelegatedClientWebflowManager delegatedClientWebflowManager;

    public DelegatedAuthenticationWebApplicationServiceFactory(Clients clients, DelegatedClientWebflowManager delegatedClientWebflowManager) {
        this.clients = clients;
        this.delegatedClientWebflowManager = delegatedClientWebflowManager;
    }

    protected String getRequestedService(HttpServletRequest request) {
        String service = super.getRequestedService(request);
        if (StringUtils.isNotBlank((CharSequence)service)) {
            return service;
        }
        String clientName = request.getParameter("client_name");
        LOGGER.trace("Indicated client name for service extraction is [{}]", (Object)clientName);
        if (StringUtils.isBlank((CharSequence)clientName)) {
            LOGGER.trace("No client name found in the request");
            return null;
        }
        BaseClient client = (BaseClient)this.clients.findClient(clientName);
        J2EContext webContext = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request);
        String clientId = this.delegatedClientWebflowManager.getDelegatedClientId((WebContext)webContext, client);
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            TransientSessionTicket ticket = this.delegatedClientWebflowManager.retrieveSessionTicketViaClientId((WebContext)webContext, clientId);
            if (ticket == null || ticket.getService() == null) {
                LOGGER.warn("Session ticket [{}] is not found or does not have a service associated with it", (Object)ticket);
                return null;
            }
            return ticket.getService().getId();
        }
        return null;
    }
}

