/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.net.URI;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationWebflowConfigurer.class);

    public DelegatedAuthenticationWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry logoutFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createClientActionActionState(flow);
            this.createStopWebflowViewState(flow);
            this.createSaml2ClientLogoutAction();
        }
    }

    private void createSaml2ClientLogoutAction() {
        Flow logoutFlow = this.getLogoutFlow();
        TransitionableState state = this.getState(logoutFlow, "terminateSession");
        state.getEntryActionList().add((Action)this.createEvaluateAction("saml2ClientLogoutAction"));
    }

    private void createClientActionActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "clientAction", (Action)this.createEvaluateAction("clientAction"));
        TransitionSet transitionSet = actionState.getTransitionSet();
        transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
        transitionSet.add(this.createTransition("error", this.getStartState(flow).getId()));
        transitionSet.add(this.createTransition("resume", this.getStartState(flow).getId()));
        transitionSet.add(this.createTransition("authenticationFailure", "stopWebflow"));
        transitionSet.add(this.createTransition("warn", "warn"));
        transitionSet.add(this.createTransition("stop", "stopWebflow"));
        this.setStartState(flow, (TransitionableState)actionState);
        this.registerMultifactorProvidersStateTransitionsIntoWebflow((TransitionableState)actionState);
    }

    private void createStopWebflowViewState(Flow flow) {
        ViewState state = this.createViewState(flow, "stopWebflow", "casPac4jStopWebflow");
        state.getEntryActionList().add((Action)new AbstractAction(){

            protected Event doExecute(RequestContext requestContext) throws Exception {
                URI unauthorizedRedirectUrl;
                RegisteredService service = WebUtils.getRegisteredService((RequestContext)requestContext);
                URI uRI = unauthorizedRedirectUrl = service != null ? service.getAccessStrategy().getUnauthorizedRedirectUrl() : null;
                if (unauthorizedRedirectUrl != null) {
                    HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
                    response.sendRedirect(unauthorizedRedirectUrl.toString());
                }
                return null;
            }
        });
        state.getEntryActionList().add((Action)new AbstractAction(){

            protected Event doExecute(RequestContext requestContext) {
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
                HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
                Optional<ModelAndView> mv = DelegatedClientAuthenticationAction.hasDelegationRequestFailed(request, response.getStatus());
                mv.ifPresent(modelAndView -> modelAndView.getModel().forEach((k, v) -> requestContext.getFlowScope().put(k, v)));
                return null;
            }
        });
    }
}

