/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.TicketGrantingCookieProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.CasThymeleafOutputTemplateHandler;
import org.apereo.cas.services.web.ChainingThemeResolver;
import org.apereo.cas.services.web.RequestHeaderThemeResolver;
import org.apereo.cas.services.web.ServiceThemeResolver;
import org.apereo.cas.services.web.ThemeBasedViewResolver;
import org.apereo.cas.services.web.ThemeViewResolver;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.theme.CookieThemeResolver;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.theme.SessionThemeResolver;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IPostProcessorDialect;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.postprocessor.PostProcessor;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration(value="casThemesConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Import(value={ThymeleafAutoConfiguration.class})
public class CasThemesConfiguration {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ThymeleafProperties thymeleafProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="thymeleafViewResolver")
    private ThymeleafViewResolver thymeleafViewResolver;

    @Bean
    public ViewResolver registeredServiceViewResolver() {
        ThemeBasedViewResolver resolver = new ThemeBasedViewResolver(this.themeResolver(), this.themeViewResolverFactory());
        resolver.setOrder(this.thymeleafViewResolver.getOrder() - 1);
        return resolver;
    }

    @ConditionalOnMissingBean(name={"themeViewResolverFactory"})
    @Bean
    public ThemeViewResolverFactory themeViewResolverFactory() {
        ThemeViewResolver.Factory factory = new ThemeViewResolver.Factory((ViewResolver)this.nonCachingThymeleafViewResolver(), this.thymeleafProperties);
        factory.setApplicationContext(this.applicationContext);
        return factory;
    }

    protected ThymeleafViewResolver nonCachingThymeleafViewResolver() {
        ThymeleafViewResolver r = new ThymeleafViewResolver();
        r.setApplicationContext(this.thymeleafViewResolver.getApplicationContext());
        r.setCacheUnresolved(this.thymeleafViewResolver.isCacheUnresolved());
        r.setCharacterEncoding(this.thymeleafViewResolver.getCharacterEncoding());
        r.setContentType(this.thymeleafViewResolver.getContentType());
        r.setExcludedViewNames(this.thymeleafViewResolver.getExcludedViewNames());
        r.setOrder(this.thymeleafViewResolver.getOrder());
        r.setRedirectContextRelative(this.thymeleafViewResolver.isRedirectContextRelative());
        r.setRedirectHttp10Compatible(this.thymeleafViewResolver.isRedirectHttp10Compatible());
        r.setStaticVariables(this.thymeleafViewResolver.getStaticVariables());
        SpringTemplateEngine engine = (SpringTemplateEngine)SpringTemplateEngine.class.cast(this.thymeleafViewResolver.getTemplateEngine());
        engine.addDialect((IDialect)new IPostProcessorDialect(){

            public int getDialectPostProcessorPrecedence() {
                return Integer.MAX_VALUE;
            }

            public Set<IPostProcessor> getPostProcessors() {
                return CollectionUtils.wrapSet((Object)new PostProcessor(TemplateMode.parse((String)CasThemesConfiguration.this.thymeleafProperties.getMode()), CasThymeleafOutputTemplateHandler.class, Integer.MAX_VALUE));
            }

            public String getName() {
                return CasThymeleafOutputTemplateHandler.class.getSimpleName();
            }
        });
        r.setTemplateEngine((ITemplateEngine)engine);
        r.setViewNames(this.thymeleafViewResolver.getViewNames());
        r.setCache(false);
        return r;
    }

    @Bean
    public Map serviceThemeResolverSupportedBrowsers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(".*iPhone.*", "iphone");
        map.put(".*Android.*", "android");
        map.put(".*Safari.*Pre.*", "safari");
        map.put(".*iPhone.*", "iphone");
        map.put(".*Nokia.*AppleWebKit.*", "nokiawebkit");
        return map;
    }

    @ConditionalOnMissingBean(name={"themeResolver"})
    @Bean
    public ThemeResolver themeResolver() {
        String defaultThemeName = this.casProperties.getTheme().getDefaultThemeName();
        FixedThemeResolver fixedResolver = new FixedThemeResolver();
        fixedResolver.setDefaultThemeName(defaultThemeName);
        SessionThemeResolver sessionThemeResolver = new SessionThemeResolver();
        sessionThemeResolver.setDefaultThemeName(defaultThemeName);
        TicketGrantingCookieProperties tgc = this.casProperties.getTgc();
        CookieThemeResolver cookieThemeResolver = new CookieThemeResolver();
        cookieThemeResolver.setDefaultThemeName(defaultThemeName);
        cookieThemeResolver.setCookieDomain(tgc.getDomain());
        cookieThemeResolver.setCookieHttpOnly(tgc.isHttpOnly());
        cookieThemeResolver.setCookieMaxAge(Integer.valueOf(tgc.getMaxAge()));
        cookieThemeResolver.setCookiePath(tgc.getPath());
        cookieThemeResolver.setCookieSecure(tgc.isSecure());
        ServiceThemeResolver serviceThemeResolver = new ServiceThemeResolver(this.servicesManager, this.serviceThemeResolverSupportedBrowsers(), this.authenticationRequestServiceSelectionStrategies, this.resourceLoader);
        serviceThemeResolver.setDefaultThemeName(defaultThemeName);
        RequestHeaderThemeResolver header = new RequestHeaderThemeResolver();
        header.setDefaultThemeName(defaultThemeName);
        ChainingThemeResolver chainingThemeResolver = new ChainingThemeResolver();
        chainingThemeResolver.addResolver((ThemeResolver)cookieThemeResolver).addResolver((ThemeResolver)sessionThemeResolver).addResolver((ThemeResolver)header).addResolver((ThemeResolver)serviceThemeResolver).addResolver((ThemeResolver)fixedResolver);
        chainingThemeResolver.setDefaultThemeName(defaultThemeName);
        return chainingThemeResolver;
    }
}

