/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.error.support;

import java.util.List;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.error.ErrorLogManager;
import org.apereo.inspektr.error.ErrorReporter;

public class DefaultErrorLogManager
implements ErrorLogManager {
    private String applicationCode;
    private PrincipalResolver currentContextPrincipalResolver;
    private List<ErrorReporter> errorReporters;

    public DefaultErrorLogManager(String applicationCode, List<ErrorReporter> errorReporters) {
        this.applicationCode = applicationCode;
        this.errorReporters = errorReporters;
    }

    public void setCurrentContextPrincipalResolver(PrincipalResolver resolver) {
        this.currentContextPrincipalResolver = resolver;
    }

    @Override
    public void recordError(String errorDescription) {
        String principal = this.resolvePrincipal();
        for (ErrorReporter r : this.errorReporters) {
            r.reportError(this.applicationCode, principal, errorDescription);
        }
    }

    @Override
    public void recordError(Throwable throwable) {
        String principal = this.resolvePrincipal();
        for (ErrorReporter r : this.errorReporters) {
            r.reportError(this.applicationCode, principal, throwable);
        }
    }

    @Override
    public List<ErrorReporter> getErrorReporters() {
        return this.errorReporters;
    }

    private String resolvePrincipal() {
        return this.currentContextPrincipalResolver == null ? null : this.currentContextPrincipalResolver.resolve();
    }
}

