package org.arquillian.cube.openshift.impl.client;

import java.util.List;
import java.util.List;
import java.util.Properties;
import java.util.List;
import java.util.AbstractCollection;
import java.util.Hashtable;
import org.arquillian.cube.openshift.api.ConfigurationHandle;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.LinkedHashSet;
import java.util.HashSet;
import io.fabric8.kubernetes.clnt.v4_0.Config;
import java.util.Dictionary;
import java.util.Set;
import java.net.URL;
import java.util.Set;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import java.io.IOException;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluentImpl;
import io.fabric8.kubernetes.api.builder.v4_0.Visitable;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Fluent;
import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;

public class CubeOpenShiftConfigurationFluentImpl<A extends CubeOpenShiftConfigurationFluent<A>> extends DefaultConfigurationFluentImpl<A> implements CubeOpenShiftConfigurationFluent<A>{

     boolean keepAliveGitServer;     String definitions;     String definitionsFile;     List<String> autoStartContainers = new ArrayList();     Set<String> proxiedContainerPorts = new LinkedHashSet();     String portForwardBindAddress;     String routerHost;     int openshiftRouterHttpPort;     int openshiftRouterHttpsPort;     boolean enableImageStreamDetection;     int routerSniPort;     String templateURL;     String templateLabels;     String templateParameters;     boolean templateProcess;     long startupTimeout;     long httpClientTimeout;     int awaitRouteRepetitions;     OpenShiftClient client;
public CubeOpenShiftConfigurationFluentImpl(){
    
}
public CubeOpenShiftConfigurationFluentImpl( CubeOpenShiftConfiguration instance ){
    this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables()); this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); this.withWaitEnabled(instance.isWaitEnabled()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withLogCopyEnabled(instance.isLogCopyEnabled()); this.withFmpBuildEnabled(instance.isFmpBuildEnabled()); this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable()); this.withFmpDebugOutput(instance.isFmpDebugOutput()); this.withFmpLogsEnabled(instance.isFmpLogsEnabled()); this.withFmpPomPath(instance.getFmpPomPath()); this.withFmpProfiles(instance.getFmpProfiles()); this.withFmpSystemProperties(instance.getFmpSystemProperties()); this.withFmpBuildOptions(instance.getFmpBuildOptions()); this.withLogPath(instance.getLogPath()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); this.withKeepAliveGitServer(instance.isKeepAliveGitServer()); this.withDefinitions(instance.getDefinitions()); this.withDefinitionsFile(instance.getDefinitionsFile()); this.withAutoStartContainers(instance.getAutoStartContainers()); this.withProxiedContainerPorts(instance.getProxiedContainerPorts()); this.withPortForwardBindAddress(instance.getPortForwardBindAddress()); this.withRouterHost(instance.getRouterHost()); this.withOpenshiftRouterHttpPort(instance.getOpenshiftRouterHttpPort()); this.withOpenshiftRouterHttpsPort(instance.getOpenshiftRouterHttpsPort()); this.withEnableImageStreamDetection(instance.isEnableImageStreamDetection()); this.withToken(instance.getToken()); this.withRouterSniPort(instance.getRouterSniPort()); this.withTemplateURL(instance.getTemplateURL()); this.withTemplateLabels(instance.getTemplateLabels()); this.withTemplateParameters(instance.getTemplateParameters()); this.withTemplateProcess(instance.isTemplateProcess()); this.withUsername(instance.getUsername()); this.withPassword(instance.getPassword()); this.withApiVersion(instance.getApiVersion()); this.withTrustCerts(instance.isTrustCerts()); this.withStartupTimeout(instance.getStartupTimeout()); this.withHttpClientTimeout(instance.getHttpClientTimeout()); this.withAwaitRouteRepetitions(instance.getAwaitRouteRepetitions()); this.withClient(instance.getClient());

}

    public boolean isKeepAliveGitServer(){
    return this.keepAliveGitServer;
    }
    public A withKeepAliveGitServer( boolean keepAliveGitServer){
    this.keepAliveGitServer=keepAliveGitServer; return (A) this;
    }
    public String getDefinitions(){
    return this.definitions;
    }
    public A withDefinitions( String definitions){
    this.definitions=definitions; return (A) this;
    }
    public String getDefinitionsFile(){
    return this.definitionsFile;
    }
    public A withDefinitionsFile( String definitionsFile){
    this.definitionsFile=definitionsFile; return (A) this;
    }
    public A withAutoStartContainers( String ...autoStartContainers){
    this.autoStartContainers.clear(); if (autoStartContainers != null) {for (String item :autoStartContainers){ this.addToAutoStartContainers(item);}} return (A) this;
    }
    public String[] getAutoStartContainers(){
    String[] result = new String[autoStartContainers.size()];
int index=0;
for (String item : autoStartContainers) {
    result[index++]=item;
}
return result;

    }
    public A addToAutoStartContainers( String ...items){
    for (String item : items) {this.autoStartContainers.add(item);} return (A)this;
    }
    public A removeFromAutoStartContainers( String ...items){
    for (String item : items) {this.autoStartContainers.remove(item);} return (A)this;
    }
    public A addToProxiedContainerPorts( String ...items){
    for (String item : items) {this.proxiedContainerPorts.add(item);} return (A)this;
    }
    public A removeFromProxiedContainerPorts( String ...items){
    for (String item : items) {this.proxiedContainerPorts.remove(item);} return (A)this;
    }
    public Set<String> getProxiedContainerPorts(){
    return this.proxiedContainerPorts;
    }
    public A withProxiedContainerPorts( Set<String> proxiedContainerPorts){
    this.proxiedContainerPorts.clear();if (proxiedContainerPorts != null) {for (String item : proxiedContainerPorts){this.addToProxiedContainerPorts(item);}} return (A) this;
    }
    public A withProxiedContainerPorts( String ...proxiedContainerPorts){
    this.proxiedContainerPorts.clear(); if (proxiedContainerPorts != null) {for (String item :proxiedContainerPorts){ this.addToProxiedContainerPorts(item);}} return (A) this;
    }
    public String getPortForwardBindAddress(){
    return this.portForwardBindAddress;
    }
    public A withPortForwardBindAddress( String portForwardBindAddress){
    this.portForwardBindAddress=portForwardBindAddress; return (A) this;
    }
    public String getRouterHost(){
    return this.routerHost;
    }
    public A withRouterHost( String routerHost){
    this.routerHost=routerHost; return (A) this;
    }
    public int getOpenshiftRouterHttpPort(){
    return this.openshiftRouterHttpPort;
    }
    public A withOpenshiftRouterHttpPort( int openshiftRouterHttpPort){
    this.openshiftRouterHttpPort=openshiftRouterHttpPort; return (A) this;
    }
    public int getOpenshiftRouterHttpsPort(){
    return this.openshiftRouterHttpsPort;
    }
    public A withOpenshiftRouterHttpsPort( int openshiftRouterHttpsPort){
    this.openshiftRouterHttpsPort=openshiftRouterHttpsPort; return (A) this;
    }
    public boolean isEnableImageStreamDetection(){
    return this.enableImageStreamDetection;
    }
    public A withEnableImageStreamDetection( boolean enableImageStreamDetection){
    this.enableImageStreamDetection=enableImageStreamDetection; return (A) this;
    }
    public int getRouterSniPort(){
    return this.routerSniPort;
    }
    public A withRouterSniPort( int routerSniPort){
    this.routerSniPort=routerSniPort; return (A) this;
    }
    public String getTemplateURL(){
    return this.templateURL;
    }
    public A withTemplateURL( String templateURL){
    this.templateURL=templateURL; return (A) this;
    }
    public String getTemplateLabels(){
    return this.templateLabels;
    }
    public A withTemplateLabels( String templateLabels){
    this.templateLabels=templateLabels; return (A) this;
    }
    public String getTemplateParameters(){
    return this.templateParameters;
    }
    public A withTemplateParameters( String templateParameters){
    this.templateParameters=templateParameters; return (A) this;
    }
    public boolean isTemplateProcess(){
    return this.templateProcess;
    }
    public A withTemplateProcess( boolean templateProcess){
    this.templateProcess=templateProcess; return (A) this;
    }
    public long getStartupTimeout(){
    return this.startupTimeout;
    }
    public A withStartupTimeout( long startupTimeout){
    this.startupTimeout=startupTimeout; return (A) this;
    }
    public long getHttpClientTimeout(){
    return this.httpClientTimeout;
    }
    public A withHttpClientTimeout( long httpClientTimeout){
    this.httpClientTimeout=httpClientTimeout; return (A) this;
    }
    public int getAwaitRouteRepetitions(){
    return this.awaitRouteRepetitions;
    }
    public A withAwaitRouteRepetitions( int awaitRouteRepetitions){
    this.awaitRouteRepetitions=awaitRouteRepetitions; return (A) this;
    }
    public OpenShiftClient getClient(){
    return this.client;
    }
    public A withClient( OpenShiftClient client){
    this.client=client; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CubeOpenShiftConfigurationFluentImpl that = (CubeOpenShiftConfigurationFluentImpl) o;
if (keepAliveGitServer != that.keepAliveGitServer) return false;
if (definitions != null ? !definitions.equals(that.definitions) :that.definitions != null) return false;
if (definitionsFile != null ? !definitionsFile.equals(that.definitionsFile) :that.definitionsFile != null) return false;
if (autoStartContainers != null ? !autoStartContainers.equals(that.autoStartContainers) :that.autoStartContainers != null) return false;
if (proxiedContainerPorts != null ? !proxiedContainerPorts.equals(that.proxiedContainerPorts) :that.proxiedContainerPorts != null) return false;
if (portForwardBindAddress != null ? !portForwardBindAddress.equals(that.portForwardBindAddress) :that.portForwardBindAddress != null) return false;
if (routerHost != null ? !routerHost.equals(that.routerHost) :that.routerHost != null) return false;
if (openshiftRouterHttpPort != that.openshiftRouterHttpPort) return false;
if (openshiftRouterHttpsPort != that.openshiftRouterHttpsPort) return false;
if (enableImageStreamDetection != that.enableImageStreamDetection) return false;
if (routerSniPort != that.routerSniPort) return false;
if (templateURL != null ? !templateURL.equals(that.templateURL) :that.templateURL != null) return false;
if (templateLabels != null ? !templateLabels.equals(that.templateLabels) :that.templateLabels != null) return false;
if (templateParameters != null ? !templateParameters.equals(that.templateParameters) :that.templateParameters != null) return false;
if (templateProcess != that.templateProcess) return false;
if (startupTimeout != that.startupTimeout) return false;
if (httpClientTimeout != that.httpClientTimeout) return false;
if (awaitRouteRepetitions != that.awaitRouteRepetitions) return false;
if (client != null ? !client.equals(that.client) :that.client != null) return false;
return true;

    }



}
