/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.api.model.OpenShiftResource;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.resources.ClassTemplateProcessor;
import org.arquillian.cube.openshift.impl.resources.MethodTemplateProcessor;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceFactory;
import org.arquillian.cube.openshift.impl.resources.TemplateProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class CEEnvironmentProcessor {
    private final Logger log = Logger.getLogger(CEEnvironmentProcessor.class.getName());
    @Inject
    private Instance<Configuration> configurationInstance;
    @Inject
    @ClassScoped
    private InstanceProducer<TemplateDetails> templateDetailsProducer;
    private TemplateProcessor classTemplateProcessor;
    private TemplateProcessor methodTemplateProcessor;

    public void createEnvironment(@Observes(precedence=10) BeforeClass event, OpenShiftAdapter client, CubeOpenShiftConfiguration cubeOpenShiftConfiguration) {
        TestClass testClass = event.getTestClass();
        this.log.info(String.format("Creating environment for %s", testClass.getName()));
        OpenShiftResourceFactory.createResources(testClass.getName(), client, testClass.getJavaClass(), cubeOpenShiftConfiguration.getProperties());
        this.classTemplateProcessor = new ClassTemplateProcessor(client, cubeOpenShiftConfiguration, testClass);
        List<OpenShiftResource> templateResources = this.classTemplateProcessor.processTemplateResources();
        this.templateDetailsProducer.set(() -> templateResources);
    }

    public void createOpenShiftResource(@Observes(precedence=10) Before event, OpenShiftAdapter client, CubeOpenShiftConfiguration cubeOpenShiftConfiguration) {
        TestClass testClass = event.getTestClass();
        Method testMethod = event.getTestMethod();
        this.log.info(String.format("Creating environment for %s method %s", testClass.getName(), testMethod));
        OpenShiftResourceFactory.createResources(testClass.getJavaClass(), client, testMethod, cubeOpenShiftConfiguration.getProperties());
        this.methodTemplateProcessor = new MethodTemplateProcessor(client, cubeOpenShiftConfiguration, testClass, testMethod);
        this.methodTemplateProcessor.processTemplateResources();
    }

    public void deleteOpenShiftResource(@Observes(precedence=-10) After event, OpenShiftAdapter client, CubeOpenShiftConfiguration cubeOpenShiftConfiguration) throws Exception {
        TestClass testClass = event.getTestClass();
        Method testMethod = event.getTestMethod();
        Class javaClass = testClass.getJavaClass();
        String templateKeyPrefix = OpenShiftResourceFactory.createResourceKey(javaClass, testMethod);
        this.log.info(String.format("Deleting environment for %s method %s", testClass.getName(), testMethod.getName()));
        OpenShiftResourceFactory.deleteResources(javaClass, testMethod, client);
        OpenShiftResourceFactory.deleteTemplates(templateKeyPrefix, this.methodTemplateProcessor.getTemplates(), client, cubeOpenShiftConfiguration);
    }

    public void deleteEnvironment(@Observes(precedence=-10) AfterClass event, OpenShiftAdapter client, CubeOpenShiftConfiguration configuration) throws Exception {
        OpenShiftResourceFactory.deleteEnvironment(event.getTestClass(), client, configuration, this.classTemplateProcessor.getTemplates());
    }

    public static interface TemplateDetails {
        public List<? extends OpenShiftResource> getResources();
    }
}

