/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.dns;

import io.fabric8.openshift.api.model.v4_0.RouteList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import sun.net.spi.nameservice.NameService;

public class ArqCubeNameService
implements NameService {
    private static final Set<String> hosts = new HashSet<String>();
    private static InetAddress routerAddr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoutes(RouteList routeList, String routerHost) {
        Set<String> set = hosts;
        synchronized (set) {
            hosts.clear();
            try {
                routerAddr = routerHost == null ? null : InetAddress.getByName(routerHost);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid IP for router host", e);
            }
            routeList.getItems().stream().filter(Objects::nonNull).forEach(route -> {
                System.out.println(String.format("Adding route to Arquillian Naming Service: %s %s", routerHost, route.getSpec().getHost()));
                hosts.add(route.getSpec().getHost());
            });
        }
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        Set<String> set = hosts;
        synchronized (set) {
            if (routerAddr != null && hosts.contains(host)) {
                return new InetAddress[]{InetAddress.getByAddress(host, routerAddr.getAddress())};
            }
            throw new UnknownHostException(host);
        }
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        throw new UnknownHostException();
    }
}

