/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.graphene.location;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.OpenShiftRouteLocator;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class OpenShiftCustomizableURLResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<GrapheneConfiguration> grapheneConfiguration;
    @Inject
    private Instance<OpenShiftClient> clientInstance;
    @Inject
    private Instance<Configuration> configurationInstance;

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        try {
            URL routeUrl = this.resolveUrl();
            ResourceUtil.awaitRoute(routeUrl, new int[0]);
            return routeUrl;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private URL resolveUrl() throws MalformedURLException {
        GrapheneConfiguration grapheneConfiguration = (GrapheneConfiguration)this.grapheneConfiguration.get();
        OpenShiftRouteLocator openShiftRouteLocator = new OpenShiftRouteLocator(this.clientInstance, this.configurationInstance);
        String configuredUrl = grapheneConfiguration.getUrl();
        if (configuredUrl != null && !configuredUrl.isEmpty()) {
            return openShiftRouteLocator.getRoute(new URL(configuredUrl));
        }
        return openShiftRouteLocator.getRoute();
    }
}

