/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.spi;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Binding {
    public Set<PortBinding> bindings;
    private String ip;
    private String internalIp;

    public Binding(String ip) {
        this(ip, null);
    }

    public Binding(String ip, String internalIp) {
        this.ip = ip;
        this.internalIp = internalIp;
        this.bindings = new HashSet<PortBinding>();
    }

    public String getIP() {
        return this.ip;
    }

    public Set<PortBinding> getPortBindings() {
        return new HashSet<PortBinding>(this.bindings);
    }

    public int getNumberOfPortBindings() {
        return this.bindings.size();
    }

    public PortBinding getFirstPortBinding() {
        Iterator<PortBinding> iterator = this.bindings.iterator();
        if (iterator.hasNext()) {
            PortBinding binding = iterator.next();
            return binding;
        }
        return null;
    }

    public String getInternalIP() {
        return this.internalIp;
    }

    public Binding addPortBinding(Integer exposedPort, Integer bindingPort) {
        this.bindings.add(new PortBinding(exposedPort, bindingPort));
        return this;
    }

    public boolean arePortBindings() {
        return !this.bindings.isEmpty();
    }

    public PortBinding getBindingForExposedPort(Integer exposedPort) {
        for (PortBinding binding : this.bindings) {
            if (!exposedPort.equals(binding.getExposedPort())) continue;
            return binding;
        }
        return null;
    }

    public class PortBinding {
        private Integer exposedPort;
        private Integer bindingPort;

        public PortBinding(Integer exposedPort, Integer bindingPort) {
            this.exposedPort = exposedPort;
            this.bindingPort = bindingPort;
        }

        public Integer getExposedPort() {
            return this.exposedPort;
        }

        public Integer getBindingPort() {
            return this.bindingPort;
        }

        public Binding getParent() {
            return Binding.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bindingPort == null ? 0 : this.bindingPort.hashCode());
            result = 31 * result + (this.exposedPort == null ? 0 : this.exposedPort.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortBinding other = (PortBinding)obj;
            if (this.bindingPort == null ? other.bindingPort != null : !this.bindingPort.equals(other.bindingPort)) {
                return false;
            }
            return !(this.exposedPort == null ? other.exposedPort != null : !this.exposedPort.equals(other.exposedPort));
        }
    }
}

