/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.spacelift.ImplementationLoader;
import org.arquillian.spacelift.Invokable;
import org.arquillian.spacelift.SpaceliftConfiguration;
import org.arquillian.spacelift.execution.ExecutionService;
import org.arquillian.spacelift.task.InjectTask;
import org.arquillian.spacelift.task.InvalidTaskException;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.TaskRegistry;

public class Spacelift {
    public static <IN, OUT, TASK extends Task<? super IN, OUT>> TASK task(Class<TASK> taskDef) {
        return SpaceliftInstance.get().registry().find(taskDef);
    }

    public static Task<?, ?> task(String alias) throws InvalidTaskException {
        return SpaceliftInstance.get().registry().find(alias);
    }

    public static <IN, OUT, TASK extends Task<? super IN, OUT>> TASK task(IN input, Class<TASK> taskDef) {
        InjectTask task = SpaceliftInstance.get().registry().find(InjectTask.class);
        return task.passToNext(input).then(taskDef);
    }

    public static Task<?, ?> task(Object input, String alias) throws InvalidTaskException {
        InjectTask task = SpaceliftInstance.get().registry().find(InjectTask.class);
        return task.passToNext(input).then(alias);
    }

    public static TaskRegistry registry() {
        return SpaceliftInstance.get().registry();
    }

    public static ExecutionService service() {
        return SpaceliftInstance.get().service();
    }

    public static SpaceliftConfiguration configuration() {
        return SpaceliftInstance.get().configuration();
    }

    private static class SpaceliftConfigurationImpl
    implements SpaceliftConfiguration {
        private SpaceliftConfigurationImpl() {
        }

        @Override
        public File workspace() {
            return new File(".");
        }

        @Override
        public File cache() {
            String userHome = System.getProperty("user.home", ".");
            File cache = new File(userHome, ".spacelift/cache");
            cache.mkdirs();
            return cache;
        }

        @Override
        public File workpath(String path) throws IllegalArgumentException {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null.");
            }
            return new File(this.workspace(), path);
        }

        @Override
        public File cachePath(String path) throws IllegalArgumentException {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null.");
            }
            return new File(this.cache(), path);
        }
    }

    private static class SpaceliftInstance {
        private static final Logger log = Logger.getLogger(Spacelift.class.getName());
        private ExecutionService service;
        private TaskRegistry registry;
        private SpaceliftConfiguration configuration;

        private SpaceliftInstance() {
            try {
                this.service = ImplementationLoader.implementationOf(ExecutionService.class);
            }
            catch (Invokable.InvocationException e) {
                throw new IllegalStateException(MessageFormat.format("Unable to find default implementation of {0} on classpath.", ExecutionService.class.getName()), e);
            }
            try {
                this.registry = ImplementationLoader.implementationOf(TaskRegistry.class);
                this.registry.register(InjectTask.class, new String[0]);
            }
            catch (Invokable.InvocationException e) {
                throw new IllegalStateException(MessageFormat.format("Unable to find default implementation of {0} on classpath.", ExecutionService.class.getName()), e);
            }
            try {
                try {
                    this.configuration = ImplementationLoader.implementationOf(SpaceliftConfiguration.class);
                    log.log(Level.INFO, "Initialized Spacelift, workspace: {0}, cache: {1}", new Object[]{this.configuration.workspace().getCanonicalPath(), this.configuration.cache().getCanonicalPath()});
                }
                catch (Invokable.InvocationException e) {
                    this.configuration = new SpaceliftConfigurationImpl();
                    log.log(Level.INFO, "Initialized Spacelift from defaults, workspace: {0}, cache: {1}", new Object[]{this.configuration.workspace().getCanonicalPath(), this.configuration.cache().getCanonicalPath()});
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(MessageFormat.format("Unable to initialize Spacelift configuration.", ExecutionService.class.getName()), e);
            }
        }

        public static SpaceliftInstance get() {
            return LazyHolder.INSTANCE;
        }

        public TaskRegistry registry() {
            return this.registry;
        }

        public ExecutionService service() {
            return this.service;
        }

        public SpaceliftConfiguration configuration() {
            return this.configuration;
        }

        private static class LazyHolder {
            private static final SpaceliftInstance INSTANCE = new SpaceliftInstance();

            private LazyHolder() {
            }
        }
    }
}

