// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.global;

import org.bytedeco.flycapture.FlyCapture2_C.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.flycapture.FlyCapture2.*;
import static org.bytedeco.flycapture.global.FlyCapture2.*;

public class FlyCapture2_C extends org.bytedeco.flycapture.presets.FlyCapture2_C {
    static { Loader.load(); }

// Parsed from <FlyCapture2Defs_C.h>

//=============================================================================
// Copyright (c) 2001-2018 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_FLYCAPTURE2DEFS_C_H
// #define FLIR_FLYCAPTURE2DEFS_C_H

// #include <stdlib.h>

//=============================================================================
// Definitions header file for FlyCapture2 C API.
//
// Holds enumerations, typedefs and structures that are used across the
// FlyCapture2 C API wrapper.
//
// Please see FlyCapture2Defs.h or the API documentation for full details
// of the various enumerations and structures.
//=============================================================================

// #ifdef __cplusplus
// #endif

    /**
     * \defgroup CTypeDefs TypeDefs
     */

    /*@{*/

// #ifndef FALSE
public static final int FALSE =               0;
// #endif

// #ifndef TRUE
public static final int TRUE =                1;
// #endif

// #ifndef FULL_32BIT_VALUE
// #endif

public static final int MAX_STRING_LENGTH =   512;
// Targeting ../FlyCapture2_C/fc2Context.java


// Targeting ../FlyCapture2_C/fc2GuiContext.java


// Targeting ../FlyCapture2_C/fc2ImageImpl.java


// Targeting ../FlyCapture2_C/fc2ImageStatisticsContext.java


// Targeting ../FlyCapture2_C/fc2TopologyNodeContext.java


// Targeting ../FlyCapture2_C/fc2PGRGuid.java



    /*@}*/

    /**
     * \defgroup CEnumerations Enumerations
     */

    /*@{*/

    /** The error types returned by functions. */
    /** enum fc2Error */
    public static final int
        /** Undefined */
        FC2_ERROR_UNDEFINED = -1,
        /** Function returned with no errors. */
        FC2_ERROR_OK = 0,
        /** General failure. */
        FC2_ERROR_FAILED = 1,
        /** Function has not been implemented. */
        FC2_ERROR_NOT_IMPLEMENTED = 2,
        /** Could not connect to Bus Master. */
        FC2_ERROR_FAILED_BUS_MASTER_CONNECTION = 3,
        /** Camera has not been connected. */
        FC2_ERROR_NOT_CONNECTED = 4,
        /** Initialization failed. */
        FC2_ERROR_INIT_FAILED = 5,
        /** Camera has not been initialized. */
        FC2_ERROR_NOT_INTITIALIZED = 6,
        /** Invalid parameter passed to function. */
        FC2_ERROR_INVALID_PARAMETER = 7,
        /** Setting set to camera is invalid. */
        FC2_ERROR_INVALID_SETTINGS = 8,
        /** Invalid Bus Manager object. */
        FC2_ERROR_INVALID_BUS_MANAGER = 9,
        /** Could not allocate memory. */
        FC2_ERROR_MEMORY_ALLOCATION_FAILED = 10,
        /** Low level error. */
        FC2_ERROR_LOW_LEVEL_FAILURE = 11,
        /** Device not found. */
        FC2_ERROR_NOT_FOUND = 12,
        /** GUID failure. */
        FC2_ERROR_FAILED_GUID = 13,
        /** Packet size set to camera is invalid. */
        FC2_ERROR_INVALID_PACKET_SIZE = 14,
        /** Invalid mode has been passed to function. */
        FC2_ERROR_INVALID_MODE = 15,
        /** Error due to not being in Format7. */
        FC2_ERROR_NOT_IN_FORMAT7 = 16,
        /** This feature is unsupported. */
        FC2_ERROR_NOT_SUPPORTED = 17,
        /** Timeout error. */
        FC2_ERROR_TIMEOUT = 18,
        /** Bus Master Failure. */
        FC2_ERROR_BUS_MASTER_FAILED = 19,
        /** Generation Count Mismatch. */
        FC2_ERROR_INVALID_GENERATION = 20,
        /** Look Up Table failure. */
        FC2_ERROR_LUT_FAILED = 21,
        /** IIDC failure. */
        FC2_ERROR_IIDC_FAILED = 22,
        /** Strobe failure. */
        FC2_ERROR_STROBE_FAILED = 23,
        /** Trigger failure. */
        FC2_ERROR_TRIGGER_FAILED = 24,
        /** Property failure. */
        FC2_ERROR_PROPERTY_FAILED = 25,
        /** Property is not present. */
        FC2_ERROR_PROPERTY_NOT_PRESENT = 26,
        /** Register access failed. */
        FC2_ERROR_REGISTER_FAILED = 27,
        /** Register read failed. */
        FC2_ERROR_READ_REGISTER_FAILED = 28,
        /** Register write failed. */
        FC2_ERROR_WRITE_REGISTER_FAILED = 29,
        /** Isochronous failure. */
        FC2_ERROR_ISOCH_FAILED = 30,
        /** Isochronous transfer has already been started. */
        FC2_ERROR_ISOCH_ALREADY_STARTED = 31,
        /** Isochronous transfer has not been started. */
        FC2_ERROR_ISOCH_NOT_STARTED = 32,
        /** Isochronous start failed. */
        FC2_ERROR_ISOCH_START_FAILED = 33,
        /** Isochronous retrieve buffer failed. */
        FC2_ERROR_ISOCH_RETRIEVE_BUFFER_FAILED = 34,
        /** Isochronous stop failed. */
        FC2_ERROR_ISOCH_STOP_FAILED = 35,
        /** Isochronous image synchronization failed. */
        FC2_ERROR_ISOCH_SYNC_FAILED = 36,
        /** Isochronous bandwidth exceeded. */
        FC2_ERROR_ISOCH_BANDWIDTH_EXCEEDED = 37,
        /** Image conversion failed. */
        FC2_ERROR_IMAGE_CONVERSION_FAILED = 38,
        /** Image library failure. */
        FC2_ERROR_IMAGE_LIBRARY_FAILURE = 39,
        /** Buffer is too small. */
        FC2_ERROR_BUFFER_TOO_SMALL = 40,
        /** There is an image consistency error. */
        FC2_ERROR_IMAGE_CONSISTENCY_ERROR = 41,
        /** The installed driver is not compatible with the library. */
        FC2_ERROR_INCOMPATIBLE_DRIVER = 42,
        FC2_ERROR_FORCE_32BITS = FULL_32BIT_VALUE;

    /** The type of bus callback to register a callback function for. */
    /** enum fc2BusCallbackType */
    public static final int
        /** Register for all bus events. */
        FC2_BUS_RESET = 0,
        /** Register for arrivals only. */
        FC2_ARRIVAL = 1,
        /** Register for removals only. */
        FC2_REMOVAL = 2,
        FC2_CALLBACK_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * The grab strategy employed during image transfer. This type controls
     * how images that stream off the camera accumulate in a user buffer
     * for handling.
     */
    /*
       @remark Unlike earlier versions of the FlyCapture SDK, it is no longer
     * necessary to explicitly start the image grabbing process before
     * specifying an image grabbing mode.
     */
    /** enum fc2GrabMode */
    public static final int
        /**
         * Grabs the newest image in the user buffer each time the
         * RetrieveBuffer() function is called. Older images are dropped
         * instead of accumulating in the user buffer. Grabbing blocks if the
         * camera has not finished transmitting the next available image. If
         * the camera is transmitting images faster than the application can
         * grab them, images may be dropped and only the most recent image
         * is stored for grabbing. Note that this mode is the equivalent of
         * flycaptureLockLatest in earlier versions of the FlyCapture SDK.
         */
        FC2_DROP_FRAMES = 0,

        /**
         * Images accumulate in the user buffer, and the oldest image is
         * grabbed for handling before being discarded. This member can be
         * used to guarantee that each image is seen. However, image processing
         * time must not exceed transmission time from the camera to the
         * buffer. Grabbing blocks if the camera has not finished transmitting
         * the next available image. The buffer size is controlled by the
         * numBuffers parameter in the FC2Config struct. Note that this mode is
         * the equivalent of flycaptureLockNext in earlier versions of the
         * FlyCapture SDK.
         */
        FC2_BUFFER_FRAMES = 1,

        /**
         * Unspecified grab mode.
         */
        FC2_UNSPECIFIED_GRAB_MODE = 2,
        FC2_GRAB_MODE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Timeout options for grabbing images. */
    /** enum fc2GrabTimeout */
    public static final int
        /** Non-blocking wait. */
        FC2_TIMEOUT_NONE = 0,
        /** Wait indefinitely. */
        FC2_TIMEOUT_INFINITE = -1,
        /** Unspecified timeout setting. */
        FC2_TIMEOUT_UNSPECIFIED = -2,
        FC2_GRAB_TIMEOUT_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Bandwidth allocation options for 1394 devices. */
    /** enum fc2BandwidthAllocation */
    public static final int
        /** Do not allocate bandwidth. */
        FC2_BANDWIDTH_ALLOCATION_OFF = 0,
        /** Allocate bandwidth. This is the default setting. */
        FC2_BANDWIDTH_ALLOCATION_ON = 1,
        /**
         * Bandwidth allocation is not supported by either the camera or
         * operating system.
         */
        FC2_BANDWIDTH_ALLOCATION_UNSUPPORTED = 2,
        /** Not specified. This leaves the current setting unchanged. */
        FC2_BANDWIDTH_ALLOCATION_UNSPECIFIED = 3,
        FC2_BANDWIDTH_ALLOCATION_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Interfaces that a camera may use to communicate with a host. */
    /** enum fc2InterfaceType */
    public static final int
        /** IEEE-1394 (Includes 1394a and 1394b). */
        FC2_INTERFACE_IEEE1394 = 0,
        /** USB 2.0. */
        FC2_INTERFACE_USB_2 = 1,
        /** USB 3.0. */
        FC2_INTERFACE_USB_3 = 2,
        /** GigE. */
        FC2_INTERFACE_GIGE = 3,
        /** Unknown interface. */
        FC2_INTERFACE_UNKNOWN = 4,
        FC2_INTERFACE_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * Camera properties. Not all properties may be supported, depending
     * on the camera model.
     */
    /** enum fc2PropertyType */
    public static final int
        FC2_BRIGHTNESS = 0,
        FC2_AUTO_EXPOSURE = 1,
        FC2_SHARPNESS = 2,
        FC2_WHITE_BALANCE = 3,
        FC2_HUE = 4,
        FC2_SATURATION = 5,
        FC2_GAMMA = 6,
        FC2_IRIS = 7,
        FC2_FOCUS = 8,
        FC2_ZOOM = 9,
        FC2_PAN = 10,
        FC2_TILT = 11,
        FC2_SHUTTER = 12,
        FC2_GAIN = 13,
        FC2_TRIGGER_MODE = 14,
        FC2_TRIGGER_DELAY = 15,
        FC2_FRAME_RATE = 16,
        FC2_TEMPERATURE = 17,
        FC2_UNSPECIFIED_PROPERTY_TYPE = 18,
        FC2_PROPERTY_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Frame rates in frames per second. */
    /** enum fc2FrameRate */
    public static final int
        /** 1.875 fps. */
        FC2_FRAMERATE_1_875 = 0,
        /** 3.75 fps. */
        FC2_FRAMERATE_3_75 = 1,
        /** 7.5 fps. */
        FC2_FRAMERATE_7_5 = 2,
        /** 15 fps. */
        FC2_FRAMERATE_15 = 3,
        /** 30 fps. */
        FC2_FRAMERATE_30 = 4,
        /** 60 fps. */
        FC2_FRAMERATE_60 = 5,
        /** 120 fps. */
        FC2_FRAMERATE_120 = 6,
        /** 240 fps. */
        FC2_FRAMERATE_240 = 7,
        /** Custom frame rate for Format7 functionality. */
        FC2_FRAMERATE_FORMAT7 = 8,
        /** Number of possible camera frame rates. */
        FC2_NUM_FRAMERATES = 9,
        FC2_FRAMERATE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** DCAM video modes. */
    /** enum fc2VideoMode */
    public static final int
        /** 160x120 YUV444. */
        FC2_VIDEOMODE_160x120YUV444 = 0,
        /** 320x240 YUV422. */
        FC2_VIDEOMODE_320x240YUV422 = 1,
        /** 640x480 YUV411. */
        FC2_VIDEOMODE_640x480YUV411 = 2,
        /** 640x480 YUV422. */
        FC2_VIDEOMODE_640x480YUV422 = 3,
        /** 640x480 24-bit RGB. */
        FC2_VIDEOMODE_640x480RGB = 4,
        /** 640x480 8-bit. */
        FC2_VIDEOMODE_640x480Y8 = 5,
        /** 640x480 16-bit. */
        FC2_VIDEOMODE_640x480Y16 = 6,
        /** 800x600 YUV422. */
        FC2_VIDEOMODE_800x600YUV422 = 7,
        /** 800x600 RGB. */
        FC2_VIDEOMODE_800x600RGB = 8,
        /** 800x600 8-bit. */
        FC2_VIDEOMODE_800x600Y8 = 9,
        /** 800x600 16-bit. */
        FC2_VIDEOMODE_800x600Y16 = 10,
        /** 1024x768 YUV422. */
        FC2_VIDEOMODE_1024x768YUV422 = 11,
        /** 1024x768 RGB. */
        FC2_VIDEOMODE_1024x768RGB = 12,
        /** 1024x768 8-bit. */
        FC2_VIDEOMODE_1024x768Y8 = 13,
        /** 1024x768 16-bit. */
        FC2_VIDEOMODE_1024x768Y16 = 14,
        /** 1280x960 YUV422. */
        FC2_VIDEOMODE_1280x960YUV422 = 15,
        /** 1280x960 RGB. */
        FC2_VIDEOMODE_1280x960RGB = 16,
        /** 1280x960 8-bit. */
        FC2_VIDEOMODE_1280x960Y8 = 17,
        /** 1280x960 16-bit. */
        FC2_VIDEOMODE_1280x960Y16 = 18,
        /** 1600x1200 YUV422. */
        FC2_VIDEOMODE_1600x1200YUV422 = 19,
        /** 1600x1200 RGB. */
        FC2_VIDEOMODE_1600x1200RGB = 20,
        /** 1600x1200 8-bit. */
        FC2_VIDEOMODE_1600x1200Y8 = 21,
        /** 1600x1200 16-bit. */
        FC2_VIDEOMODE_1600x1200Y16 = 22,
        /** Custom video mode for Format7 functionality. */
        FC2_VIDEOMODE_FORMAT7 = 23,
        /** Number of possible video modes. */
        FC2_NUM_VIDEOMODES = 24,
        FC2_VIDEOMODE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Camera modes for DCAM formats as well as Format7. */
    /** enum fc2Mode */
    public static final int
        FC2_MODE_0 = 0,
        FC2_MODE_1 = 1,
        FC2_MODE_2 = 2,
        FC2_MODE_3 = 3,
        FC2_MODE_4 = 4,
        FC2_MODE_5 = 5,
        FC2_MODE_6 = 6,
        FC2_MODE_7 = 7,
        FC2_MODE_8 = 8,
        FC2_MODE_9 = 9,
        FC2_MODE_10 = 10,
        FC2_MODE_11 = 11,
        FC2_MODE_12 = 12,
        FC2_MODE_13 = 13,
        FC2_MODE_14 = 14,
        FC2_MODE_15 = 15,
        FC2_MODE_16 = 16,
        FC2_MODE_17 = 17,
        FC2_MODE_18 = 18,
        FC2_MODE_19 = 19,
        FC2_MODE_20 = 20,
        FC2_MODE_21 = 21,
        FC2_MODE_22 = 22,
        FC2_MODE_23 = 23,
        FC2_MODE_24 = 24,
        FC2_MODE_25 = 25,
        FC2_MODE_26 = 26,
        FC2_MODE_27 = 27,
        FC2_MODE_28 = 28,
        FC2_MODE_29 = 29,
        FC2_MODE_30 = 30,
        FC2_MODE_31 = 31,
        /** Number of modes */
        FC2_NUM_MODES = 32,
        FC2_MODE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Pixel formats available for Format7 modes. */
    /** enum fc2PixelFormat */
    public static final int
        /** 8 bits of mono information. */
        FC2_PIXEL_FORMAT_MONO8          = 0x80000000,
        /** YUV 4:1:1. */
        FC2_PIXEL_FORMAT_411YUV8        = 0x40000000,
        /** YUV 4:2:2. */
        FC2_PIXEL_FORMAT_422YUV8        = 0x20000000,
        /** YUV 4:4:4. */
        FC2_PIXEL_FORMAT_444YUV8        = 0x10000000,
        /** R = G = B = 8 bits. */
        FC2_PIXEL_FORMAT_RGB8           = 0x08000000,
        /** 16 bits of mono information. */
        FC2_PIXEL_FORMAT_MONO16         = 0x04000000,
        /** R = G = B = 16 bits. */
        FC2_PIXEL_FORMAT_RGB16          = 0x02000000,
        /** 16 bits of signed mono information. */
        FC2_PIXEL_FORMAT_S_MONO16       = 0x01000000,
        /** R = G = B = 16 bits signed. */
        FC2_PIXEL_FORMAT_S_RGB16        = 0x00800000,
        /** 8 bit raw data output of sensor. */
        FC2_PIXEL_FORMAT_RAW8           = 0x00400000,
        /** 16 bit raw data output of sensor. */
        FC2_PIXEL_FORMAT_RAW16          = 0x00200000,
        /** 12 bits of mono information. */
        FC2_PIXEL_FORMAT_MONO12         = 0x00100000,
        /** 12 bit raw data output of sensor. */
        FC2_PIXEL_FORMAT_RAW12          = 0x00080000,
        /** 24 bit BGR. */
        FC2_PIXEL_FORMAT_BGR            = 0x80000008,
        /** 32 bit BGRU. */
        FC2_PIXEL_FORMAT_BGRU           = 0x40000008,
        /** 24 bit RGB. */
        FC2_PIXEL_FORMAT_RGB            = FC2_PIXEL_FORMAT_RGB8,
        /** 32 bit RGBU. */
        FC2_PIXEL_FORMAT_RGBU           = 0x40000002,
        /** R = G = B = 16 bits. */
        FC2_PIXEL_FORMAT_BGR16          = 0x02000001,
        /** 64 bit BGRU. */
        FC2_PIXEL_FORMAT_BGRU16         = 0x02000002,
        /** JPEG compressed stream. */
        FC2_PIXEL_FORMAT_422YUV8_JPEG   = 0x40000001,
        /** Number of pixel formats. */
        FC2_NUM_PIXEL_FORMATS           = 20,
        /** Unspecified pixel format. */
        FC2_UNSPECIFIED_PIXEL_FORMAT    = 0;

    /** Bus speeds. */
    /** enum fc2BusSpeed */
    public static final int
        /** 100Mbits/sec. */
        FC2_BUSSPEED_S100 = 0,
        /** 200Mbits/sec. */
        FC2_BUSSPEED_S200 = 1,
        /** 400Mbits/sec. */
        FC2_BUSSPEED_S400 = 2,
        /** 480Mbits/sec. Only for USB2 cameras. */
        FC2_BUSSPEED_S480 = 3,
        /** 800Mbits/sec. */
        FC2_BUSSPEED_S800 = 4,
        /** 1600Mbits/sec. */
        FC2_BUSSPEED_S1600 = 5,
        /** 3200Mbits/sec. */
        FC2_BUSSPEED_S3200 = 6,
        /** 5000Mbits/sec. Only for USB3 cameras. */
        FC2_BUSSPEED_S5000 = 7,
        /** 10Base-T. Only for GigE cameras. */
        FC2_BUSSPEED_10BASE_T = 8,
        /** 100Base-T.  Only for GigE cameras.*/
        FC2_BUSSPEED_100BASE_T = 9,
        /** 1000Base-T (Gigabit Ethernet).  Only for GigE cameras. */
        FC2_BUSSPEED_1000BASE_T = 10,
        /** 10000Base-T.  Only for GigE cameras. */
        FC2_BUSSPEED_10000BASE_T = 11,
        /** The fastest speed available. */
        FC2_BUSSPEED_S_FASTEST = 12,
        /** Any speed that is available. */
        FC2_BUSSPEED_ANY = 13,
        /** Unknown bus speed. */
        FC2_BUSSPEED_SPEED_UNKNOWN = -1,
        FC2_BUSSPEED_FORCE_32BITS = FULL_32BIT_VALUE;

    /** enum fc2PCIeBusSpeed */
    public static final int
        FC2_PCIE_BUSSPEED_2_5 = 0, /** 2.5 Gb/s */
        FC2_PCIE_BUSSPEED_5_0 = 1, /** 5.0 Gb/s */
        FC2_PCIE_BUSSPEED_UNKNOWN = -1, /** Speed is unknown */
        FC2_PCIE_BUSSPEED_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Types of low level drivers that FlyCapture uses. */
    /** enum fc2DriverType */
    public static final int
        /** PGRCam.sys. */
        FC2_DRIVER_1394_CAM = 0,
        /** PGR1394.sys. */
        FC2_DRIVER_1394_PRO = 1,
        /** firewire_core. */
        FC2_DRIVER_1394_JUJU = 2,
        /** video1394. */
        FC2_DRIVER_1394_VIDEO1394 = 3,
        /** raw1394. */
        FC2_DRIVER_1394_RAW1394 = 4,
        /** No usb driver used just BSD stack. (Linux only) */
        FC2_DRIVER_USB_NONE = 5,
        /** PGRUsbCam.sys. */
        FC2_DRIVER_USB_CAM = 6,
        /** PGRXHCI.sys. */
        FC2_DRIVER_USB3_PRO = 7,
        /** no GigE drivers used, MS/BSD stack. */
        FC2_DRIVER_GIGE_NONE = 8,
        /** PGRGigE.sys. */
        FC2_DRIVER_GIGE_FILTER = 9,
        /** PGRGigEPro.sys. */
        FC2_DRIVER_GIGE_PRO = 10,
        /** PgrLwf.sys. */
        FC2_DRIVER_GIGE_LWF = 11,
        /** Unknown driver type. */
        FC2_DRIVER_UNKNOWN = -1,
        FC2_DRIVER_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * Color processing algorithms. Please refer to our knowledge base at
     * article at http://www.ptgrey.com/support/kb/index.asp?a=4&q=33 for
     * complete details for each algorithm.
     */
    /** enum fc2ColorProcessingAlgorithm */
    public static final int
        /** Default method. */
        FC2_DEFAULT = 0,
        /** No color processing. */
        FC2_NO_COLOR_PROCESSING = 1,
        /**
         * Fastest but lowest quality. Equivalent to
         * FLYCAPTURE_NEAREST_NEIGHBOR_FAST in FlyCapture.
         */
        FC2_NEAREST_NEIGHBOR_FAST = 2,
        /** Weights surrounding pixels based on localized edge orientation. */
        FC2_EDGE_SENSING = 3,
        /** Well-balanced speed and quality. */
        FC2_HQ_LINEAR = 4,
        /** Slowest but produces good results. */
        FC2_RIGOROUS = 5,
        /** Multithreaded with similar results to edge sensing. */
        FC2_IPP = 6,
        /** Best quality but much faster than rigorous. */
        FC2_DIRECTIONAL = 7,
        /** Weighted pixel average from different directions*/
        FC2_WEIGHTED_DIRECTIONAL = 8,
        FC2_COLOR_PROCESSING_ALGORITHM_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Bayer tile formats. */
    /** enum fc2BayerTileFormat */
    public static final int
        /** No bayer tile format. */
        FC2_BT_NONE = 0,
        /** Red-Green-Green-Blue. */
        FC2_BT_RGGB = 1,
        /** Green-Red-Blue-Green. */
        FC2_BT_GRBG = 2,
        /** Green-Blue-Red-Green. */
        FC2_BT_GBRG = 3,
        /** Blue-Green-Green-Red. */
        FC2_BT_BGGR = 4,
        FC2_BT_FORCE_32BITS = FULL_32BIT_VALUE;

    /** File formats to be used for saving images to disk. */
    /** enum fc2ImageFileFormat */
    public static final int
        /** Determine file format from file extension. */
        FC2_FROM_FILE_EXT = -1,
        /** Portable gray map. */
        FC2_PGM = 0,
        /** Portable pixmap. */
        FC2_PPM = 1,
        /** Bitmap. */
        FC2_BMP = 2,
        /** JPEG. */
        FC2_JPEG = 3,
        /** JPEG 2000. */
        FC2_JPEG2000 = 4,
        /** Tagged image file format. */
        FC2_TIFF = 5,
        /** Portable network graphics. */
        FC2_PNG = 6,
        /** Raw data. */
        FC2_RAW = 7,
        FC2_IMAGE_FILE_FORMAT_FORCE_32BITS = FULL_32BIT_VALUE;

    /*@}*/

    /**
     * \defgroup CGigEEnums GigE specific enumerations
     *
     * These enumerations are specific to GigE camera operation only.
     */

    /*@{*/

    /** Possible properties that can be queried from the camera. */
    /** enum fc2GigEPropertyType */
    public static final int
        FC2_HEARTBEAT = 0,
        FC2_HEARTBEAT_TIMEOUT = 1,
        PACKET_SIZE = 2,
        PACKET_DELAY = 3;

    /*@}*/

    /**
     * Channels that allow statistics to be calculated.
     */
    /** enum fc2StatisticsChannel */
    public static final int
        FC2_STATISTICS_GREY = 0,
        FC2_STATISTICS_RED = 1,
        FC2_STATISTICS_GREEN = 2,
        FC2_STATISTICS_BLUE = 3,
        FC2_STATISTICS_HUE = 4,
        FC2_STATISTICS_SATURATION = 5,
        FC2_STATISTICS_LIGHTNESS = 6,
        FC2_STATISTICS_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Possible operating systems. */
    /** enum fc2OSType */
    public static final int
        /** All Windows 32-bit variants. */
        FC2_WINDOWS_X86 = 0,
        /** All Windows 64-bit variants. */
        FC2_WINDOWS_X64 = 1,
        /** All Linux 32-bit variants. */
        FC2_LINUX_X86 = 2,
        /** All Linux 32-bit variants. */
        FC2_LINUX_X64 = 3,
        /** Mac OSX. */
        FC2_MAC = 4,
        /** Unknown operating system. */
        FC2_UNKNOWN_OS = 5,
        FC2_OSTYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Possible byte orders. */
    /** enum fc2ByteOrder */
    public static final int
        FC2_BYTE_ORDER_LITTLE_ENDIAN = 0,
        FC2_BYTE_ORDER_BIG_ENDIAN = 1,
        FC2_BYTE_ORDER_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * Possible states of a port on a node.
     */
    /** enum fc2PortType */
    public static final int
        NOT_CONNECTED = 1,
        CONNECTED_TO_PARENT = 2,
        CONNECTED_TO_CHILD = 3;

    /**
     * Type of node.
     */
    /** enum fc2NodeType */
    public static final int
        COMPUTER = 0,
        BUS = 1,
        CAMERA = 2,
        NODE = 3;
// Targeting ../FlyCapture2_C/fc2Image.java


// Targeting ../FlyCapture2_C/fc2SystemInfo.java


// Targeting ../FlyCapture2_C/fc2Version.java


// Targeting ../FlyCapture2_C/fc2IPAddress.java


// Targeting ../FlyCapture2_C/fc2MACAddress.java


// Targeting ../FlyCapture2_C/fc2GigEProperty.java


// Targeting ../FlyCapture2_C/fc2GigEStreamChannel.java


// Targeting ../FlyCapture2_C/fc2GigEConfig.java


// Targeting ../FlyCapture2_C/fc2GigEImageSettingsInfo.java


// Targeting ../FlyCapture2_C/fc2GigEImageSettings.java


// Targeting ../FlyCapture2_C/fc2Format7ImageSettings.java


// Targeting ../FlyCapture2_C/fc2Format7Info.java


// Targeting ../FlyCapture2_C/fc2Format7PacketInfo.java


// Targeting ../FlyCapture2_C/fc2Config.java


// Targeting ../FlyCapture2_C/fc2PropertyInfo.java


// Targeting ../FlyCapture2_C/fc2Property.java


// Targeting ../FlyCapture2_C/fc2TriggerModeInfo.java


// Targeting ../FlyCapture2_C/fc2TriggerMode.java


// Targeting ../FlyCapture2_C/fc2StrobeInfo.java


// Targeting ../FlyCapture2_C/fc2StrobeControl.java


// Targeting ../FlyCapture2_C/fc2TimeStamp.java


// Targeting ../FlyCapture2_C/fc2ConfigROM.java


// Targeting ../FlyCapture2_C/fc2CameraInfo.java


// Targeting ../FlyCapture2_C/fc2EmbeddedImageInfoProperty.java


// Targeting ../FlyCapture2_C/fc2EmbeddedImageInfo.java


// Targeting ../FlyCapture2_C/fc2ImageMetadata.java


// Targeting ../FlyCapture2_C/fc2LUTData.java


// Targeting ../FlyCapture2_C/fc2CameraStats.java


// Targeting ../FlyCapture2_C/fc2PNGOption.java


// Targeting ../FlyCapture2_C/fc2PPMOption.java


// Targeting ../FlyCapture2_C/fc2PGMOption.java



    /** enum fc2TIFFCompressionMethod */
    public static final int
        /** Save without any compression. */
        FC2_TIFF_NONE = 1,
        /** Save using PACKBITS compression. */
        FC2_TIFF_PACKBITS = 2,
        /** Save using DEFLATE compression (ZLIB compression). */
        FC2_TIFF_DEFLATE = 3,
        /** Save using ADOBE DEFLATE compression */
        FC2_TIFF_ADOBE_DEFLATE = 4,
        /**
         * Save using CCITT Group 3 fax encoding. This is only valid for
         * 1-bit images only. Default to LZW for other bit depths.
         */
        FC2_TIFF_CCITTFAX3 = 5,
        /**
         * Save using CCITT Group 4 fax encoding. This is only valid for
         * 1-bit images only. Default to LZW for other bit depths.
         */
        FC2_TIFF_CCITTFAX4 = 6,
        /** Save using LZW compression. */
        FC2_TIFF_LZW = 7,
        /**
         * Save using JPEG compression. This is only valid for 8-bit
         * greyscale and 24-bit only. Default to LZW for other bit depths.
         */
        FC2_TIFF_JPEG = 8;
// Targeting ../FlyCapture2_C/fc2TIFFOption.java


// Targeting ../FlyCapture2_C/fc2JPEGOption.java


// Targeting ../FlyCapture2_C/fc2JPG2Option.java


// Targeting ../FlyCapture2_C/fc2BMPOption.java


// Targeting ../FlyCapture2_C/fc2CallbackHandle.java


// Targeting ../FlyCapture2_C/fc2BusEventCallback.java


// Targeting ../FlyCapture2_C/fc2ImageEventCallback.java


// Targeting ../FlyCapture2_C/fc2AsyncCommandCallback.java


// Targeting ../FlyCapture2_C/fc2CameraEventCallback.java


// Targeting ../FlyCapture2_C/fc2EventOptions.java


// Targeting ../FlyCapture2_C/fc2EventCallbackData.java



    /*@}*/

    /*@}*/

// #ifdef __cplusplus
// #endif

// #endif // FLIR_FLYCAPTURE2DEFS_C_H

// Parsed from <FlyCapture2_C.h>

//=============================================================================
// Copyright (c) 2001-2018 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_FLYCAPTURE2_C_H
// #define FLIR_FLYCAPTURE2_C_H

//=============================================================================
// Global C header file for FlyCapture2.
//
// This file defines the C API for FlyCapture2
//=============================================================================

// #include "FlyCapture2Platform_C.h"
// #include "FlyCapture2Defs_C.h"

// #ifdef __cplusplus
// #endif

    /**
     * Create a FC2 context for IIDC camera.
     * This call must be made before any other calls that use a context
     * will succeed.
     *
     * @see fc2DestroyContext()
     *
     * @param pContext A pointer to the fc2Context to be created.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2CreateContext(
                    @Cast("fc2Context*") @ByPtrPtr fc2Context pContext );

    /**
     * Create a FC2 context for a GigE Vision camera.
     * This call must be made before any other calls that use a context
     * will succeed.
     *
     * @see fc2DestroyContext()
     *
     * @param pContext A pointer to the fc2Context to be created.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2CreateGigEContext(
                    @Cast("fc2Context*") @ByPtrPtr fc2Context pContext );

    /**
     * Destroy the FC2 context. This must be called when the user is finished
     * with the context in order to prevent memory leaks.
     *
     * @see fc2CreateContext()
     *
     * @param context The context to be destroyed.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DestroyContext(
                    fc2Context context );

    /**
    * \defgroup CBusManager Bus Manager Operation
    *
    * \brief The functions in this section provide access to BusManager
    * operations
    */
    /*@{*/

    /**
     * Fire a bus reset. The actual bus reset is only fired for the
     * specified 1394 bus, but it will effectively cause a global bus
     * reset for the library.
     *
     * @param context The fc2Context to be used.
     * @param pGuid PGRGuid of the camera or the device to cause bus reset.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2FireBusReset(
                    fc2Context context,
                    fc2PGRGuid pGuid);

    /**
     * Gets the number of cameras attached to the PC.
     *
     * @param context The fc2Context to be used.
     * @param pNumCameras Number of cameras detected.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetNumOfCameras(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer pNumCameras );
    public static native @Cast("fc2Error") int fc2GetNumOfCameras(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer pNumCameras );
    public static native @Cast("fc2Error") int fc2GetNumOfCameras(
                    fc2Context context,
                    @Cast("unsigned int*") int[] pNumCameras );

    /**
    * Gets the PGRGuid for a camera with the specified IPv4 address.
    *
    * @param context The fc2Context to be used.
    * @param ipAddress IP address to get GUID for.
    * @param pGuid Unique PGRGuid for the camera.
    *
    * @return A fc2Error indicating the success or failure of the function.
    */
    public static native @Cast("fc2Error") int fc2GetCameraFromIPAddress(
                fc2Context context,
                @ByVal fc2IPAddress ipAddress,
                fc2PGRGuid pGuid);

    /**
    * Gets the PGRGuid for a camera on the PC. It uniquely identifies
    * the camera specified by the index and is used to identify the camera
    * during a fc2Connect() call.
    *
    * @param context The fc2Context to be used.
    * @param index Zero based index of camera.
    * @param pGuid Unique PGRGuid for the camera.
    *
    * @return A fc2Error indicating the success or failure of the function.
    */
    public static native @Cast("fc2Error") int fc2GetCameraFromIndex(
                fc2Context context,
                @Cast("unsigned int") int index,
                fc2PGRGuid pGuid);

    /**
     * Gets the PGRGuid for a camera on the PC. It uniquely identifies
     * the camera specified by the serial number and is used to identify the camera
     * during a fc2Connect() call.
     *
     * @param context The fc2Context to be used.
     * @param serialNumber Serial number of camera.
     * @param pGuid Unique PGRGuid for the camera.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetCameraFromSerialNumber(
                    fc2Context context,
                    @Cast("unsigned int") int serialNumber,
                    fc2PGRGuid pGuid );

    /**
     * Gets the serial number of the camera with the specified index.
     *
     * @param context The fc2Context to be used.
     * @param index Zero based index of desired camera.
     * @param pSerialNumber Serial number of camera.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetCameraSerialNumberFromIndex(
                    fc2Context context,
                    @Cast("unsigned int") int index,
                    @Cast("unsigned int*") IntPointer pSerialNumber );
    public static native @Cast("fc2Error") int fc2GetCameraSerialNumberFromIndex(
                    fc2Context context,
                    @Cast("unsigned int") int index,
                    @Cast("unsigned int*") IntBuffer pSerialNumber );
    public static native @Cast("fc2Error") int fc2GetCameraSerialNumberFromIndex(
                    fc2Context context,
                    @Cast("unsigned int") int index,
                    @Cast("unsigned int*") int[] pSerialNumber );

    /**
     * Gets the interface type associated with a PGRGuid. This is useful
     * in situations where there is a need to enumerate all cameras
     * for a particular interface.
     *
     * @param context The fc2Context to be used.
     * @param pGuid The PGRGuid to get the interface for.
     * @param pInterfaceType The interface type of the PGRGuid.
     *
     * @return
     */
    public static native @Cast("fc2Error") int fc2GetInterfaceTypeFromGuid(
                    fc2Context context,
                    fc2PGRGuid pGuid,
                    @Cast("fc2InterfaceType*") IntPointer pInterfaceType );
    public static native @Cast("fc2Error") int fc2GetInterfaceTypeFromGuid(
                    fc2Context context,
                    fc2PGRGuid pGuid,
                    @Cast("fc2InterfaceType*") IntBuffer pInterfaceType );
    public static native @Cast("fc2Error") int fc2GetInterfaceTypeFromGuid(
                    fc2Context context,
                    fc2PGRGuid pGuid,
                    @Cast("fc2InterfaceType*") int[] pInterfaceType );

    /**
     * Gets the number of devices. This may include hubs, host controllers
     * and other hardware devices (including cameras).
     *
     * @param context The fc2Context to be used.
     * @param pNumDevices The number of devices found.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetNumOfDevices(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer pNumDevices );
    public static native @Cast("fc2Error") int fc2GetNumOfDevices(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer pNumDevices );
    public static native @Cast("fc2Error") int fc2GetNumOfDevices(
                    fc2Context context,
                    @Cast("unsigned int*") int[] pNumDevices );

    /**
     * Gets the PGRGuid for a device. It uniquely identifies the device
     * specified by the index.
     *
     * @param context The fc2Context to be used.
     * @param index Zero based index of device.
     * @param pGuid Unique PGRGuid for the device.
     *
     * @see fc2GetNumOfDevices()
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetDeviceFromIndex(
                    fc2Context context,
                    @Cast("unsigned int") int index,
                    fc2PGRGuid pGuid );

    /**
        * Read a phy register on the specified device. The full address
        * to be read from is determined by the page, port and address.
        *
        * @param context The fc2Context to be used.
        * @param guid Unique PGRGuid for the device.
        * @param page Page to read from.
        * @param port Port to read from.
        * @param address Address to read from.
        * @param pValue Value read from the phy register.
        *
        * @return An Error indicating the success or failure of the function.
        */
    public static native @Cast("fc2Error") int fc2ReadPhyRegister(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int") int page,
                @Cast("unsigned int") int port,
                @Cast("unsigned int") int _address,
                @Cast("unsigned int*") IntPointer pValue );
    public static native @Cast("fc2Error") int fc2ReadPhyRegister(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int") int page,
                @Cast("unsigned int") int port,
                @Cast("unsigned int") int _address,
                @Cast("unsigned int*") IntBuffer pValue );
    public static native @Cast("fc2Error") int fc2ReadPhyRegister(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int") int page,
                @Cast("unsigned int") int port,
                @Cast("unsigned int") int _address,
                @Cast("unsigned int*") int[] pValue );

    /**
     * Write a phy register on the specified device. The full address
     * to be written to is determined by the page, port and address.
     *
     * @param context The fc2Context to be used.
     * @param guid Unique PGRGuid for the device.
     * @param page Page to write to.
     * @param port Port to write to.
     * @param address Address to write to.
     * @param value Value to write to phy register.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WritePhyRegister(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int") int page,
                @Cast("unsigned int") int port,
                @Cast("unsigned int") int _address,
                @Cast("unsigned int") int value );

    /**
     * Read usb link info for the port that the specified device is connected to.
     *
     * @param context The fc2Context to be used.
     * @param guid Unique PGRGuid for the device.
     * @param pValue Value read from the card register.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetUsbLinkInfo(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int*") IntPointer pValue );
    public static native @Cast("fc2Error") int fc2GetUsbLinkInfo(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int*") IntBuffer pValue );
    public static native @Cast("fc2Error") int fc2GetUsbLinkInfo(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int*") int[] pValue );

    /**
     * Read usb port status for the port that the specified device is connected to.
     *
     * @param context The fc2Context to be used.
     * @param guid Unique PGRGuid for the device.
     * @param pValue Value read from the card register.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetUsbPortStatus(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int*") IntPointer pValue );
    public static native @Cast("fc2Error") int fc2GetUsbPortStatus(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int*") IntBuffer pValue );
    public static native @Cast("fc2Error") int fc2GetUsbPortStatus(
                fc2Context context,
                @ByVal fc2PGRGuid guid,
                @Cast("unsigned int*") int[] pValue );

    /**
     * Gets the topology information for the PC.
     *
     * @param context The fc2Context to be used.
     * @param pTopologyNodeContext A Topology Node context that will contain
     *                             the topology information
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetTopology(
                fc2Context context,
                @ByPtrPtr fc2TopologyNodeContext pTopologyNodeContext );

    /**
     * Register a callback function that will be called when the
     * specified callback event occurs.
     *
     * @param context The fc2Context to be used.
     * @param enumCallback Pointer to function that will receive the callback.
     * @param callbackType Type of callback to register for.
     * @param pParameter Callback parameter to be passed to callback.
     * @param pCallbackHandle Unique callback handle used for unregistering
     *                        callback.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2RegisterCallback(
                    fc2Context context,
                    fc2BusEventCallback enumCallback,
                    @Cast("fc2BusCallbackType") int callbackType,
                    Pointer pParameter,
                    @ByPtrPtr fc2CallbackHandle pCallbackHandle );

    /**
     * Unregister a callback function.
     *
     * @param context The fc2Context to be used.
     * @param callbackHandle Unique callback handle.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2UnregisterCallback(
                    fc2Context context,
                    fc2CallbackHandle callbackHandle );

    /**
     * Force a rescan of the buses. This does not trigger a bus reset.
     * The camera objects will be invalidated only if the camera network
     * topology is changed (ie. a camera is disconnected or added)
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2RescanBus( fc2Context context);

    /**
     * Force the camera with the specific MAC address to the specified
     * IP address, subnet mask and default gateway. This is useful in
     * situations where a GigE Vision camera is using Persistent IP and the
     * application's subnet is different from the device subnet.
     *
     * @param context The fc2Context to be used.
     * @param macAddress MAC address of the camera.
     * @param ipAddress IP address to set on the camera.
     * @param subnetMask Subnet mask to set on the camera.
     * @param defaultGateway Default gateway to set on the camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ForceIPAddressToCamera(
                    fc2Context context,
                    @ByVal fc2MACAddress macAddress,
                    @ByVal fc2IPAddress ipAddress,
                    @ByVal fc2IPAddress subnetMask,
                    @ByVal fc2IPAddress defaultGateway );

    /**
     * Force all cameras on the network to be assigned sequential IP addresses
     * on the same subnet as the network adapters that they are connected to.
     * This is useful in situations where GigE Vision cameras are using
     * IP addresses in a subnet different from the host's subnet.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ForceAllIPAddressesAutomatically();

    /**
     * Force cameras on the network to be assigned sequential IP addresses
     * on the same subnet as the network adapters that it is connected to.
     * This is useful in situations where GigE Vision cameras are using
     * IP addresses in a subnet different from the host's subnet.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ForceIPAddressAutomatically(@Cast("unsigned int") int serialNumber);

    /**
     * Discover all cameras connected to the network even if they reside
     * on a different subnet. This is useful in situations where a GigE
     * camera is using Persistent IP and the application's subnet is
     * different from the device subnet. After discovering the camera,
     * it is easy to use ForceIPAddressToCamera() to set a different IP
     * configuration.
     *
     * @param context The fc2Context to be used.
     * @param gigECameras Pointer to an array of CameraInfo structures.
     * @param arraySize Size of the array. Number of discovered cameras
     *                  is returned in the same value.
     *
     * @return An Error indicating the success or failure of the function.
     *         If the error is PGRERROR_BUFFER_TOO_SMALL then arraySize will
     *         contain the minimum size needed for gigECameras array.
     */
    public static native @Cast("fc2Error") int fc2DiscoverGigECameras(
                    fc2Context context,
                    fc2CameraInfo gigECameras,
                    @Cast("unsigned int*") IntPointer arraySize  );
    public static native @Cast("fc2Error") int fc2DiscoverGigECameras(
                    fc2Context context,
                    fc2CameraInfo gigECameras,
                    @Cast("unsigned int*") IntBuffer arraySize  );
    public static native @Cast("fc2Error") int fc2DiscoverGigECameras(
                    fc2Context context,
                    fc2CameraInfo gigECameras,
                    @Cast("unsigned int*") int[] arraySize  );

    /**
    * Query whether a GigE camera is controllable.
    *
    * @param context The fc2Context to be used.
    * @param pGuid Unique PGRGuid for the camera.
    * @param pControllable True indicates camera is controllable
    *
    * @return A fc2Error indicating the success or failure of the function.
    */
    public static native @Cast("fc2Error") int fc2IsCameraControlable(
                fc2Context context,
                fc2PGRGuid pGuid,
                @Cast("BOOL*") IntPointer pControlable);
    public static native @Cast("fc2Error") int fc2IsCameraControlable(
                fc2Context context,
                fc2PGRGuid pGuid,
                @Cast("BOOL*") IntBuffer pControlable);
    public static native @Cast("fc2Error") int fc2IsCameraControlable(
                fc2Context context,
                fc2PGRGuid pGuid,
                @Cast("BOOL*") int[] pControlable);
    /*@}*/

    /**
    * \defgroup CConnectionAndImage Connection and Image Retrieval
    *
    * \brief These functions deal with connections and image retrieval from
    * the camera.
    */
    /*@{*/

    /**
     * Connects the fc2Context to the camera specified by the GUID.
     *
     * Be aware that calling fc2CreateGUIContext() releases the CCP acquired
     * for GigE cameras in fc2Connect(). Consider calling fc2Connect() after
     * fc2CreateGUIContext().
     *
     * @param context The fc2Context to be used.
     * @param guid The unique identifier for a specific camera on the PC.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2Connect(
                    fc2Context context,
                    fc2PGRGuid guid );

    /**
     * Disconnects the fc2Context from the camera. This allows another physical
     * camera specified by a GUID to be connected to the fc2Context.
     *
     * @see fc2Connect()
     *
     * @param context The fc2Context to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2Disconnect(
                    fc2Context context );

    /**
    * Checks if the fc2Context is connected to a physical camera
    * specified by a GUID.
    *
    * @see fc2Connect()
    * @see fc2Disconnect()
    *
    * @param context The fc2Context to be used.
    *
    * @return Whether fc2Connect() was called on the fc2Context.
    */
    public static native @Cast("BOOL") int fc2IsConnected(
                    fc2Context context );

    /**
     * Sets the callback data to be used on completion of image transfer.
     * To clear the current stored callback data, pass in NULL for both
     * callback arguments.
     *
     * @see fc2StartCapture()
     *
     * @param context The fc2Context to be used.
     * @param pCallbackFn A function to be called when a new image is received.
     * @param pCallbackData A pointer to data that can be passed to the
     *                      callback function.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetCallback(
                    fc2Context context,
                    fc2ImageEventCallback pCallbackFn,
                    Pointer pCallbackData);

    /**
     * Starts isochronous image capture. It will use either the current
     * video mode or the most recently set video mode of the camera.
     *
     * @see fc2RetrieveBuffer()
     * @see fc2StartSyncCapture()
     * @see fc2StopCapture()
     *
     * @param context The fc2Context to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2StartCapture(
                    fc2Context context );

    /**
     * Starts isochronous image capture. It will use either the current
     * video mode or the most recently set video mode of the camera. The callback
     * function is called when a new image is received from the camera.
     *
     * @see fc2RetrieveBuffer()
     * @see fc2StartSyncCapture()
     * @see fc2StopCapture()
     *
     * @param context The fc2Context to be used.
     * @param pCallbackFn A function to be called when a new image is received.
     * @param pCallbackData A pointer to data that can be passed to the
     *                      callback function. A NULL pointer is acceptable.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2StartCaptureCallback(
                    fc2Context context,
                    fc2ImageEventCallback pCallbackFn,
                    Pointer pCallbackData);

    /**
     * Starts synchronized isochronous image capture on multiple cameras.
     * This function is only used for firewire cameras.
     *
     * @see fc2RetrieveBuffer()
     * @see fc2StartCapture()
     * @see fc2StopCapture()
     *
     * @param numCameras Number of fc2Contexts in the ppCameras array.
     * @param pContexts Array of fc2Contexts.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2StartSyncCapture(
                    @Cast("unsigned int") int numCameras,
                    @Cast("fc2Context*") @ByPtrPtr fc2Context pContexts );

    /**
     * Starts synchronized isochronous image capture on multiple cameras.
     * This function is only used for firewire cameras.
     *
     * @see fc2RetrieveBuffer()
     * @see fc2StartCapture()
     * @see fc2StopCapture()
     *
     * @param numCameras Number of fc2Contexts in the ppCameras array.
     * @param pContexts Array of fc2Contexts.
     * @param pCallbackFns Array of callback functions for each camera.
     * @param pCallbackDataArray Array of callback data pointers.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2StartSyncCaptureCallback(
                    @Cast("unsigned int") int numCameras,
                    @Cast("fc2Context*") @ByPtrPtr fc2Context pContexts,
                    @Cast("fc2ImageEventCallback*") @ByPtrPtr fc2ImageEventCallback pCallbackFns,
                    @Cast("void**") PointerPointer pCallbackDataArray);
    public static native @Cast("fc2Error") int fc2StartSyncCaptureCallback(
                    @Cast("unsigned int") int numCameras,
                    @Cast("fc2Context*") @ByPtrPtr fc2Context pContexts,
                    @Cast("fc2ImageEventCallback*") @ByPtrPtr fc2ImageEventCallback pCallbackFns,
                    @Cast("void**") @ByPtrPtr Pointer pCallbackDataArray);

    /**
     * Retrieves the next image object containing the next image.
     *
     * @see fc2StartCapture()
     * @see fc2StopCapture()
     *
     * @param context The fc2Context to be used.
     * @param pImage Pointer to fc2Image to store image data.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2RetrieveBuffer(
                    fc2Context context,
                    fc2Image pImage );

    /**
     * Stops isochronous image transfer and cleans up all associated
     * resources.
     *
     * @see fc2StartCapture()
     * @see fc2RetrieveBuffer()
     *
     * @param context The fc2Context to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2StopCapture(
                    fc2Context context );

    /**
     * Retrieves the next image event containing the next part of the image.
     *
     * @see fc2StartCapture()
     * @see fc2RetrieveBuffer()
     * @see fc2StopCapture()
     *
     * @param context The fc2Context to be used.
     * @param pImage Pointer to fc2Image to store image data.
     * @param eventNumber The event number to wait for.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WaitForBufferEvent(
                fc2Context context,
                fc2Image pImage,
                @Cast("unsigned int") int eventNumber );

    /**
     * Specify user allocated buffers to use as image data buffers.
     * To prevent image tearing, the size of each buffer should be equal to
     * ((unsigned int)(bufferSize + packetSize - 1)/packetSize) * packetSize.
     * The total size should be (size * numBuffers) or larger.
     * The packet Size that should be used differs between interfaces:
     *  Firewire:   Use the Format7 packet size.
     *  Usb2:       First round to Format7 packet size then round to 512 bytes.
     *  Usb3:       Use a packet size of 1024 bytes.
     *  GigE:       No need to do any rounding on GigE
     *
     * @see fc2StartCapture()
     * @see fc2RetrieveBuffer()
     * @see fc2StopCapture()
     *
     * @param context The fc2Context to be used.
     * @param ppMemBuffers Pointer to memory buffers to be written to. The
     *                     size of the data should be equal to
     *                     (size * numBuffers) or larger.
     * @param size The size of each buffer (in bytes).
     * @param nNumBuffers Number of buffers in the array.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetUserBuffers(
                    fc2Context context,
                    @Cast("unsigned char*const") BytePointer ppMemBuffers,
                    int size,
                    int nNumBuffers );
    public static native @Cast("fc2Error") int fc2SetUserBuffers(
                    fc2Context context,
                    @Cast("unsigned char*const") ByteBuffer ppMemBuffers,
                    int size,
                    int nNumBuffers );
    public static native @Cast("fc2Error") int fc2SetUserBuffers(
                    fc2Context context,
                    @Cast("unsigned char*const") byte[] ppMemBuffers,
                    int size,
                    int nNumBuffers );

    /**
     * Get the configuration associated with the camera.
     *
     * @see fc2SetConfiguration()
     *
     * @param context The fc2Context to be used.
     * @param config Pointer to the configuration structure to be filled.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetConfiguration(
                    fc2Context context,
                    fc2Config config );

    /**
     * Set the configuration associated with the camera.
     *
     * @see fc2GetConfiguration()
     *
     * @param context The fc2Context to be used.
     * @param config Pointer to the configuration structure to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetConfiguration(
                    fc2Context context,
                    fc2Config config );
    /*@}*/

    /**
    * \defgroup CInformationProperties Information and Properties
    *
    * \brief These functions deal with information and properties can be
    * retrieved from the camera.
    */
    /*@{*/

    /**
     * Retrieves information from the camera such as serial number, model
     * name and other camera information.
     *
     * @param context The fc2Context to be used.
     * @param pCameraInfo Pointer to the camera information structure
     *                    to be filled.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetCameraInfo(
                    fc2Context context,
                    fc2CameraInfo pCameraInfo );

    /**
     * Retrieves information about the specified camera property. The
     * property type must be specified in the fc2PropertyInfo structure
     * passed into the function in order for the function to succeed.
     *
     * @see fc2GetProperty()
     * @see fc2SetProperty()
     *
     * @param context The fc2Context to be used.
     * @param propInfo Pointer to the PropertyInfo structure to be filled.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetPropertyInfo(
                    fc2Context context,
                    fc2PropertyInfo propInfo );

    /**
     * Reads the settings for the specified property from the camera. The
     * property type must be specified in the fc2Property structure passed
     * into the function in order for the function to succeed. If auto
     * is on, the integer and abs values returned may not be consistent
     * with each other.
     *
     * @see fc2GetPropertyInfo()
     * @see fc2SetProperty()
     *
     * @param context The fc2Context to be used.
     * @param prop Pointer to the Property structure to be filled.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetProperty(
                    fc2Context context,
                    fc2Property prop );

    /**
     * Writes the settings for the specified property to the camera. The
     * property type must be specified in the Property structure passed
     * into the function in order for the function to succeed.
     * The absControl flag controls whether the absolute or integer value
     * is written to the camera. Use fc2GetPropertyInfo() to query which
     * options are available for a specific property.
     *
     * @see fc2GetPropertyInfo()
     * @see fc2GetProperty()
     *
     * @param context The fc2Context to be used.
     * @param prop Pointer to the Property structure to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetProperty(
                    fc2Context context,
                    fc2Property prop );

    /**
     * Writes the settings for the specified property to the camera. The
     * property type must be specified in the Property structure passed
     * into the function in order for the function to succeed.
     * The absControl flag controls whether the absolute or integer value
     * is written to the camera.
     *
     * @param context The fc2Context to be used.
     * @param prop Pointer to the Property structure to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetPropertyBroadcast(
                    fc2Context context,
                    fc2Property prop );
    /*@}*/

    /**
    * \defgroup CGeneralPurposeIO General Purpose Input / Output
    *
    * \brief These functions deal with general GPIO pin control on the camera.
    */
    /*@{*/

    /**
     * Get the GPIO pin direction for the specified pin. This is not a
     * required call when using the trigger or strobe functions as
     * the pin direction is set automatically internally.
     *
     * @see fc2SetGPIOPinDirection()
     * @see fc2SetGPIOPinDirectionBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param pin Pin to get the direction for.
     * @param pDirection Direction of the pin. 0 for input, 1 for output.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGPIOPinDirection(
                    fc2Context context,
                    @Cast("unsigned int") int pin,
                    @Cast("unsigned int*") IntPointer pDirection );
    public static native @Cast("fc2Error") int fc2GetGPIOPinDirection(
                    fc2Context context,
                    @Cast("unsigned int") int pin,
                    @Cast("unsigned int*") IntBuffer pDirection );
    public static native @Cast("fc2Error") int fc2GetGPIOPinDirection(
                    fc2Context context,
                    @Cast("unsigned int") int pin,
                    @Cast("unsigned int*") int[] pDirection );

    /**
     * Set the GPIO pin direction for the specified pin. This is useful if
     * there is a need to set the pin into an input pin (i.e. to read the
     * voltage) off the pin without setting it as a trigger source. This
     * is not a required call when using the trigger or strobe functions as
     * the pin direction is set automatically internally.
     *
     * @see fc2GetGPIOPinDirection()
     * @see fc2SetGPIOPinDirectionBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param pin Pin to get the direction for.
     * @param direction Direction of the pin. 0 for input, 1 for output.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGPIOPinDirection(
                    fc2Context context,
                    @Cast("unsigned int") int pin,
                    @Cast("unsigned int") int direction);

    /**
     * Set the GPIO pin direction for the specified pin. This is useful if
     * there is a need to set the pin into an input pin (i.e. to read the
     * voltage) off the pin without setting it as a trigger source. This
     * is not a required call when using the trigger or strobe functions as
     * the pin direction is set automatically internally.
     *
     * @see fc2GetGPIOPinDirection()
     *
     * @param context The fc2Context to be used.
     * @param pin Pin to get the direction for.
     * @param direction Direction of the pin. 0 for input, 1 for output.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGPIOPinDirectionBroadcast(
                    fc2Context context,
                    @Cast("unsigned int") int pin,
                    @Cast("unsigned int") int direction);
    /*@}*/

    /**
    * \defgroup CTrigger Trigger
    *
    * \brief These functions deal with trigger control on the camera.
    */
    /*@{*/

    /**
     * Retrieve trigger information from the camera.
     *
     * @see fc2GetTriggerMode()
     * @see fc2SetTriggerMode()
     * @see fc2SetTriggerModeBroadcast()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelay()
     *
     * @param context The fc2Context to be used.
     * @param triggerModeInfo Structure to receive trigger information.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetTriggerModeInfo(
                    fc2Context context,
                    fc2TriggerModeInfo triggerModeInfo );

    /**
     * Retrieve current trigger settings from the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2SetTriggerMode()
     * @see fc2SetTriggerModeBroadcast()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelay()
     *
     * @param context The fc2Context to be used.
     * @param triggerMode Structure to receive trigger mode settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetTriggerMode(
                    fc2Context context,
                    fc2TriggerMode triggerMode );

    /**
     * Set the specified trigger settings to the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2GetTriggerMode()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelay()
     * @see fc2SetTriggerModeBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param triggerMode Structure providing trigger mode settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetTriggerMode(
                    fc2Context context,
                    fc2TriggerMode triggerMode );

    /**
     * Set the specified trigger settings to the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2GetTriggerMode()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelay()
     * @see fc2SetTriggerMode()
     *
     * @param context The fc2Context to be used.
     * @param triggerMode Structure providing trigger mode settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetTriggerModeBroadcast(
                    fc2Context context,
                    fc2TriggerMode triggerMode );

    /**
     * Fire the software trigger according to the DCAM specifications.
     *
     * @param context The fc2Context to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2FireSoftwareTrigger(
                    fc2Context context );

    /**
     * Fire the software trigger according to the DCAM specifications.
     *
     * @param context The fc2Context to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2FireSoftwareTriggerBroadcast(
                    fc2Context context );

    /**
     * Retrieve trigger delay information from the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2GetTriggerMode()
     * @see fc2SetTriggerMode()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelay()
     * @see fc2SetTriggerDelayBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param triggerDelayInfo Structure to receive trigger delay information.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetTriggerDelayInfo(
                    fc2Context context,
                    @Cast("fc2TriggerDelayInfo*") fc2PropertyInfo triggerDelayInfo );

    /**
     * Retrieve current trigger delay settings from the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2GetTriggerMode()
     * @see fc2SetTriggerMode()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2SetTriggerDelay()
     * @see fc2SetTriggerDelayBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param triggerDelay Structure to receive trigger delay settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetTriggerDelay(
                    fc2Context context,
                    @Cast("fc2TriggerDelay*") fc2Property triggerDelay );

    /**
     * Set the specified trigger delay settings to the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2GetTriggerMode()
     * @see fc2SetTriggerMode()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelayBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param triggerDelay Structure providing trigger delay settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetTriggerDelay(
                    fc2Context context,
                    @Cast("fc2TriggerDelay*") fc2Property triggerDelay );

    /**
     * Set the specified trigger delay settings to the camera.
     *
     * @see fc2GetTriggerModeInfo()
     * @see fc2GetTriggerMode()
     * @see fc2SetTriggerMode()
     * @see fc2GetTriggerDelayInfo()
     * @see fc2GetTriggerDelay()
     * @see fc2SetTriggerDelay()
     *
     * @param context The fc2Context to be used.
     * @param triggerDelay Structure providing trigger delay settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetTriggerDelayBroadcast(
                    fc2Context context,
                    @Cast("fc2TriggerDelay*") fc2Property triggerDelay );
    /*@}*/

    /**
    * \defgroup CStrobe Strobe
    *
    * \brief These functions deal with strobe control on the camera.
    */
    /*@{*/

    /**
     * Retrieve strobe information from the camera.
     *
     * @see fc2GetStrobe()
     * @see fc2SetStrobe()
     * @see fc2SetStrobeBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param strobeInfo Structure to receive strobe information.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetStrobeInfo(
                    fc2Context context,
                    fc2StrobeInfo strobeInfo );

    /**
     * Retrieve current strobe settings from the camera. The strobe pin
     * must be specified in the structure before being passed in to
     * the function.
     *
     * @see fc2GetStrobeInfo()
     * @see fc2SetStrobe()
     * @see fc2SetStrobeBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param strobeControl Structure to receive strobe settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetStrobe(
                    fc2Context context,
                    fc2StrobeControl strobeControl );

    /**
     * Set current strobe settings to the camera. The strobe pin
     * must be specified in the structure before being passed in to
     * the function.
     *
     * @see fc2GetStrobeInfo()
     * @see fc2GetStrobe()
     * @see fc2SetStrobeBroadcast()
     *
     * @param context The fc2Context to be used.
     * @param strobeControl Structure providing strobe settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetStrobe(
                    fc2Context context,
                    fc2StrobeControl strobeControl );

    /**
     * Set current strobe settings to the camera. The strobe pin
     * must be specified in the structure before being passed in to
     * the function.
     *
     * @see fc2GetStrobeInfo()
     * @see fc2GetStrobe()
     * @see fc2SetStrobe()
     *
     * @param context The fc2Context to be used.
     * @param strobeControl Structure providing strobe settings.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetStrobeBroadcast(
                    fc2Context context,
                    fc2StrobeControl strobeControl );
    /*@}*/

    /**
    * \defgroup CLookUp Look Up Table
    *
    * \brief These functions deal with Look Up Table control on the camera.
    */
    /*@{*/

    /**
     * Query if LUT support is available on the camera. Note that some cameras
     * may report support for the LUT and return an inputBitDepth of 0. In these
     * cases use log2(numEntries) for the inputBitDepth.
     *
     * @see fc2EnableLUT()
     * @see fc2GetLUTChannel()
     * @see fc2SetLUTChannel()
     *
     * @param context The fc2Context to be used.
     * @param pData The LUT structure to be filled.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetLUTInfo(
                    fc2Context context,
                    fc2LUTData pData );

    /**
     * Query the read/write status of a single LUT bank.
     *
     * @param context The fc2Context to be used.
     * @param bank The bank to query.
     * @param pReadSupported Whether reading from the bank is supported.
     * @param pWriteSupported Whether writing to the bank is supported.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetLUTBankInfo(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("BOOL*") IntPointer pReadSupported,
                    @Cast("BOOL*") IntPointer pWriteSupported );
    public static native @Cast("fc2Error") int fc2GetLUTBankInfo(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("BOOL*") IntBuffer pReadSupported,
                    @Cast("BOOL*") IntBuffer pWriteSupported );
    public static native @Cast("fc2Error") int fc2GetLUTBankInfo(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("BOOL*") int[] pReadSupported,
                    @Cast("BOOL*") int[] pWriteSupported );

    /**
     * Get the LUT bank that is currently being used. For cameras with
     * PGR LUT, the active bank is always 0.
     *
     * @param context The fc2Context to be used.
     * @param pActiveBank The currently active bank.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetActiveLUTBank(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer pActiveBank );
    public static native @Cast("fc2Error") int fc2GetActiveLUTBank(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer pActiveBank );
    public static native @Cast("fc2Error") int fc2GetActiveLUTBank(
                    fc2Context context,
                    @Cast("unsigned int*") int[] pActiveBank );

    /**
     * Set the LUT bank that will be used.
     *
     * @param context The fc2Context to be used.
     * @param activeBank The bank to be set as active.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetActiveLUTBank(
                    fc2Context context,
                    @Cast("unsigned int") int activeBank );

    /**
     * Enable or disable LUT functionality on the camera.
     *
     * @see fc2GetLUTInfo()
     * @see fc2GetLUTChannel()
     * @see fc2SetLUTChannel()
     *
     * @param context The fc2Context to be used.
     * @param on Whether to enable or disable LUT.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2EnableLUT(
                    fc2Context context,
                    @Cast("BOOL") int on );

    /**
     * Get the LUT channel settings from the camera.
     *
     * @see fc2GetLUTInfo()
     * @see fc2EnableLUT()
     * @see fc2SetLUTChannel()
     *
     * @param context The fc2Context to be used.
     * @param bank Bank to retrieve.
     * @param channel Channel to retrieve.
     * @param sizeEntries Number of entries in LUT table to read.
     * @param pEntries Array to store LUT entries.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetLUTChannel(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("unsigned int") int channel,
                    @Cast("unsigned int") int sizeEntries,
                    @Cast("unsigned int*") IntPointer pEntries );
    public static native @Cast("fc2Error") int fc2GetLUTChannel(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("unsigned int") int channel,
                    @Cast("unsigned int") int sizeEntries,
                    @Cast("unsigned int*") IntBuffer pEntries );
    public static native @Cast("fc2Error") int fc2GetLUTChannel(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("unsigned int") int channel,
                    @Cast("unsigned int") int sizeEntries,
                    @Cast("unsigned int*") int[] pEntries );

    /**
     * Set the LUT channel settings to the camera.
     *
     * @see fc2GetLUTInfo()
     * @see fc2EnableLUT()
     * @see fc2GetLUTChannel()
     *
     * @param context The fc2Context to be used.
     * @param bank Bank to set.
     * @param channel Channel to set.
     * @param sizeEntries Number of entries in LUT table to write. This must be the
     *                    same size as numEntries returned by GetLutInfo().
     * @param pEntries Array containing LUT entries to write.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetLUTChannel(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("unsigned int") int channel,
                    @Cast("unsigned int") int sizeEntries,
                    @Cast("unsigned int*") IntPointer pEntries );
    public static native @Cast("fc2Error") int fc2SetLUTChannel(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("unsigned int") int channel,
                    @Cast("unsigned int") int sizeEntries,
                    @Cast("unsigned int*") IntBuffer pEntries );
    public static native @Cast("fc2Error") int fc2SetLUTChannel(
                    fc2Context context,
                    @Cast("unsigned int") int bank,
                    @Cast("unsigned int") int channel,
                    @Cast("unsigned int") int sizeEntries,
                    @Cast("unsigned int*") int[] pEntries );
    /*@}*/

    /**
    * \defgroup CMemoryChannel Memory Channels
    *
    * \brief These functions deal with memory channel control on the camera.
    */
    /*@{*/

    /**
     * Retrieve the current memory channel from the camera.
     *
     * @see fc2SaveToMemoryChannel()
     * @see fc2RestoreFromMemoryChannel()
     * @see fc2GetMemoryChannelInfo()
     *
     * @param context The fc2Context to be used.
     * @param pCurrentChannel Current memory channel.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetMemoryChannel(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer pCurrentChannel );
    public static native @Cast("fc2Error") int fc2GetMemoryChannel(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer pCurrentChannel );
    public static native @Cast("fc2Error") int fc2GetMemoryChannel(
                    fc2Context context,
                    @Cast("unsigned int*") int[] pCurrentChannel );

    /**
     * Save the current settings to the specified current memory channel.
     *
     * @see fc2GetMemoryChannel()
     * @see fc2RestoreFromMemoryChannel()
     * @see fc2GetMemoryChannelInfo()
     *
     * @param context The fc2Context to be used.
     * @param channel Memory channel to save to.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SaveToMemoryChannel(
                    fc2Context context,
                    @Cast("unsigned int") int channel );

    /**
     * Restore the specified current memory channel.
     *
     * @see fc2GetMemoryChannel()
     * @see fc2SaveToMemoryChannel()
     * @see fc2GetMemoryChannelInfo()
     *
     * @param context The fc2Context to be used.
     * @param channel Memory channel to restore from.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2RestoreFromMemoryChannel(
                    fc2Context context,
                    @Cast("unsigned int") int channel );

    /**
     * Query the camera for memory channel support. If the number of
     * channels are 0, then memory channel support is not available.
     *
     * @see fc2GetMemoryChannel()
     * @see fc2SaveToMemoryChannel()
     * @see fc2RestoreFromMemoryChannel()
     *
     * @param context The fc2Context to be used.
     * @param pNumChannels Number of memory channels supported.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetMemoryChannelInfo(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer pNumChannels );
    public static native @Cast("fc2Error") int fc2GetMemoryChannelInfo(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer pNumChannels );
    public static native @Cast("fc2Error") int fc2GetMemoryChannelInfo(
                    fc2Context context,
                    @Cast("unsigned int*") int[] pNumChannels );

    /**
     * Get the current status of the embedded image information register,
     * as well as the availability of each embedded property.
     *
     * @see fc2SetEmbeddedImageInfo()
     *
     * @param context The fc2Context to be used.
     * @param pInfo Structure to be filled.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetEmbeddedImageInfo(
                    fc2Context context,
                    fc2EmbeddedImageInfo pInfo );

    /**
     * Sets the on/off values of the embedded image information structure
     * to the camera.
     *
     * @see fc2GetEmbeddedImageInfo()
     *
     * @param context The fc2Context to be used.
     * @param pInfo Structure to be used.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetEmbeddedImageInfo(
                    fc2Context context,
                    fc2EmbeddedImageInfo pInfo );
    /*@}*/

    /**
    * \defgroup CRegister Register Operation
    *
    * \brief These functions deal with register operation on the camera.
    */
    /*@{*/

    /**
     * Write to the specified register on the camera.
     *
     * @see fc2ReadRegister()
     *
     * @param context The fc2Context to be used.
     * @param address DCAM address to be written to.
     * @param value The value to be written.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int") int value);

    /**
     * Read the specified register from the camera.
     *
     * @see fc2WriteRegister()
     *
     * @param context The fc2Context to be used.
     * @param address DCAM address to be read from.
     * @param pValue The value that is read.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ReadRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") IntPointer pValue );
    public static native @Cast("fc2Error") int fc2ReadRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") IntBuffer pValue );
    public static native @Cast("fc2Error") int fc2ReadRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") int[] pValue );

    /**
     * Write to the specified register on the camera with broadcast.
     *
     * @see fc2ReadRegisterBlock()
     *
     * @param context The fc2Context to be used.
     * @param address DCAM address to be written to.
     * @param value The value to be written.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteRegisterBroadcast(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int") int value);

    /**
     * Write to the specified register block on the camera.
     *
     * @see fc2ReadRegisterBlock()
     *
     * @param context The fc2Context to be used.
     * @param addressHigh Top 16 bits of the 48-bit absolute address to write to.
     * @param addressLow Bottom 32 bits of the 48 bits absolute address to write to.
     * @param pBuffer Array containing data to be written.
     * @param length Size of array, in quadlets.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned short") short addressHigh,
                    @Cast("unsigned int") int addressLow,
                    @Cast("const unsigned int*") IntPointer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2WriteRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned short") short addressHigh,
                    @Cast("unsigned int") int addressLow,
                    @Cast("const unsigned int*") IntBuffer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2WriteRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned short") short addressHigh,
                    @Cast("unsigned int") int addressLow,
                    @Cast("const unsigned int*") int[] pBuffer,
                    @Cast("unsigned int") int length );

    /**
     * Write to the specified register block on the camera.
     *
     * @see fc2WriteRegisterBlock()
     *
     * @param context The fc2Context to be used.
     * @param addressHigh Top 16 bits of the 48-bit absolute address to read from.
     * @param addressLow Bottom 32 bits of the 48 bits absolute address to read from.
     * @param pBuffer Array to store read data.
     * @param length Size of array, in quadlets.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ReadRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned short") short addressHigh,
                    @Cast("unsigned int") int addressLow,
                    @Cast("unsigned int*") IntPointer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2ReadRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned short") short addressHigh,
                    @Cast("unsigned int") int addressLow,
                    @Cast("unsigned int*") IntBuffer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2ReadRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned short") short addressHigh,
                    @Cast("unsigned int") int addressLow,
                    @Cast("unsigned int*") int[] pBuffer,
                    @Cast("unsigned int") int length );

    /**
     * Returns a text representation of the register value.
     *
     * @param registerVal The register value to query.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("const char*") BytePointer fc2GetRegisterString(
                    @Cast("unsigned int") int registerVal);
    /*@}*/

    /**
     * Get cycle time from camera
     *
     * @param context The fc2Context to be used.
     * @param Timestamp struct.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetCycleTime( fc2Context context, fc2TimeStamp pTimeStamp );

    /**
     * Returns the camera diagnostic information.
     *
     * @param context The fc2Context to be used.
     * @param pCameraStats Pointer to the fc2CameraStats structure.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetStats( fc2Context context, fc2CameraStats pCameraStats );

    /*
     * Reset the camera diagnostic information.
     *
     * @return An Error indicating the success or failure of the function.
     */
    

    /**
     * Register the camera to issue a custom callback function call for a
     * specific device event.
     *
     * @param context The fc2Context to be used.
     * @param pOpts Pointer to the EventOptions structure which defines the
     *              callback function to use, the event for which to register
     *              the device, and a pointer to user data (optional) to be
     *              passed to the callback function.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2RegisterEvent(
                    fc2Context context,
                    fc2EventOptions pOpts );

    /**
     *De-register an event previously registered with the camera.
     *
     * @param context The fc2Context to be used.
     * @param pOpts Pointer to the EventOptions structure which defines the
     *              callback function to use, the event for which to register
     *              the device, and a pointer to user data (optional) to be
     *              passed to the callback function. The callback function and
     *              user data elements of the EventOptions structure are ignored
     *              in this call, and just the event name within the structure is
     *              used with this function call.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DeregisterEvent(
                    fc2Context context,
                    fc2EventOptions pOpts );

    /**
     * Register the camera to issue a custom callback function call for a
     * specific device event.
     *
     * @param context The fc2Context to be used.
     * @param pOpts Pointer to the EventOptions structure which defines the
     *              callback function to use, the event for which to register
     *              the device, and a pointer to user data (optional) to be
     *              passed to the callback function. The event name element of
     *              the structure is ignored with this function call. If a single
     *              event has already been registered via RegisterEvent(), this
     *              call will fail, as the user could accidentally change the
     *              the internal callback function pointer for a queued event.
     *              The user will need to de-register all registered events,
     *              then call this function again.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2RegisterAllEvents(
                    fc2Context context,
                    fc2EventOptions pOpts );

    /*
     * De-register all events registered with the camera.
     *
     * @param context The fc2Context to be used.
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DeregisterAllEvents(
                    fc2Context context);

    /**
    * \defgroup CDCAMFormats DCAM Formats
    *
    * \brief These functions deal with DCAM video mode and frame rate
    *            on the camera. This is only used for firewire and usb2 cameras.
    */
    /*@{*/

    /**
     * Query the camera to determine if the specified video mode and
     * frame rate is supported.
     *
     * @param context The fc2Context to be used.
     * @param videoMode Video mode to check.
     * @param frameRate Frame rate to check.
     * @param pSupported Whether the video mode and frame rate is supported.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRateInfo(
                    fc2Context context,
                    @Cast("fc2VideoMode") int videoMode,
                    @Cast("fc2FrameRate") int frameRate,
                    @Cast("BOOL*") IntPointer pSupported);
    public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRateInfo(
                    fc2Context context,
                    @Cast("fc2VideoMode") int videoMode,
                    @Cast("fc2FrameRate") int frameRate,
                    @Cast("BOOL*") IntBuffer pSupported);
    public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRateInfo(
                    fc2Context context,
                    @Cast("fc2VideoMode") int videoMode,
                    @Cast("fc2FrameRate") int frameRate,
                    @Cast("BOOL*") int[] pSupported);

    /**
     * Get the current video mode and frame rate from the camera. If
     * the camera is in Format7, the video mode will be VIDEOMODE_FORMAT7
     * and the frame rate will be FRAMERATE_FORMAT7.
     *
     * @param context The fc2Context to be used.
     * @param videoMode Current video mode.
     * @param frameRate Current frame rate.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRate(
                    fc2Context context,
                    @Cast("fc2VideoMode*") IntPointer videoMode,
                    @Cast("fc2FrameRate*") IntPointer frameRate );
    public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRate(
                    fc2Context context,
                    @Cast("fc2VideoMode*") IntBuffer videoMode,
                    @Cast("fc2FrameRate*") IntBuffer frameRate );
    public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRate(
                    fc2Context context,
                    @Cast("fc2VideoMode*") int[] videoMode,
                    @Cast("fc2FrameRate*") int[] frameRate );

    /**
     * Set the specified video mode and frame rate to the camera. It is
     * not possible to set the camera to VIDEOMODE_FORMAT7 or
     * FRAMERATE_FORMAT7. Use the Format7 functions to set the camera
     * into Format7.
     *
     * @param context The fc2Context to be used.
     * @param videoMode Video mode to set to camera.
     * @param frameRate Frame rate to set to camera.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetVideoModeAndFrameRate(
                    fc2Context context,
                    @Cast("fc2VideoMode") int videoMode,
                    @Cast("fc2FrameRate") int frameRate );
    /*@}*/

    /**
    * \defgroup CFormat7 Format7
    *
    * \brief These functions deal with Format7 custom image control on the camera.
    */
    /*@{*/

    /**
     * Retrieve the availability of Format7 custom image mode and the
     * camera capabilities for the specified Format7 mode. The mode must
     * be specified in the Format7Info structure in order for the
     * function to succeed.
     *
     * @param context The fc2Context to be used.
     * @param info Structure to be filled with the capabilities of the specified
     *             mode and the current state in the specified mode.
     * @param pSupported Whether the specified mode is supported.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetFormat7Info(
                    fc2Context context,
                    fc2Format7Info info,
                    @Cast("BOOL*") IntPointer pSupported );
    public static native @Cast("fc2Error") int fc2GetFormat7Info(
                    fc2Context context,
                    fc2Format7Info info,
                    @Cast("BOOL*") IntBuffer pSupported );
    public static native @Cast("fc2Error") int fc2GetFormat7Info(
                    fc2Context context,
                    fc2Format7Info info,
                    @Cast("BOOL*") int[] pSupported );

    /**
     * Validates Format7ImageSettings structure and returns valid packet
     * size information if the image settings are valid. The current
     * image settings are cached while validation is taking place. The
     * cached settings are restored when validation is complete.
     *
     * @param context The fc2Context to be used.
     * @param imageSettings Structure containing the image settings.
     * @param settingsAreValid Whether the settings are valid.
     * @param packetInfo Packet size information that can be used to
     *                   determine a valid packet size.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ValidateFormat7Settings(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("BOOL*") IntPointer settingsAreValid,
                    fc2Format7PacketInfo packetInfo );
    public static native @Cast("fc2Error") int fc2ValidateFormat7Settings(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("BOOL*") IntBuffer settingsAreValid,
                    fc2Format7PacketInfo packetInfo );
    public static native @Cast("fc2Error") int fc2ValidateFormat7Settings(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("BOOL*") int[] settingsAreValid,
                    fc2Format7PacketInfo packetInfo );

    /**
     * Get the current Format7 configuration from the camera. This call
     * will only succeed if the camera is already in Format7.
     *
     * @param context The fc2Context to be used.
     * @param imageSettings Current image settings.
     * @param packetSize Current packet size.
     * @param percentage Current packet size as a percentage.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetFormat7Configuration(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("unsigned int*") IntPointer packetSize,
                    FloatPointer percentage );
    public static native @Cast("fc2Error") int fc2GetFormat7Configuration(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("unsigned int*") IntBuffer packetSize,
                    FloatBuffer percentage );
    public static native @Cast("fc2Error") int fc2GetFormat7Configuration(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("unsigned int*") int[] packetSize,
                    float[] percentage );

    /**
     * Set the current Format7 configuration to the camera.
     *
     * @param context The fc2Context to be used.
     * @param imageSettings Image settings to be written to the camera.
     * @param packetSize Packet size to be written to the camera.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetFormat7ConfigurationPacket(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    @Cast("unsigned int") int packetSize );

    /**
     * Set the current Format7 configuration to the camera.
     *
     * @param context The fc2Context to be used.
     * @param imageSettings Image settings to be written to the camera.
     * @param percentSpeed Packet size as a percentage to be written to the camera.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetFormat7Configuration(
                    fc2Context context,
                    fc2Format7ImageSettings imageSettings,
                    float percentSpeed );
    /*@}*/

    /**
    * \defgroup CGVCPRegister GVCP Register Operation
    *
    * \brief These functions deal with GVCP register operation on the camera.
    */
    /*@{*/

    /**
     * Write a GVCP register.
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be written to.
     * @param value The value to be written.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteGVCPRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int") int value);

    /**
     * Write a GVCP register with broadcast
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be written to.
     * @param value The value to be written.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBroadcast(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int") int value);

    /**
     * Read a GVCP register.
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be read from.
     * @param pValue The value that is read.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ReadGVCPRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") IntPointer pValue );
    public static native @Cast("fc2Error") int fc2ReadGVCPRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") IntBuffer pValue );
    public static native @Cast("fc2Error") int fc2ReadGVCPRegister(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") int[] pValue );

    /**
     * Write a GVCP register block.
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be write to.
     * @param pBuffer Array containing data to be written.
     * @param length Size of array, in quadlets.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("const unsigned int*") IntPointer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("const unsigned int*") IntBuffer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("const unsigned int*") int[] pBuffer,
                    @Cast("unsigned int") int length );

    /**
     * Read a GVCP register block.
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be read from.
     * @param pBuffer Array containing data to be written.
     * @param length Size of array, in quadlets.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ReadGVCPRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") IntPointer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2ReadGVCPRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") IntBuffer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2ReadGVCPRegisterBlock(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned int*") int[] pBuffer,
                    @Cast("unsigned int") int length );

    /**
     * Write a GVCP memory block.
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be write to.
     * @param pBuffer Array containing data to be written.
     * @param length Size of array, in quadlets.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2WriteGVCPMemory(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("const unsigned char*") BytePointer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2WriteGVCPMemory(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("const unsigned char*") ByteBuffer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2WriteGVCPMemory(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("const unsigned char*") byte[] pBuffer,
                    @Cast("unsigned int") int length );

    /**
     * Read a GVCP memory block.
     *
     * @param context The fc2Context to be used.
     * @param address GVCP address to be read from.
     * @param pBuffer Array containing data to be written.
     * @param length Size of array, in quadlets.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ReadGVCPMemory(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned char*") BytePointer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2ReadGVCPMemory(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned char*") ByteBuffer pBuffer,
                    @Cast("unsigned int") int length );
    public static native @Cast("fc2Error") int fc2ReadGVCPMemory(
                    fc2Context context,
                    @Cast("unsigned int") int _address,
                    @Cast("unsigned char*") byte[] pBuffer,
                    @Cast("unsigned int") int length );
    /*@}*/


    /**
    * \defgroup CGEVProperty GigE property manipulation
    *
    * \brief These functions deal with GigE properties.
    */
    /*@{*/

    /**
     * Get the specified GigEProperty. The GigEPropertyType field must
     * be set in order for this function to succeed.
     *
     * @param context The fc2Context to be used.
     * @param pGigEProp The GigE property to get.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEProperty(
                    fc2Context context,
                    fc2GigEProperty pGigEProp );

    /**
     * Set the specified GigEProperty. The GigEPropertyType field must
     * be set in order for this function to succeed.
     *
     * @param context The fc2Context to be used.
     * @param pGigEProp The GigE property to set.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGigEProperty(
                    fc2Context context,
                    @Const fc2GigEProperty pGigEProp );

    /**
     * Discover the largest packet size that works for the network link
     * between the PC and the camera. This is useful in cases where
     * there may be multiple links between the PC and the camera and
     * there is a possibility of a component not supporting the
     * recommended jumbo frame packet size of 9000.
     *
     * @param context The fc2Context to be used.
     * @param packetSize The maximum packet size supported by the link.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DiscoverGigEPacketSize(
                fc2Context context,
                @Cast("unsigned int*") IntPointer packetSize );
    public static native @Cast("fc2Error") int fc2DiscoverGigEPacketSize(
                fc2Context context,
                @Cast("unsigned int*") IntBuffer packetSize );
    public static native @Cast("fc2Error") int fc2DiscoverGigEPacketSize(
                fc2Context context,
                @Cast("unsigned int*") int[] packetSize );
    /*@}*/

    /**
    * \defgroup CGEVImageSettings GigE image settings
    *
    * \brief These functions deal with GigE image setting.
    */
    /*@{*/

    /**
     * Check if the particular imaging mode is supported by the camera.
     *
     * @param context The fc2Context to be used.
     * @param mode The mode to check.
     * @param isSupported Whether the mode is supported.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2QueryGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode") int mode,
                    @Cast("BOOL*") IntPointer isSupported );
    public static native @Cast("fc2Error") int fc2QueryGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode") int mode,
                    @Cast("BOOL*") IntBuffer isSupported );
    public static native @Cast("fc2Error") int fc2QueryGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode") int mode,
                    @Cast("BOOL*") int[] isSupported );

    /**
     * Get the current imaging mode on the camera.
     *
     * @param context The fc2Context to be used.
     * @param mode Current imaging mode on the camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode*") IntPointer mode );
    public static native @Cast("fc2Error") int fc2GetGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode*") IntBuffer mode );
    public static native @Cast("fc2Error") int fc2GetGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode*") int[] mode );

    /**
     * Set the current imaging mode to the camera. This should only be
     * done when the camera is not streaming images.
     *
     * @param context The fc2Context to be used.
     * @param mode Imaging mode to set to the camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGigEImagingMode(
                    fc2Context context,
                    @Cast("fc2Mode") int mode );

    /**
     * Get information about the image settings possible on the camera.
     *
     * @param context The fc2Context to be used.
     * @param pInfo Image settings information.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEImageSettingsInfo(
                    fc2Context context,
                    fc2GigEImageSettingsInfo pInfo );

    /**
     * Get the current image settings on the camera.
     *
     * @param context The fc2Context to be used.
     * @param pImageSettings Current image settings on camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEImageSettings(
                    fc2Context context,
                    fc2GigEImageSettings pImageSettings );

    /**
     * Set the image settings specified to the camera.
     *
     * @param context The fc2Context to be used.
     * @param pImageSettings Image settings to set to camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGigEImageSettings(
                    fc2Context context,
                    @Const fc2GigEImageSettings pImageSettings );
    /*@}*/

    /**
    * \defgroup CGEVImageBinningSettings GigE image binning settings
    *
    * \brief These functions deal with GigE image binning settings.
    */
    /*@{*/

    /**
     * Get the current binning settings on the camera.
     *
     * @param context The fc2Context to be used.
     * @param horzBinnningValue Current horizontal binning value.
     * @param vertBinnningValue Current vertical binning value.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEImageBinningSettings(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer horzBinnningValue,
                    @Cast("unsigned int*") IntPointer vertBinnningValue );
    public static native @Cast("fc2Error") int fc2GetGigEImageBinningSettings(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer horzBinnningValue,
                    @Cast("unsigned int*") IntBuffer vertBinnningValue );
    public static native @Cast("fc2Error") int fc2GetGigEImageBinningSettings(
                    fc2Context context,
                    @Cast("unsigned int*") int[] horzBinnningValue,
                    @Cast("unsigned int*") int[] vertBinnningValue );

    /**
     * Set the specified binning values to the camera. It is recommended
     * that GetGigEImageSettingsInfo() be called after this function
     * succeeds to retrieve the new image settings information for
     * the new binning mode.
     *
     * @param context The fc2Context to be used.
     * @param horzBinnningValue Horizontal binning value.
     * @param vertBinnningValue Vertical binning value.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGigEImageBinningSettings(
                    fc2Context context,
                    @Cast("unsigned int") int horzBinnningValue,
                    @Cast("unsigned int") int vertBinnningValue );
    /*@}*/

    /**
    * \defgroup CGEVImageStreamConfig GigE image stream configuration
    *
    * \brief These functions deal with GigE image stream configuration.
    */
    /*@{*/

    /**
     * Get the number of stream channels present on the camera.
     *
     * @param context The fc2Context to be used.
     * @param numChannels Number of stream channels present.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetNumStreamChannels(
                    fc2Context context,
                    @Cast("unsigned int*") IntPointer numChannels );
    public static native @Cast("fc2Error") int fc2GetNumStreamChannels(
                    fc2Context context,
                    @Cast("unsigned int*") IntBuffer numChannels );
    public static native @Cast("fc2Error") int fc2GetNumStreamChannels(
                    fc2Context context,
                    @Cast("unsigned int*") int[] numChannels );

    /**
     * Get the stream channel information for the specified channel.
     *
     * @param context The fc2Context to be used.
     * @param channel Channel number to use.
     * @param pChannel Stream channel information for the specified channel.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEStreamChannelInfo(
                    fc2Context context,
                    @Cast("unsigned int") int channel,
                    fc2GigEStreamChannel pChannel );

    /**
     * Set the stream channel information for the specified channel.
     *
     * Note that the source UDP port of the stream channel is read-only.
     *
     * @param context The fc2Context to be used.
     * @param channel Channel number to use.
     * @param pChannel Stream channel information to use for the specified channel.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGigEStreamChannelInfo(
                    fc2Context context,
                    @Cast("unsigned int") int channel,
                    fc2GigEStreamChannel pChannel );

    /**
     * Get the current gige config on the camera.
     *
     * @param context The fc2Context to be used.
     * @param pGigEConfig Current configuration on camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetGigEConfig(
                    fc2Context context,
                    fc2GigEConfig pConfig );

    /**
     * Set the gige config specified to the camera.
     *
     * @param context The fc2Context to be used.
     * @param pGigEConfig configuration to set to camera.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetGigEConfig(
                    fc2Context context,
                    @Const fc2GigEConfig pConfig );
    /*@}*/

    /**
    * \defgroup CImage Image Operation
    *
    * \brief The Image operations are used to retrieve images from a camera,
    * convert between multiple pixel formats and save images to disk.
    * Operations on images are not guaranteed to be thread safe. It is
    * recommended that operations on images be protected by thread
    * synchronization constructs such as mutexes.
    */
    /*@{*/

    /**
     * Set the default color processing algorithm.  This method will be
     * used for any image with the DEFAULT algorithm set. The method used
     * is determined at the time of the Convert() call, therefore the most
     * recent execution of this function will take precedence. The default
     * setting is shared within the current process.
     *
     * @param defaultMethod The color processing algorithm to set.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetDefaultColorProcessing(
                    @Cast("fc2ColorProcessingAlgorithm") int defaultMethod );

    /**
     * Get the default color processing algorithm.
     *
     * @param pDefaultMethod The default color processing algorithm.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetDefaultColorProcessing(
                    @Cast("fc2ColorProcessingAlgorithm*") IntPointer pDefaultMethod );
    public static native @Cast("fc2Error") int fc2GetDefaultColorProcessing(
                    @Cast("fc2ColorProcessingAlgorithm*") IntBuffer pDefaultMethod );
    public static native @Cast("fc2Error") int fc2GetDefaultColorProcessing(
                    @Cast("fc2ColorProcessingAlgorithm*") int[] pDefaultMethod );

    /**
     * Set the default output pixel format. This format will be used for any
     * call to Convert() that does not specify an output format. The format
     * used will be determined at the time of the Convert() call, therefore
     * the most recent execution of this function will take precedence.
     * The default is shared within the current process.
     *
     * @param format The output pixel format to set.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetDefaultOutputFormat(
                    @Cast("fc2PixelFormat") int format );

    /**
     * Get the default output pixel format.
     *
     * @param pFormat The default pixel format.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetDefaultOutputFormat(
                    @Cast("fc2PixelFormat*") IntPointer pFormat );
    public static native @Cast("fc2Error") int fc2GetDefaultOutputFormat(
                    @Cast("fc2PixelFormat*") IntBuffer pFormat );
    public static native @Cast("fc2Error") int fc2GetDefaultOutputFormat(
                    @Cast("fc2PixelFormat*") int[] pFormat );

    /**
     * Calculate the bits per pixel for the specified pixel format.
     *
     * @param format The pixel format.
     * @param pBitsPerPixel The bits per pixel.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DetermineBitsPerPixel(
                    @Cast("fc2PixelFormat") int format,
                    @Cast("unsigned int*") IntPointer pBitsPerPixel );
    public static native @Cast("fc2Error") int fc2DetermineBitsPerPixel(
                    @Cast("fc2PixelFormat") int format,
                    @Cast("unsigned int*") IntBuffer pBitsPerPixel );
    public static native @Cast("fc2Error") int fc2DetermineBitsPerPixel(
                    @Cast("fc2PixelFormat") int format,
                    @Cast("unsigned int*") int[] pBitsPerPixel );

    /**
     * Create a fc2Image. If externally allocated memory is to be used for the
     * converted image, simply assigning the pData member of the fc2Image structure
     * is insufficient. fc2SetImageData() should be called in order to populate
     * the fc2Image structure correctly.
     *
     * @see fc2SetImageData()
     *
     * @param pImage Pointer to image to be created.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2CreateImage(
                    fc2Image pImage );

    /**
     * Destroy the fc2Image.
     *
     * @param image Pointer to image to be destroyed.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DestroyImage(
                    fc2Image image );

    /**
     * Sets the dimensions of the image object.
     *
     * @param pImage The fc2Image to be used.
     * @param rows Number of rows to set.
     * @param cols Number of cols to set.
     * @param stride Stride to set.
     * @param pixelFormat Pixel format to set.
     * @param bayerFormat Bayer tile format to set.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetImageDimensions(
                    fc2Image pImage,
                    @Cast("unsigned int") int rows,
                    @Cast("unsigned int") int cols,
                    @Cast("unsigned int") int stride,
                    @Cast("fc2PixelFormat") int pixelFormat,
                    @Cast("fc2BayerTileFormat") int bayerFormat);

    /**
    * Get the image dimensions associated with the image object.
    *
    * @param pImage The fc2Image to be used.
    * @param pRows Number of rows.
    * @param pCols Number of columns.
    * @param pStride The stride.
    * @param pPixelFormat Pixel format.
    * @param pBayerFormat Bayer tile format.
    */
    public static native @Cast("fc2Error") int fc2GetImageDimensions(
                    fc2Image pImage,
                    @Cast("unsigned int*") IntPointer pRows,
                    @Cast("unsigned int*") IntPointer pCols,
                    @Cast("unsigned int*") IntPointer pStride,
                    @Cast("fc2PixelFormat*") IntPointer pPixelFormat,
                    @Cast("fc2BayerTileFormat*") IntPointer pBayerFormat);
    public static native @Cast("fc2Error") int fc2GetImageDimensions(
                    fc2Image pImage,
                    @Cast("unsigned int*") IntBuffer pRows,
                    @Cast("unsigned int*") IntBuffer pCols,
                    @Cast("unsigned int*") IntBuffer pStride,
                    @Cast("fc2PixelFormat*") IntBuffer pPixelFormat,
                    @Cast("fc2BayerTileFormat*") IntBuffer pBayerFormat);
    public static native @Cast("fc2Error") int fc2GetImageDimensions(
                    fc2Image pImage,
                    @Cast("unsigned int*") int[] pRows,
                    @Cast("unsigned int*") int[] pCols,
                    @Cast("unsigned int*") int[] pStride,
                    @Cast("fc2PixelFormat*") int[] pPixelFormat,
                    @Cast("fc2BayerTileFormat*") int[] pBayerFormat);

    /**
     * Set the color processing algorithm. This should be set on the
     * input image object.
     *
     * @param pImage The fc2Image to be used.
     * @param colorProc The color processing algorithm to use.
     *
     * @see fc2GetColorProcessing()
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetImageColorProcessing(
                    fc2Image pImage,
                    @Cast("fc2ColorProcessingAlgorithm") int colorProc);

    /**
    * Get the current color processing algorithm.
    *
    * @param pImage The fc2Image to be used.
    *
    * @see fc2SetColorProcessing()
    *
    * @return The current color processing algorithm.
    */
    public static native @Cast("fc2Error") int fc2GetImageColorProcessing(
                    fc2Image pImage,
                    @Cast("fc2ColorProcessingAlgorithm*") IntPointer pColorProc);
    public static native @Cast("fc2Error") int fc2GetImageColorProcessing(
                    fc2Image pImage,
                    @Cast("fc2ColorProcessingAlgorithm*") IntBuffer pColorProc);
    public static native @Cast("fc2Error") int fc2GetImageColorProcessing(
                    fc2Image pImage,
                    @Cast("fc2ColorProcessingAlgorithm*") int[] pColorProc);

    /**
     * Set the data of the Image object.
     * Ownership of the image buffer is not transferred to the Image object.
     * It is the user's responsibility to delete the buffer when it is
     * no longer in use.
     *
     * @param pImage The fc2Image to be used.
     * @param pData Pointer to the image buffer.
     * @param dataSize Size of the image buffer.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetImageData(
                    fc2Image pImage,
                    @Cast("const unsigned char*") BytePointer pData,
                    @Cast("unsigned int") int dataSize);
    public static native @Cast("fc2Error") int fc2SetImageData(
                    fc2Image pImage,
                    @Cast("const unsigned char*") ByteBuffer pData,
                    @Cast("unsigned int") int dataSize);
    public static native @Cast("fc2Error") int fc2SetImageData(
                    fc2Image pImage,
                    @Cast("const unsigned char*") byte[] pData,
                    @Cast("unsigned int") int dataSize);

    /**
     * Get a pointer to the data associated with the image. This function
     * is considered unsafe. The pointer returned could be invalidated if
     * the buffer is resized or released. The pointer may also be
     * invalidated if the Image object is passed to fc2RetrieveBuffer().
     *
     * @param pImage The fc2Image to be used.
     * @param ppData A pointer to the image data.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetImageData(
                    fc2Image pImage,
                    @Cast("unsigned char**") PointerPointer ppData);
    public static native @Cast("fc2Error") int fc2GetImageData(
                    fc2Image pImage,
                    @Cast("unsigned char**") @ByPtrPtr BytePointer ppData);
    public static native @Cast("fc2Error") int fc2GetImageData(
                    fc2Image pImage,
                    @Cast("unsigned char**") @ByPtrPtr ByteBuffer ppData);
    public static native @Cast("fc2Error") int fc2GetImageData(
                    fc2Image pImage,
                    @Cast("unsigned char**") @ByPtrPtr byte[] ppData);

    /**
     * Get the metadata associated with the image. This includes
     * embedded image information.
     *
     * @param pImage The fc2Image to be used.
     *
     * @return Metadata associated with the image.
     */
    public static native @Cast("fc2Error") int fc2GetImageMetadata(
                    fc2Image pImage,
                    fc2ImageMetadata pImageMetaData);

    /**
     * Get the timestamp data associated with the image.
     *
     * @param pImage The fc2Image to be used.
     *
     * @return Timestamp data associated with the image.
     */
    public static native @ByVal fc2TimeStamp fc2GetImageTimeStamp(
                    fc2Image pImage);

    /**
     * Save the image to the specified file name with the file format
     * specified.
     *
     * @param pImage The fc2Image to be used.
     * @param pFilename Filename to save image with.
     * @param format File format to save in.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SaveImage(
                    fc2Image pImage,
                    @Cast("const char*") BytePointer pFilename,
                    @Cast("fc2ImageFileFormat") int format );
    public static native @Cast("fc2Error") int fc2SaveImage(
                    fc2Image pImage,
                    String pFilename,
                    @Cast("fc2ImageFileFormat") int format );

    /**
     * Save the image to the specified file name with the file format
     * specified.
     *
     * @param pImage The fc2Image to be used.
     * @param pFilename Filename to save image with.
     * @param format File format to save in.
     * @param pOption Options for saving image.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SaveImageWithOption(
                    fc2Image pImage,
                    @Cast("const char*") BytePointer pFilename,
                    @Cast("fc2ImageFileFormat") int format,
                    Pointer pOption );
    public static native @Cast("fc2Error") int fc2SaveImageWithOption(
                    fc2Image pImage,
                    String pFilename,
                    @Cast("fc2ImageFileFormat") int format,
                    Pointer pOption );

    /**
     *
     *
     * @param pImageIn
     * @param pImageOut
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ConvertImage(
                    fc2Image pImageIn,
                    fc2Image pImageOut );

    /**
     * Converts the current image buffer to the specified output format and
     * stores the result in the specified image. The destination image
     * does not need to be configured in any way before the call is made.
     *
     * @param format Output format of the converted image.
     * @param pImageIn Input image.
     * @param pImageOut Output image.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ConvertImageTo(
                    @Cast("fc2PixelFormat") int format,
                    fc2Image pImageIn,
                    fc2Image pImageOut );

    /**
     * Calculate statistics associated with the image. In order to collect
     * statistics for a particular channel, the enabled flag for the
     * channel must be set to true. Statistics can only be collected for
     * images in Mono8, Mono16, RGB, RGBU, BGR and BGRU.
     *
     * @param pImage The fc2Image to be used.
     * @param pImageStatisticsContext The fc2ImageStatisticsContext to hold the
     *                                statistics.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2CalculateImageStatistics(
                    fc2Image pImage,
                    @ByPtrPtr fc2ImageStatisticsContext pImageStatisticsContext );
    /*@}*/

    /**
    * \defgroup CImageStatistics Image Statistics Operation
    *
    * \brief The Image Statistics operation provides the functionality for the user to collect
    * image channel statistics.
    */
    /*@{*/

    /**
     * Create a statistics context.
     *
     * @param pImageStatisticsContext A statistics context.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2CreateImageStatistics(
                    @ByPtrPtr fc2ImageStatisticsContext pImageStatisticsContext );

    /**
     * Destroy a statistics context.
     *
     * @param imageStatisticsContext A statistics context.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DestroyImageStatistics(
                    fc2ImageStatisticsContext imageStatisticsContext );


    /**
     * Enable all channels.
     *
     * @param imageStatisticsContext A statistics context.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ImageStatisticsEnableAll(
                fc2ImageStatisticsContext imageStatisticsContext );

    /**
     * Disable all channels.
     *
     * @param imageStatisticsContext A statistics context.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ImageStatisticsDisableAll(
                fc2ImageStatisticsContext imageStatisticsContext );

    /**
     * Enable only the grey channel.
     *
     * @param imageStatisticsContext A statistics context.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ImageStatisticsEnableGreyOnly(
                fc2ImageStatisticsContext imageStatisticsContext );

    /**
     * Enable only the RGB channels.
     *
     * @param imageStatisticsContext A statistics context.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ImageStatisticsEnableRGBOnly(
                fc2ImageStatisticsContext imageStatisticsContext );

    /**
     * Enable only the HSL channels.
     *
     * @param imageStatisticsContext A statistics context.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2ImageStatisticsEnableHSLOnly(
                fc2ImageStatisticsContext imageStatisticsContext );

    /**
     * Get the status of a statistics channel.
     *
     * @see fc2SetChannelStatus()
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param pEnabled Whether the channel is enabled.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetChannelStatus(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("BOOL*") IntPointer pEnabled );
    public static native @Cast("fc2Error") int fc2GetChannelStatus(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("BOOL*") IntBuffer pEnabled );
    public static native @Cast("fc2Error") int fc2GetChannelStatus(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("BOOL*") int[] pEnabled );

    /**
     * Set the status of a statistics channel.
     *
     * @see fc2GetChannelStatus()
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param enabled Whether the channel should be enabled.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2SetChannelStatus(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("BOOL") int enabled );

    /**
     * Get the range of a statistics channel. The values returned
     * are the maximum possible values for any given pixel in the image.
     * This is generally 0-255 for 8 bit images, and 0-65535 for
     * 16 bit images.
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param pMin The minimum possible value.
     * @param pMax The maximum possible value.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetChannelRange(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") IntPointer pMin,
                @Cast("unsigned int*") IntPointer pMax );
    public static native @Cast("fc2Error") int fc2GetChannelRange(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") IntBuffer pMin,
                @Cast("unsigned int*") IntBuffer pMax );
    public static native @Cast("fc2Error") int fc2GetChannelRange(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") int[] pMin,
                @Cast("unsigned int*") int[] pMax );

    /**
     * Get the range of a statistics channel. The values returned
     * are the maximum values recorded for all pixels in the image.
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param pPixelValueMin The minimum pixel value.
     * @param pPixelValueMax The maximum pixel value.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetChannelPixelValueRange(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") IntPointer pPixelValueMin,
                @Cast("unsigned int*") IntPointer pPixelValueMax );
    public static native @Cast("fc2Error") int fc2GetChannelPixelValueRange(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") IntBuffer pPixelValueMin,
                @Cast("unsigned int*") IntBuffer pPixelValueMax );
    public static native @Cast("fc2Error") int fc2GetChannelPixelValueRange(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") int[] pPixelValueMin,
                @Cast("unsigned int*") int[] pPixelValueMax );

    /**
     * Get the number of unique pixel values in the image.
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param pNumPixelValues The number of unique pixel values.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetChannelNumPixelValues(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") IntPointer pNumPixelValues );
    public static native @Cast("fc2Error") int fc2GetChannelNumPixelValues(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") IntBuffer pNumPixelValues );
    public static native @Cast("fc2Error") int fc2GetChannelNumPixelValues(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("unsigned int*") int[] pNumPixelValues );

    /**
     * Get the mean of the image.
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param pPixelValueMean The mean of the image.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetChannelMean(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                FloatPointer pPixelValueMean );
    public static native @Cast("fc2Error") int fc2GetChannelMean(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                FloatBuffer pPixelValueMean );
    public static native @Cast("fc2Error") int fc2GetChannelMean(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                float[] pPixelValueMean );

    /**
     * Get the histogram for the image.
     *
     * @param imageStatisticsContext A statistics context.
     * @param channel The statistics channel.
     * @param ppHistogram Pointer to an array containing the histogram.
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetChannelHistogram(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @Cast("int**") PointerPointer ppHistogram );
    public static native @Cast("fc2Error") int fc2GetChannelHistogram(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @ByPtrPtr IntPointer ppHistogram );
    public static native @Cast("fc2Error") int fc2GetChannelHistogram(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @ByPtrPtr IntBuffer ppHistogram );
    public static native @Cast("fc2Error") int fc2GetChannelHistogram(
                fc2ImageStatisticsContext imageStatisticsContext,
                @Cast("fc2StatisticsChannel") int channel,
                @ByPtrPtr int[] ppHistogram );

    /**
     * Get all statistics for the image.
     *
     * @param imageStatisticsContext The statistics context.
     * @param channel The statistics channel.
     * @param pRangeMin The minimum possible value.
     * @param pRangeMax The maximum possible value.
     * @param pPixelValueMin The minimum pixel value.
     * @param pPixelValueMax The maximum pixel value.
     * @param pNumPixelValues The number of unique pixel values.
     * @param pPixelValueMean The mean of the image.
     * @param ppHistogram Pointer to an array containing the histogram.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetImageStatistics(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("unsigned int*") IntPointer pRangeMin,
                    @Cast("unsigned int*") IntPointer pRangeMax,
                    @Cast("unsigned int*") IntPointer pPixelValueMin,
                    @Cast("unsigned int*") IntPointer pPixelValueMax,
                    @Cast("unsigned int*") IntPointer pNumPixelValues,
                    FloatPointer pPixelValueMean,
                    @Cast("int**") PointerPointer ppHistogram );
    public static native @Cast("fc2Error") int fc2GetImageStatistics(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("unsigned int*") IntPointer pRangeMin,
                    @Cast("unsigned int*") IntPointer pRangeMax,
                    @Cast("unsigned int*") IntPointer pPixelValueMin,
                    @Cast("unsigned int*") IntPointer pPixelValueMax,
                    @Cast("unsigned int*") IntPointer pNumPixelValues,
                    FloatPointer pPixelValueMean,
                    @ByPtrPtr IntPointer ppHistogram );
    public static native @Cast("fc2Error") int fc2GetImageStatistics(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("unsigned int*") IntBuffer pRangeMin,
                    @Cast("unsigned int*") IntBuffer pRangeMax,
                    @Cast("unsigned int*") IntBuffer pPixelValueMin,
                    @Cast("unsigned int*") IntBuffer pPixelValueMax,
                    @Cast("unsigned int*") IntBuffer pNumPixelValues,
                    FloatBuffer pPixelValueMean,
                    @ByPtrPtr IntBuffer ppHistogram );
    public static native @Cast("fc2Error") int fc2GetImageStatistics(
                    fc2ImageStatisticsContext imageStatisticsContext,
                    @Cast("fc2StatisticsChannel") int channel,
                    @Cast("unsigned int*") int[] pRangeMin,
                    @Cast("unsigned int*") int[] pRangeMax,
                    @Cast("unsigned int*") int[] pPixelValueMin,
                    @Cast("unsigned int*") int[] pPixelValueMax,
                    @Cast("unsigned int*") int[] pNumPixelValues,
                    float[] pPixelValueMean,
                    @ByPtrPtr int[] ppHistogram );

    /*@}*/

    /**
    * \defgroup CTopologyNode TopologyNode Operation
    *
    * \brief The TopologyNode operation provides the functionality for the user to
    * generate a tree structure of all cameras and devices connected to a computer.
    */
    /*@{*/

    /**
     * Create a TopologyNode context.
     *
     * @param pTopologyNodeContext A Topology Node context.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2CreateTopologyNode(
                    @ByPtrPtr fc2TopologyNodeContext pTopologyNodeContext );

    /**
     * Get the PGRGuid associated with the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param pGuid The unique identifier associated with the node.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetGuid(
                    fc2TopologyNodeContext TopologyNodeContext,
                    fc2PGRGuid pGuid);

    /**
     * Get the device ID associated with the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param pID Device ID of the node.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetDeviceId(
                    fc2TopologyNodeContext TopologyNodeContext,
                    IntPointer pID);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetDeviceId(
                    fc2TopologyNodeContext TopologyNodeContext,
                    IntBuffer pID);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetDeviceId(
                    fc2TopologyNodeContext TopologyNodeContext,
                    int[] pID);

    /**
     * Get the node type associated with the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param pNodeType Node type of the node.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNodeType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2NodeType*") IntPointer pNodeType);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNodeType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2NodeType*") IntBuffer pNodeType);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNodeType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2NodeType*") int[] pNodeType);

    /**
     * Get the interface type associated with the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param pInterfaceType Interface type of the node.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetInterfaceType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2InterfaceType*") IntPointer pInterfaceType);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetInterfaceType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2InterfaceType*") IntBuffer pInterfaceType);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetInterfaceType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2InterfaceType*") int[] pInterfaceType);

    /**
     * Get the number of child nodes.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param pNumChildNodes Number of child nodes.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNumChildren(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int*") IntPointer pNumChildNodes);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNumChildren(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int*") IntBuffer pNumChildNodes);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNumChildren(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int*") int[] pNumChildNodes);

    /**
     * Get child node located at the specified position.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param position Position of the child node.
     * @param pChildTopologyNodeContext The Topology Node context the contains
     *                                  information on the child topology
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetChild(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int") int _position,
                    @ByPtrPtr fc2TopologyNodeContext pChildTopologyNodeContext);

    /**
     * Add the specified TopologyNode as a child of the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param TopologyNodeChildContext The TopologyNode child context to add.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeAddChild(
                    fc2TopologyNodeContext TopologyNodeContext,
                    fc2TopologyNodeContext TopologyNodeChildContext);

    /**
     * Get the number of ports.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param pNumPorts Number of ports.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNumPorts(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int*") IntPointer pNumPorts);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNumPorts(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int*") IntBuffer pNumPorts);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetNumPorts(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int*") int[] pNumPorts);

    /**
     * Get type of port located at the specified position.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param position Position of the port.
     * @param pPortType PortType at the specified position.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeGetPortType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int") int _position,
                    @Cast("fc2PortType*") IntPointer pPortType);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetPortType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int") int _position,
                    @Cast("fc2PortType*") IntBuffer pPortType);
    public static native @Cast("fc2Error") int fc2TopologyNodeGetPortType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("unsigned int") int _position,
                    @Cast("fc2PortType*") int[] pPortType);

    /**
     * Add the specified PortType as a port of the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param portType childPort The port to add.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2TopologyNodeAddPortType(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @Cast("fc2PortType") int portType);

    /**
     * Assign a PGRGuid and device ID to the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param guid PGRGuid to be assigned.
     * @param deviceId Device ID to be assigned.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("BOOL") int fc2TopologyNodeAssignGuidToNode(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @ByVal fc2PGRGuid guid,
                    int deviceId);

    /**
     * Assign a PGRGuid, device ID and nodeType to the node.
     *
     * @param TopologyNodeContext The Topology Node context to use.
     * @param guid PGRGuid to be assigned.
     * @param deviceId Device ID to be assigned.
     * @param nodeType NodeType to be assigned
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("BOOL") int fc2TopologyNodeAssignGuidToNodeEx(
                    fc2TopologyNodeContext TopologyNodeContext,
                    @ByVal fc2PGRGuid guid,
                    int deviceId,
                    @Cast("fc2NodeType") int nodeType);

    /**
     * Destroy a TopologyNode context.
     *
     * @param TopologyNodeContext A Topology Node context.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2DestroyTopologyNode(
                    fc2TopologyNodeContext TopologyNodeContext );

    /*@}*/

    /**
    * \defgroup CUtilities Utilities
    *
    * \brief The utility operations are used to query for general system
    * information such as operating system, available memory etc.
    * It can also be used to launch browsers, CHM viewers or terminal commands.
    */
    /*@{*/

    /**
     * Check for driver compatibility for the given camera guid.
     *
     * @param pGuid The PGRGuid of the device to check.
     *
     * @return FC2_ERROR_OK if the library is compatible with the currently
     *         loaded driver, otherwise an error indicating the type of failure.
     */
    public static native @Cast("fc2Error") int fc2CheckDriver( @Const fc2PGRGuid pGuid);

    /**
     * Get the driver's name for a device
     *
     * @param pGuid The PGRGuid of the device to check.
     * @param pDeviceName The device name will be returned in this string
     * @param pDeviceNameLength The length of the device name string returned
     *
     * @return An Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetDriverDeviceName(
                @Const fc2PGRGuid pGuid,
                @Cast("char*") BytePointer pDeviceName,
                @Cast("size_t*") SizeTPointer deviceNameLength);
    public static native @Cast("fc2Error") int fc2GetDriverDeviceName(
                @Const fc2PGRGuid pGuid,
                @Cast("char*") ByteBuffer pDeviceName,
                @Cast("size_t*") SizeTPointer deviceNameLength);
    public static native @Cast("fc2Error") int fc2GetDriverDeviceName(
                @Const fc2PGRGuid pGuid,
                @Cast("char*") byte[] pDeviceName,
                @Cast("size_t*") SizeTPointer deviceNameLength);

    /**
     * Get system information.
     *
     * @param pSystemInfo Structure to receive system information.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetSystemInfo( fc2SystemInfo pSystemInfo);

    /**
     * Get library version.
     *
     * @param pVersion Structure to receive the library version.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2GetLibraryVersion( fc2Version pVersion);

    /**
     * Launch a URL in the system default browser.
     *
     * @param pAddress URL to open in browser.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2LaunchBrowser( @Cast("const char*") BytePointer pAddress);
    public static native @Cast("fc2Error") int fc2LaunchBrowser( String pAddress);

    /**
     * Open a CHM file in the system default CHM viewer.
     *
     * @param pFileName Filename of CHM file to open.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2LaunchHelp( @Cast("const char*") BytePointer pFileName);
    public static native @Cast("fc2Error") int fc2LaunchHelp( String pFileName);

    /**
     * Execute a command in the terminal. This is a blocking call that
     * will return when the command completes.
     *
     * @param pCommand Command to execute.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2LaunchCommand( @Cast("const char*") BytePointer pCommand);
    public static native @Cast("fc2Error") int fc2LaunchCommand( String pCommand);

    /**
     * Execute a command in the terminal. This is a non-blocking call that
     * will return immediately. The return value of the command can be
     * retrieved in the callback.
     *
     * @param pCommand Command to execute.
     * @param pCallback Callback to fire when command is complete.
     * @param pUserData Data pointer to pass to callback.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("fc2Error") int fc2LaunchCommandAsync(
                    @Cast("const char*") BytePointer pCommand,
                    fc2AsyncCommandCallback pCallback,
                    Pointer pUserData );
    public static native @Cast("fc2Error") int fc2LaunchCommandAsync(
                    String pCommand,
                    fc2AsyncCommandCallback pCallback,
                    Pointer pUserData );

    /**
     * Get a string representation of an error.
     *
     * @param error Error to be parsed.
     *
     * @return A fc2Error indicating the success or failure of the function.
     */
    public static native @Cast("const char*") BytePointer fc2ErrorToDescription(
                    @Cast("fc2Error") int error);

    /*@}*/

// #ifdef __cplusplus
// #endif

// #endif // FLIR_FLYCAPTURE2_C_H

// Parsed from MultiSyncLibraryDefs_C.h

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id:
//=============================================================================

// #ifndef MULTISYNCLIBRARYDEFS_C_H
// #define MULTISYNCLIBRARYDEFS_C_H

// #include <stdlib.h>

//=============================================================================
// C definitions header file for MultiSync.
//
// This file defines the C enumerations, typedefs and structures for MultiSync
//
//=============================================================================

// #ifdef __cplusplus
// #endif

	//=============================================================================
	// Typedefs
	//=============================================================================

// #ifndef FALSE
// #endif

// #ifndef TRUE
// #endif

// #ifndef FULL_32BIT_VALUE
// #endif
// Targeting ../FlyCapture2_C/syncContext.java




	//=============================================================================
	// Enumerations
	//=============================================================================

	/** enum syncError */
	public static final int
		SYNC_ERROR_OK = 0,
		SYNC_ERROR_FAILED = 1,
		SYNC_ERROR_ALREADY_STARTED = 2,
		SYNC_ERROR_ALREADY_STOPPED = 3,
		SYNC_ERROR_CONTEXT_NOT_INITIALIZED = 4,
		SYNC_ERROR_UNKNOWN_ERROR = 5;

	/** enum syncMessage */
	public static final int
		SYNC_MESSAGE_OK = 0,
		SYNC_MESSAGE_FAILED = 1,
		SYNC_MESSAGE_STARTED = 2,
		SYNC_MESSAGE_STOPPED = 3,
		SYNC_MESSAGE_SYNCING = 4,
		SYNC_MESSAGE_NOMASTER = 5,
		SYNC_MESSAGE_THREAD_ERROR = 6,
		SYNC_MESSAGE_DEVICE_ERROR = 7,
		SYNC_MESSAGE_NOT_ENOUGH_DEVICES = 8,
		SYNC_MESSAGE_BUS_RESET = 9,
		SYNC_MESSAGE_NOT_INITIALIZED = 10,
		SYNC_MESSAGE_UNKNOWN_ERROR = 11;

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from MultiSyncLibrary_C.h

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id:
//=============================================================================

// #ifndef MULTISYNCLIBRARY_C_H
// #define MULTISYNCLIBRARY_C_H

//=============================================================================
// Global C header file for MultiSync
//
// This file defines the C API for MultiSync Library
//=============================================================================

// #include "MultiSyncLibraryPlatform_C.h"
// #include "MultiSyncLibraryDefs_C.h"

// #ifdef __cplusplus
// #endif

	/**
	 * Create a Sync context for MultiSync Library.
	 * This call must be made before any other calls that use a context
	 * will succeed.
	 *
	 * @param pContext A pointer to the syncContext to be created.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncCreateContext(
					@ByPtrPtr syncContext pContext );

	/**
	 * Destory the sync context. This must be called when the user is finished
	 * with the context in order to prevent memory leaks.
	 *
	 * @param context The syncContext to be destoryed.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncDestroyContext(
					syncContext context );

	/**
	 * Start the sync progress
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncStart(
					syncContext context );

	/**
	 * Stop the sync progress
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncStop(
					syncContext context );


	/**
	 * Scan newly connected or removed timing bus (for corss-PC syncing only)
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncRescanMasterTimingBus(
					syncContext context );

	/**
	 * Start the sync progress
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncMessage indicating the sync status.
	 */
	public static native @Cast("syncMessage") int syncGetStatus(
					syncContext context );

	/**
	 * Time since sync started
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return Time sinced synced.
	 */
	public static native double syncGetTimeSinceSynced(
					syncContext context );

	/**
	 * Whether syncing across PCs
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if its syncing across PC
	 */
	public static native @Cast("BOOL") int syncIsTimingBusConnected(
					syncContext context );

	/**
	 * Enable across pc synchronization support
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if operation was successful
	 */
	public static native @Cast("BOOL") int syncEnableCrossPCSynchronization(
					syncContext context );

	/**
	 * Disable across pc synchronization support
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if operation was successful
	 */
	public static native @Cast("BOOL") int syncDisableCrossPCSynchronization(
					syncContext context );

	/**
	 * Query cross pc synchronizaion support status
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if cross pc synchronization was supported
	 */
	public static native @Cast("BOOL") int syncQueryCrossPCSynchronizationSetting(
					syncContext context );
// #ifdef __cplusplus
// #endif

// #endif


}
