/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.BuildEnabled;
import org.bytedeco.javacpp.tools.ClassScanner;
import org.bytedeco.javacpp.tools.Generator;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.Parser;
import org.bytedeco.javacpp.tools.ParserException;
import org.bytedeco.javacpp.tools.UserClassLoader;

public class Builder {
    final Logger logger;
    String encoding = null;
    File outputDirectory = null;
    String outputName = null;
    String jarPrefix = null;
    boolean compile = true;
    boolean deleteJniFiles = true;
    boolean header = false;
    boolean copyLibs = false;
    boolean copyResources = false;
    Properties properties = null;
    ClassScanner classScanner = null;
    String[] buildCommand = null;
    File workingDirectory = null;
    Map<String, String> environmentVariables = null;
    Collection<String> compilerOptions = null;

    File parse(String[] classPath, Class cls) throws IOException, ParserException {
        return new Parser(this.logger, this.properties, this.encoding, null).parse(this.outputDirectory, classPath, cls);
    }

    void includeJavaPaths(ClassProperties properties, boolean header) {
        String macpath;
        File javaHome;
        if (properties.getProperty("platform", "").startsWith("android")) {
            return;
        }
        String platform = Loader.getPlatform();
        final String jvmlink = properties.getProperty("platform.link.prefix", "") + "jvm" + properties.getProperty("platform.link.suffix", "");
        final String jvmlib = properties.getProperty("platform.library.prefix", "") + "jvm" + properties.getProperty("platform.library.suffix", "");
        final String[] jnipath = new String[2];
        final String[] jvmpath = new String[2];
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, "jni.h").exists()) {
                    jnipath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, "jni_md.h").exists()) {
                    jnipath[1] = dir.getAbsolutePath();
                }
                if (new File(dir, jvmlink).exists()) {
                    jvmpath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, jvmlib).exists()) {
                    jvmpath[1] = dir.getAbsolutePath();
                }
                return new File(dir, name).isDirectory();
            }
        };
        try {
            javaHome = new File(System.getProperty("java.home")).getParentFile().getCanonicalFile();
        }
        catch (IOException | NullPointerException e) {
            this.logger.warn("Could not include header files from java.home:" + e);
            return;
        }
        ArrayList<File> dirs = new ArrayList<File>(Arrays.asList(javaHome.listFiles(filter)));
        while (!dirs.isEmpty()) {
            File d = dirs.remove(dirs.size() - 1);
            String dpath = d.getPath();
            File[] files = d.listFiles(filter);
            if (dpath == null || files == null) continue;
            for (File f : files) {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (dpath.startsWith(f.getPath())) continue;
                dirs.add(f);
            }
        }
        if (jnipath[0] != null && jnipath[0].equals(jnipath[1])) {
            jnipath[1] = null;
        } else if (jnipath[0] == null && new File(macpath = "/System/Library/Frameworks/JavaVM.framework/Headers/").isDirectory()) {
            jnipath[0] = macpath;
        }
        if (jvmpath[0] != null && jvmpath[0].equals(jvmpath[1])) {
            jvmpath[1] = null;
        }
        properties.addAll("platform.includepath", jnipath);
        if (platform.equals(properties.getProperty("platform", platform))) {
            if (header) {
                properties.get("platform.link").add(0, "jvm");
                properties.addAll("platform.linkpath", jvmpath);
            }
            if (platform.startsWith("macosx")) {
                properties.addAll("platform.framework", "JavaVM");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    int compile(String[] sourceFilenames, String outputFilename, ClassProperties properties, File workingDirectory) throws IOException, InterruptedException {
        String p2;
        ArrayList<String> command = new ArrayList<String>();
        this.includeJavaPaths(properties, this.header);
        String platform = Loader.getPlatform();
        String compilerPath = properties.getProperty("platform.compiler");
        command.add(compilerPath);
        String p = properties.getProperty("platform.sysroot.prefix", "");
        for (String s : properties.get("platform.sysroot")) {
            if (!new File(s).isDirectory()) continue;
            if (p.endsWith(" ")) {
                command.add(p.trim());
                command.add(s);
                continue;
            }
            command.add(p + s);
        }
        p = properties.getProperty("platform.includepath.prefix", "");
        for (String s : properties.get("platform.includepath")) {
            if (!new File(s).isDirectory()) continue;
            if (p.endsWith(" ")) {
                command.add(p.trim());
                command.add(s);
                continue;
            }
            command.add(p + s);
        }
        for (String s : properties.get("platform.includeresource")) {
            for (File file : Loader.cacheResources(s)) {
                if (!file.isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(file.getCanonicalPath());
                    continue;
                }
                command.add(p + file.getCanonicalPath());
            }
        }
        for (int i = sourceFilenames.length - 1; i >= 0; --i) {
            command.add(sourceFilenames[i]);
        }
        List<String> allOptions = properties.get("platform.compiler.*");
        if (!allOptions.contains("!default") && !allOptions.contains("default")) {
            allOptions.add(0, "default");
        }
        for (String s : allOptions) {
            if (s == null || s.length() == 0) continue;
            p2 = "platform.compiler." + s;
            String options = properties.getProperty(p2);
            if (options != null && options.length() > 0) {
                command.addAll(Arrays.asList(options.split(" ")));
                continue;
            }
            if ("!default".equals(s) || "default".equals(s)) continue;
            this.logger.warn("Could not get the property named \"" + p2 + "\"");
        }
        command.addAll(this.compilerOptions);
        String output = properties.getProperty("platform.compiler.output");
        int i = 1;
        while (i < 2 || output != null) {
            if (output != null && output.length() > 0) {
                command.addAll(Arrays.asList(output.split(" ")));
            }
            if (output == null || output.length() == 0 || output.endsWith(" ")) {
                command.add(outputFilename);
            } else {
                command.add((String)command.remove(command.size() - 1) + outputFilename);
            }
            output = properties.getProperty("platform.compiler.output" + ++i);
        }
        String p3 = properties.getProperty("platform.linkpath.prefix", "");
        p2 = properties.getProperty("platform.linkpath.prefix2");
        for (String string : properties.get("platform.linkpath")) {
            if (!new File(string).isDirectory()) continue;
            if (p3.endsWith(" ")) {
                command.add(p3.trim());
                command.add(string);
            } else {
                command.add(p3 + string);
            }
            if (p2 == null) continue;
            if (p2.endsWith(" ")) {
                command.add(p2.trim());
                command.add(string);
                continue;
            }
            command.add(p2 + string);
        }
        for (String string : properties.get("platform.linkresource")) {
            for (File f : Loader.cacheResources(string)) {
                if (!f.isDirectory()) continue;
                if (p3.endsWith(" ")) {
                    command.add(p3.trim());
                    command.add(f.getCanonicalPath());
                } else {
                    command.add(p3 + f.getCanonicalPath());
                }
                if (p2 == null) continue;
                if (p2.endsWith(" ")) {
                    command.add(p2.trim());
                    command.add(f.getCanonicalPath());
                    continue;
                }
                command.add(p2 + f.getCanonicalPath());
            }
        }
        String p4 = properties.getProperty("platform.link.prefix", "");
        Object x = properties.getProperty("platform.link.suffix", "");
        int i2 = command.size();
        for (String string : properties.get("platform.link")) {
            void var14_41;
            String[] libnameversion = string.split("#")[0].split("@");
            if (libnameversion.length == 3 && libnameversion[1].length() == 0) {
                String string2 = libnameversion[0] + libnameversion[2];
            } else {
                String string3 = libnameversion[0];
            }
            if (p4.endsWith(" ") && ((String)x).startsWith(" ")) {
                command.add(i2, p4.trim());
                command.add(i2 + 1, (String)var14_41);
                command.add(i2 + 2, ((String)x).trim());
                continue;
            }
            if (p4.endsWith(" ")) {
                command.add(i2, p4.trim());
                command.add(i2 + 1, (String)var14_41 + (String)x);
                continue;
            }
            if (((String)x).startsWith(" ")) {
                command.add(i2, p4 + (String)var14_41);
                command.add(i2 + 1, ((String)x).trim());
                continue;
            }
            command.add(i2, p4 + (String)var14_41 + (String)x);
        }
        p4 = properties.getProperty("platform.frameworkpath.prefix", "");
        for (String s : properties.get("platform.frameworkpath")) {
            if (!new File(s).isDirectory()) continue;
            if (p4.endsWith(" ")) {
                command.add(p4.trim());
                command.add(s);
                continue;
            }
            command.add(p4 + s);
        }
        p4 = properties.getProperty("platform.framework.prefix", "");
        x = properties.getProperty("platform.framework.suffix", "");
        for (String string : properties.get("platform.framework")) {
            if (p4.endsWith(" ") && ((String)x).startsWith(" ")) {
                command.add(p4.trim());
                command.add(string);
                command.add(((String)x).trim());
                continue;
            }
            if (p4.endsWith(" ")) {
                command.add(p4.trim());
                command.add(string + (String)x);
                continue;
            }
            if (((String)x).startsWith(" ")) {
                command.add(p4 + string);
                command.add(((String)x).trim());
                continue;
            }
            command.add(p4 + string + (String)x);
        }
        boolean windows = platform.startsWith("windows");
        for (int i3 = 0; i3 < command.size(); ++i3) {
            Object arg = (String)command.get(i3);
            if (arg == null) {
                arg = "";
            }
            if (((String)arg).trim().isEmpty() && windows) {
                arg = "\"\"";
            }
            command.set(i3, (String)arg);
        }
        String text = "";
        for (String string : command) {
            boolean bl;
            boolean bl2 = bl = string.indexOf(" ") > 0 || string.isEmpty();
            if (bl) {
                text = text + (windows ? "\"" : "'");
            }
            text = text + string;
            if (bl) {
                text = text + (windows ? "\"" : "'");
            }
            text = text + " ";
        }
        this.logger.info(text);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(workingDirectory);
        if (this.environmentVariables != null) {
            pb.environment().putAll(this.environmentVariables);
        }
        return pb.inheritIO().start().waitFor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    File[] generateAndCompile(Class[] classes, String outputName, boolean first, boolean last) throws IOException, InterruptedException {
        int i;
        File outputPath = this.outputDirectory != null ? this.outputDirectory.getCanonicalFile() : null;
        ClassProperties p = Loader.loadProperties(classes, this.properties, true);
        String platform = this.properties.getProperty("platform");
        String extension = this.properties.getProperty("platform.extension");
        String sourcePrefix = outputPath != null ? outputPath.getPath() + File.separator : "";
        String sourceSuffix = p.getProperty("platform.source.suffix", ".cpp");
        String libraryPath = p.getProperty("platform.library.path", "");
        String libraryPrefix = p.getProperty("platform.library.prefix", "");
        String librarySuffix = p.getProperty("platform.library.suffix", "");
        String[] sourcePrefixes = new String[]{sourcePrefix, sourcePrefix};
        if (outputPath == null) {
            URI uri = null;
            try {
                String resourceName = '/' + classes[classes.length - 1].getName().replace('.', '/') + ".class";
                String resourceURL = classes[classes.length - 1].getResource(resourceName).toString();
                uri = new URI(resourceURL.substring(0, resourceURL.lastIndexOf(47) + 1));
                boolean isFile = "file".equals(uri.getScheme());
                File classPath = new File(this.classScanner.getClassLoader().getPaths()[0]).getCanonicalFile();
                File packageDir = isFile ? new File(uri) : new File(classPath, resourceName.substring(0, resourceName.lastIndexOf(47) + 1));
                uri = new URI(resourceURL.substring(0, resourceURL.length() - resourceName.length() + 1));
                File file = libraryPath.length() > 0 ? (isFile ? new File(uri) : classPath) : new File(packageDir, platform + (extension != null ? extension : ""));
                outputPath = new File(file, libraryPath);
                sourcePrefix = packageDir.getPath() + File.separator;
                sourcePrefixes = new String[]{classPath.getPath() + File.separator, sourcePrefix};
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("URI: " + uri, e);
            }
        }
        if (!outputPath.exists()) {
            outputPath.mkdirs();
        }
        Generator generator = new Generator(this.logger, this.properties, this.encoding);
        String[] sourceFilenames = new String[]{sourcePrefixes[0] + "jnijavacpp" + sourceSuffix, sourcePrefixes[1] + outputName + sourceSuffix};
        String[] headerFilenames = new String[]{null, this.header ? sourcePrefixes[1] + outputName + ".h" : null};
        String[] loadSuffixes = new String[]{"_jnijavacpp", null};
        String[] baseLoadSuffixes = new String[]{null, "_jnijavacpp"};
        String classPath = System.getProperty("java.class.path");
        for (String s : this.classScanner.getClassLoader().getPaths()) {
            classPath = classPath + File.pathSeparator + s;
        }
        String[] stringArray = new String[]{null, classPath};
        Class[][] classesArray = new Class[][]{null, classes};
        String[] libraryNames = new String[]{libraryPrefix + "jnijavacpp" + librarySuffix, libraryPrefix + outputName + librarySuffix};
        File[] outputFiles = null;
        boolean generated = true;
        for (i = 0; i < sourceFilenames.length; ++i) {
            if (i == 0 && !first) continue;
            this.logger.info("Generating " + sourceFilenames[i]);
            if (generator.generate(sourceFilenames[i], headerFilenames[i], loadSuffixes[i], baseLoadSuffixes[i], stringArray[i], classesArray[i])) continue;
            this.logger.info("Nothing generated for " + sourceFilenames[i]);
            generated = false;
            break;
        }
        if (!generated) return outputFiles;
        if (this.compile) {
            int i2;
            int exitValue = 0;
            String s = this.properties.getProperty("platform.library.static", "false").toLowerCase();
            if (s.equals("true") || s.equals("t") || s.equals("")) {
                outputFiles = new File[sourceFilenames.length];
                for (i2 = 0; exitValue == 0 && i2 < sourceFilenames.length; ++i2) {
                    if (i2 == 0 && !first) continue;
                    this.logger.info("Compiling " + outputPath.getPath() + File.separator + libraryNames[i2]);
                    exitValue = this.compile(new String[]{sourceFilenames[i2]}, libraryNames[i2], p, outputPath);
                    outputFiles[i2] = new File(outputPath, libraryNames[i2]);
                }
            } else {
                String libraryName = libraryNames[libraryNames.length - 1];
                this.logger.info("Compiling " + outputPath.getPath() + File.separator + libraryName);
                exitValue = this.compile(sourceFilenames, libraryName, p, outputPath);
                outputFiles = new File[]{new File(outputPath, libraryName)};
            }
            if (exitValue != 0) throw new RuntimeException("Process exited with an error: " + exitValue);
            for (i2 = sourceFilenames.length - 1; i2 >= 0; --i2) {
                if (i2 == 0 && !last) continue;
                if (this.deleteJniFiles) {
                    this.logger.info("Deleting " + sourceFilenames[i2]);
                    new File(sourceFilenames[i2]).delete();
                    continue;
                }
                this.logger.info("Keeping " + sourceFilenames[i2]);
            }
            return outputFiles;
        } else {
            outputFiles = new File[sourceFilenames.length];
            for (i = 0; i < sourceFilenames.length; ++i) {
                outputFiles[i] = new File(sourceFilenames[i]);
            }
        }
        return outputFiles;
    }

    void createJar(File jarFile, String[] classPath, File ... files) throws IOException {
        this.logger.info("Creating " + jarFile);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        for (File f : files) {
            int length;
            String name = f.getPath();
            if (classPath != null) {
                int i;
                String[] names = new String[classPath.length];
                for (i = 0; i < classPath.length; ++i) {
                    String path = new File(classPath[i]).getCanonicalPath();
                    if (!name.startsWith(path)) continue;
                    names[i] = name.substring(path.length() + 1);
                }
                for (i = 0; i < names.length; ++i) {
                    if (names[i] == null || names[i].length() >= name.length()) continue;
                    name = names[i];
                }
            }
            ZipEntry e = new ZipEntry(name.replace(File.separatorChar, '/'));
            e.setTime(f.lastModified());
            jos.putNextEntry(e);
            FileInputStream fis = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                jos.write(buffer, 0, length);
            }
            fis.close();
            jos.closeEntry();
        }
        jos.close();
    }

    public Builder() {
        this(Logger.create(Builder.class));
    }

    public Builder(Logger logger) {
        this.logger = logger;
        System.setProperty("org.bytedeco.javacpp.loadlibraries", "false");
        this.properties = Loader.loadProperties();
        this.classScanner = new ClassScanner(logger, new ArrayList<Class>(), new UserClassLoader(Thread.currentThread().getContextClassLoader()));
        this.compilerOptions = new ArrayList<String>();
    }

    public Builder classPaths(String classPaths) {
        this.classPaths(classPaths == null ? null : classPaths.split(File.pathSeparator));
        return this;
    }

    public Builder classPaths(String ... classPaths) {
        this.classScanner.getClassLoader().addPaths(classPaths);
        return this;
    }

    public Builder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public Builder outputDirectory(String outputDirectory) {
        this.outputDirectory(outputDirectory == null ? null : new File(outputDirectory));
        return this;
    }

    public Builder outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public Builder compile(boolean compile) {
        this.compile = compile;
        return this;
    }

    public Builder deleteJniFiles(boolean deleteJniFiles) {
        this.deleteJniFiles = deleteJniFiles;
        return this;
    }

    public Builder header(boolean header) {
        this.header = header;
        return this;
    }

    public Builder copyLibs(boolean copyLibs) {
        this.copyLibs = copyLibs;
        return this;
    }

    public Builder copyResources(boolean copyResources) {
        this.copyResources = copyResources;
        return this;
    }

    public Builder outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }

    public Builder jarPrefix(String jarPrefix) {
        this.jarPrefix = jarPrefix;
        return this;
    }

    public Builder properties(String platform) {
        if (platform != null) {
            this.properties = Loader.loadProperties(platform, null);
        }
        return this;
    }

    public Builder properties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                this.property((String)e.getKey(), (String)e.getValue());
            }
        }
        return this;
    }

    public Builder propertyFile(String filename) throws IOException {
        this.propertyFile(filename == null ? null : new File(filename));
        return this;
    }

    public Builder propertyFile(File propertyFile) throws IOException {
        if (propertyFile == null) {
            return this;
        }
        FileInputStream fis = new FileInputStream(propertyFile);
        this.properties = new Properties();
        try {
            this.properties.load(new InputStreamReader(fis));
        }
        catch (NoSuchMethodError e) {
            this.properties.load(fis);
        }
        fis.close();
        return this;
    }

    public Builder property(String keyValue) {
        int equalIndex = keyValue.indexOf(61);
        if (equalIndex < 0) {
            equalIndex = keyValue.indexOf(58);
        }
        this.property(keyValue.substring(2, equalIndex), keyValue.substring(equalIndex + 1));
        return this;
    }

    public Builder property(String key, String value) {
        if (key.length() > 0 && value.length() > 0) {
            this.properties.put(key, value);
        }
        return this;
    }

    public Builder classesOrPackages(String ... classesOrPackages) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        if (classesOrPackages == null) {
            this.classScanner.addPackage(null, true);
        } else {
            for (String s : classesOrPackages) {
                this.classScanner.addClassOrPackage(s);
            }
        }
        return this;
    }

    public Builder buildCommand(String[] buildCommand) {
        this.buildCommand = buildCommand;
        return this;
    }

    public Builder workingDirectory(String workingDirectory) {
        this.workingDirectory(workingDirectory == null ? null : new File(workingDirectory));
        return this;
    }

    public Builder workingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public Builder environmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Builder compilerOptions(String ... options) {
        if (options != null) {
            this.compilerOptions.addAll(Arrays.asList(options));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public File[] build() throws IOException, InterruptedException, ParserException {
        if (this.buildCommand != null && this.buildCommand.length > 0) {
            int exitValue;
            void var4_11;
            void var4_9;
            List<String> command = Arrays.asList(this.buildCommand);
            String platform = Loader.getPlatform();
            boolean windows = platform.startsWith("windows");
            boolean bl = false;
            while (var4_9 < command.size()) {
                Object arg = command.get((int)var4_9);
                if (arg == null) {
                    arg = "";
                }
                if (((String)arg).trim().isEmpty() && windows) {
                    arg = "\"\"";
                }
                command.set((int)var4_9, (String)arg);
                ++var4_9;
            }
            String string = "";
            for (String s : command) {
                void var4_16;
                void var4_13;
                boolean hasSpaces;
                boolean bl2 = hasSpaces = s.indexOf(" ") > 0 || s.isEmpty();
                if (hasSpaces) {
                    String string2 = (String)var4_11 + (windows ? "\"" : "'");
                }
                String string3 = (String)var4_13 + s;
                if (hasSpaces) {
                    String string4 = string3 + (windows ? "\"" : "'");
                }
                String string5 = (String)var4_16 + " ";
            }
            this.logger.info((String)var4_11);
            ProcessBuilder pb = new ProcessBuilder(command);
            if (this.workingDirectory != null) {
                pb.directory(this.workingDirectory);
            }
            if (this.environmentVariables != null) {
                pb.environment().putAll(this.environmentVariables);
            }
            String paths = this.properties.getProperty("platform.buildpath", "");
            String links = this.properties.getProperty("platform.linkresource", "");
            String resources = this.properties.getProperty("platform.buildresource", "");
            String separator = this.properties.getProperty("platform.path.separator");
            if (paths.length() > 0 || resources.length() > 0) {
                ArrayList<String> libs = new ArrayList<String>();
                ClassProperties libProperties = null;
                for (Class c : this.classScanner.getClasses()) {
                    if (Loader.getEnclosingClass(c) != c) continue;
                    libProperties = Loader.loadProperties(c, this.properties, true);
                    if (!libProperties.isLoaded()) {
                        this.logger.warn("Could not load platform properties for " + c);
                        continue;
                    }
                    libs.addAll(libProperties.get("platform.preload"));
                    libs.addAll(libProperties.get("platform.link"));
                }
                for (String s : resources.split(separator)) {
                    for (File f : Loader.cacheResources(s)) {
                        String path = f.getCanonicalPath();
                        if (paths.length() > 0 && !paths.endsWith(separator)) {
                            paths = paths + separator;
                        }
                        paths = paths + path;
                        ArrayList<String> linkPaths = new ArrayList<String>();
                        for (String s2 : links.split(separator)) {
                            for (File f2 : Loader.cacheResources(s2)) {
                                String path2 = f2.getCanonicalPath();
                                if (!path2.startsWith(path) || path2.equals(path)) continue;
                                linkPaths.add(path2);
                            }
                        }
                        File[] files = f.listFiles();
                        if (files == null || libProperties == null) continue;
                        for (File file : files) {
                            Loader.createLibraryLink(file.getAbsolutePath(), libProperties, null, linkPaths.toArray(new String[linkPaths.size()]));
                        }
                    }
                }
                if (paths.length() > 0) {
                    pb.environment().put("BUILD_PATH", paths);
                    pb.environment().put("BUILD_PATH_SEPARATOR", separator);
                }
            }
            if ((exitValue = pb.inheritIO().start().waitFor()) != 0) {
                throw new RuntimeException("Process exited with an error: " + exitValue);
            }
            return null;
        }
        if (this.classScanner.getClasses().isEmpty()) {
            return null;
        }
        ArrayList<File> outputFiles = new ArrayList<File>();
        LinkedHashMap<String, LinkedHashSet<Class>> map = new LinkedHashMap<String, LinkedHashSet<Class>>();
        for (Class clazz : this.classScanner.getClasses()) {
            if (Loader.getEnclosingClass(clazz) != clazz) continue;
            ClassProperties p = Loader.loadProperties(clazz, this.properties, false);
            if (!p.isLoaded()) {
                this.logger.warn("Could not load platform properties for " + clazz);
                continue;
            }
            try {
                if (Arrays.asList(clazz.getInterfaces()).contains(BuildEnabled.class)) {
                    ((BuildEnabled)clazz.newInstance()).init(this.logger, this.properties, this.encoding);
                }
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException paths) {
                // empty catch block
            }
            String target = p.getProperty("target");
            if (target != null && !clazz.getName().equals(target)) {
                File f = this.parse(this.classScanner.getClassLoader().getPaths(), clazz);
                if (f == null) continue;
                outputFiles.add(f);
                continue;
            }
            String libraryName = this.outputName != null ? this.outputName : p.getProperty("platform.library", "");
            if (libraryName.length() == 0) continue;
            LinkedHashSet<Class> classList = (LinkedHashSet<Class>)map.get(libraryName);
            if (classList == null) {
                classList = new LinkedHashSet<Class>();
                map.put(libraryName, classList);
            }
            classList.addAll(p.getEffectiveClasses());
        }
        int count = 0;
        for (String libraryName : map.keySet()) {
            LinkedHashSet classSet = (LinkedHashSet)map.get(libraryName);
            Class[] classArray = classSet.toArray(new Class[classSet.size()]);
            File[] files = this.generateAndCompile(classArray, libraryName, count == 0, count == map.size() - 1);
            if (files != null && files.length > 0) {
                ClassProperties p;
                File directory = files[files.length - 1].getParentFile();
                outputFiles.addAll(Arrays.asList(files));
                if (this.copyLibs) {
                    p = Loader.loadProperties(classArray, this.properties, false);
                    ArrayList<String> preloads = new ArrayList<String>();
                    preloads.addAll(p.get("platform.preload"));
                    preloads.addAll(p.get("platform.link"));
                    ClassProperties p2 = Loader.loadProperties(classArray, this.properties, true);
                    for (String s : preloads) {
                        int length;
                        File fi;
                        if (s.trim().endsWith("#")) continue;
                        URL[] urls = Loader.findLibrary(null, p, s);
                        try {
                            fi = new File(urls[0].toURI());
                        }
                        catch (Exception e) {
                            urls = Loader.findLibrary(null, p2, s);
                            try {
                                fi = new File(urls[0].toURI());
                            }
                            catch (Exception e2) {
                                this.logger.warn("Could not find library " + s);
                                continue;
                            }
                        }
                        File fo = new File(directory, fi.getName());
                        if (!fi.exists() || outputFiles.contains(fo)) continue;
                        this.logger.info("Copying " + fi);
                        FileInputStream fis = new FileInputStream(fi);
                        FileOutputStream fos = new FileOutputStream(fo);
                        byte[] buffer = new byte[1024];
                        while ((length = fis.read(buffer)) != -1) {
                            fos.write(buffer, 0, length);
                        }
                        fos.close();
                        fis.close();
                        outputFiles.add(fo);
                    }
                }
                if (this.copyResources) {
                    p = Loader.loadProperties(classArray, this.properties, false);
                    List<String> resources = p.get("platform.resource");
                    p = Loader.loadProperties(classArray, this.properties, true);
                    List<String> paths = p.get("platform.resourcepath");
                    Path directoryPath = directory.toPath();
                    for (String resource : resources) {
                        final Path target = directoryPath.resolve(resource);
                        if (!Files.exists(target, new LinkOption[0])) {
                            Files.createDirectories(target, new FileAttribute[0]);
                        }
                        for (String path : paths) {
                            final Path source = Paths.get(path, resource);
                            if (!Files.exists(source, new LinkOption[0])) continue;
                            this.logger.info("Copying " + source);
                            Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                    block2: {
                                        Path targetdir = target.resolve(source.relativize(dir));
                                        try {
                                            Files.copy(dir, targetdir, StandardCopyOption.REPLACE_EXISTING);
                                        }
                                        catch (DirectoryNotEmptyException | FileAlreadyExistsException e) {
                                            if (Files.isDirectory(targetdir, new LinkOption[0])) break block2;
                                            throw e;
                                        }
                                    }
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                    }
                }
            }
            ++count;
        }
        File[] fileArray = outputFiles.toArray(new File[outputFiles.size()]);
        if (this.jarPrefix != null && fileArray.length > 0) {
            File jarFile = new File(this.jarPrefix + "-" + this.properties.getProperty("platform") + this.properties.getProperty("platform.extension", "") + ".jar");
            File d = jarFile.getParentFile();
            if (d != null && !d.exists()) {
                d.mkdir();
            }
            this.createJar(jarFile, this.outputDirectory == null ? this.classScanner.getClassLoader().getPaths() : null, fileArray);
        }
        System.setProperty("org.bytedeco.javacpp.loadlibraries", "true");
        return fileArray;
    }

    public static void printHelp() {
        String version = Builder.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        System.out.println("JavaCPP version " + version + "\nCopyright (C) 2011-2017 Samuel Audet <samuel.audet@gmail.com>\nProject site: https://github.com/bytedeco/javacpp");
        System.out.println();
        System.out.println("Usage: java -jar javacpp.jar [options] [class or package (suffixed with .* or .**)]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println();
        System.out.println("    -classpath <path>      Load user classes from path");
        System.out.println("    -encoding <name>       Character encoding used for input and output files");
        System.out.println("    -d <directory>         Output all generated files to directory");
        System.out.println("    -o <name>              Output everything in a file named after given name");
        System.out.println("    -nocompile             Do not compile or delete the generated source files");
        System.out.println("    -nodelete              Do not delete generated C++ JNI files after compilation");
        System.out.println("    -header                Generate header file with declarations of callbacks functions");
        System.out.println("    -copylibs              Copy to output directory dependent libraries (link and preload)");
        System.out.println("    -copyresources         Copy to output directory resources listed in properties");
        System.out.println("    -jarprefix <prefix>    Also create a JAR file named \"<prefix>-<platform>.jar\"");
        System.out.println("    -properties <resource> Load all properties from resource");
        System.out.println("    -propertyfile <file>   Load all properties from file");
        System.out.println("    -D<property>=<value>   Set property to value");
        System.out.println("    -Xcompiler <option>    Pass option directly to compiler");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        boolean addedClasses = false;
        Builder builder = new Builder();
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i]) || "--help".equals(args[i])) {
                Builder.printHelp();
                System.exit(0);
                continue;
            }
            if ("-classpath".equals(args[i]) || "-cp".equals(args[i]) || "-lib".equals(args[i])) {
                builder.classPaths(args[++i]);
                continue;
            }
            if ("-encoding".equals(args[i])) {
                builder.encoding(args[++i]);
                continue;
            }
            if ("-d".equals(args[i])) {
                builder.outputDirectory(args[++i]);
                continue;
            }
            if ("-o".equals(args[i])) {
                builder.outputName(args[++i]);
                continue;
            }
            if ("-cpp".equals(args[i]) || "-nocompile".equals(args[i])) {
                builder.compile(false);
                continue;
            }
            if ("-nodelete".equals(args[i])) {
                builder.deleteJniFiles(false);
                continue;
            }
            if ("-header".equals(args[i])) {
                builder.header(true);
                continue;
            }
            if ("-copylibs".equals(args[i])) {
                builder.copyLibs(true);
                continue;
            }
            if ("-copyresources".equals(args[i])) {
                builder.copyResources(true);
                continue;
            }
            if ("-jarprefix".equals(args[i])) {
                builder.jarPrefix(args[++i]);
                continue;
            }
            if ("-properties".equals(args[i])) {
                builder.properties(args[++i]);
                continue;
            }
            if ("-propertyfile".equals(args[i])) {
                builder.propertyFile(args[++i]);
                continue;
            }
            if (args[i].startsWith("-D")) {
                builder.property(args[i]);
                continue;
            }
            if ("-Xcompiler".equals(args[i])) {
                builder.compilerOptions(args[++i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                builder.logger.error("Invalid option \"" + args[i] + "\"");
                Builder.printHelp();
                System.exit(1);
                continue;
            }
            builder.classesOrPackages(args[i]);
            addedClasses = true;
        }
        if (!addedClasses) {
            builder.classesOrPackages(null);
        }
        builder.build();
    }
}

