/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.bytesoft.bytejta.supports.jdbc.DataSourceHolder;
import org.bytesoft.bytejta.supports.jdbc.LocalXACompatible;
import org.bytesoft.bytejta.supports.jdbc.LocalXAConnection;
import org.bytesoft.bytejta.supports.jdbc.LocalXAResource;
import org.bytesoft.bytejta.supports.jdbc.LogicalConnection;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.springframework.beans.factory.BeanNameAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalXADataSource
implements XADataSource,
DataSource,
DataSourceHolder,
BeanNameAware {
    private PrintWriter logWriter;
    private int loginTimeout;
    private DataSource dataSource;
    private String beanName;
    @Resource
    private TransactionManager transactionManager;

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LocalXAConnection xacon;
            Transaction transaction = (Transaction)this.transactionManager.getTransaction();
            if (transaction == null) {
                return this.dataSource.getConnection();
            }
            XAResourceDescriptor descriptor = transaction.getResourceDescriptor(this.beanName);
            LocalXAResource resource = descriptor == null ? null : (LocalXAResource)descriptor.getDelegate();
            LocalXAConnection localXAConnection = xacon = resource == null ? null : resource.getManagedConnection();
            if (xacon != null) {
                return xacon.getConnection();
            }
            xacon = this.getXAConnection();
            LogicalConnection connection = xacon.getConnection();
            descriptor = xacon.getXAResource();
            LocalXAResource localXARes = (LocalXAResource)descriptor.getDelegate();
            TransactionContext transactionContext = transaction.getTransactionContext();
            boolean loggingRequired = LocalXACompatible.class.isInstance(transactionContext) ? ((LocalXACompatible)transactionContext).compatibleLoggingLRO() : false;
            localXARes.setLoggingRequired(loggingRequired);
            transaction.enlistResource((XAResource)descriptor);
            return connection;
        }
        catch (SystemException ex) {
            throw new SQLException(ex);
        }
        catch (RollbackException ex) {
            throw new SQLException(ex);
        }
        catch (RuntimeException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            LocalXAConnection xacon;
            Transaction transaction = (Transaction)this.transactionManager.getTransaction();
            if (transaction == null) {
                return this.dataSource.getConnection(username, password);
            }
            XAResourceDescriptor descriptor = transaction.getResourceDescriptor(this.beanName);
            LocalXAResource resource = descriptor == null ? null : (LocalXAResource)descriptor.getDelegate();
            LocalXAConnection localXAConnection = xacon = resource == null ? null : resource.getManagedConnection();
            if (xacon != null) {
                return xacon.getConnection();
            }
            xacon = this.getXAConnection(username, password);
            LogicalConnection connection = xacon.getConnection();
            descriptor = xacon.getXAResource();
            LocalXAResource localXARes = (LocalXAResource)descriptor.getDelegate();
            TransactionContext transactionContext = transaction.getTransactionContext();
            boolean loggingRequired = LocalXACompatible.class.isInstance(transactionContext) ? ((LocalXACompatible)transactionContext).compatibleLoggingLRO() : false;
            localXARes.setLoggingRequired(loggingRequired);
            transaction.enlistResource((XAResource)descriptor);
            return connection;
        }
        catch (SystemException ex) {
            throw new SQLException(ex);
        }
        catch (RollbackException ex) {
            throw new SQLException(ex);
        }
        catch (RuntimeException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        if (iface == null) {
            return false;
        }
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        if (iface == null) {
            return null;
        }
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    public LocalXAConnection getXAConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        LocalXAConnection xacon = new LocalXAConnection(connection);
        xacon.setResourceId(this.beanName);
        return xacon;
    }

    public LocalXAConnection getXAConnection(String user, String passwd) throws SQLException {
        Connection connection = this.dataSource.getConnection(user, passwd);
        LocalXAConnection xacon = new LocalXAConnection(connection);
        xacon.setResourceId(this.beanName);
        return xacon;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

