/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.jms.XAConnectionFactory;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XADataSource;
import org.bytesoft.bytejta.supports.resource.ManagedConnectionFactoryHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ManagedConnectionFactoryPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        ClassLoader cl = clazz.getClassLoader();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (XADataSource.class.isInstance(bean)) {
            ManagedConnectionFactoryHandler interceptor = new ManagedConnectionFactoryHandler(bean);
            interceptor.setIdentifier(beanName);
            return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
        }
        if (XAConnectionFactory.class.isInstance(bean)) {
            ManagedConnectionFactoryHandler interceptor = new ManagedConnectionFactoryHandler(bean);
            interceptor.setIdentifier(beanName);
            return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
        }
        if (ManagedConnectionFactory.class.isInstance(bean)) {
            ManagedConnectionFactoryHandler interceptor = new ManagedConnectionFactoryHandler(bean);
            interceptor.setIdentifier(beanName);
            return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
        }
        return bean;
    }
}

