/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReport;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricBatchesBuilder;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.batch.CleanableHistoricBatchReportDto;
import org.camunda.bpm.engine.rest.dto.history.batch.CleanableHistoricBatchReportResultDto;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchDto;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchQueryDto;
import org.camunda.bpm.engine.rest.dto.history.batch.removaltime.SetRemovalTimeToHistoricBatchesDto;
import org.camunda.bpm.engine.rest.history.HistoricBatchRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricBatchResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricBatchResourceImpl;

public class HistoricBatchRestServiceImpl
implements HistoricBatchRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricBatchRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricBatchResource getHistoricBatch(String batchId) {
        return new HistoricBatchResourceImpl(this.processEngine, batchId);
    }

    @Override
    public List<HistoricBatchDto> getHistoricBatches(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricBatchQueryDto queryDto = new HistoricBatchQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricBatchQuery query = (HistoricBatchQuery)queryDto.toQuery(this.processEngine);
        List<?> matchingBatches = firstResult != null || maxResults != null ? this.executePaginatedQuery((Query)query, firstResult, maxResults) : query.list();
        ArrayList<HistoricBatchDto> batchResults = new ArrayList<HistoricBatchDto>();
        for (HistoricBatch matchingBatch : matchingBatches) {
            batchResults.add(HistoricBatchDto.fromBatch(matchingBatch));
        }
        return batchResults;
    }

    @Override
    public CountResultDto getHistoricBatchesCount(UriInfo uriInfo) {
        HistoricBatchQueryDto queryDto = new HistoricBatchQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricBatchQuery query = (HistoricBatchQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }

    protected List<?> executePaginatedQuery(Query query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public List<CleanableHistoricBatchReportResultDto> getCleanableHistoricBatchesReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricBatchReportDto queryDto = new CleanableHistoricBatchReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricBatchReport query = (CleanableHistoricBatchReport)queryDto.toQuery(this.processEngine);
        List<CleanableHistoricBatchReportResult> reportResult = firstResult != null || maxResults != null ? this.executePaginatedQuery((Query)query, firstResult, maxResults) : query.list();
        return CleanableHistoricBatchReportResultDto.convert(reportResult);
    }

    @Override
    public CountResultDto getCleanableHistoricBatchesReportCount(UriInfo uriInfo) {
        CleanableHistoricBatchReportDto queryDto = new CleanableHistoricBatchReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricBatchReport query = (CleanableHistoricBatchReport)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricBatchesDto dto) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricBatchQuery historicBatchQuery = null;
        if (dto.getHistoricBatchQuery() != null) {
            historicBatchQuery = (HistoricBatchQuery)dto.getHistoricBatchQuery().toQuery(this.processEngine);
        }
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = historyService.setRemovalTimeToHistoricBatches();
        if (dto.isCalculatedRemovalTime()) {
            builder.calculatedRemovalTime();
        }
        Date removalTime = dto.getAbsoluteRemovalTime();
        if (dto.getAbsoluteRemovalTime() != null) {
            builder.absoluteRemovalTime(removalTime);
        }
        if (dto.isClearedRemovalTime()) {
            builder.clearedRemovalTime();
        }
        builder.byIds(dto.getHistoricBatchIds());
        builder.byQuery(historicBatchQuery);
        Batch batch = builder.executeAsync();
        return BatchDto.fromBatch(batch);
    }
}

