/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.PatchVariablesDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.impl.VariableResponseProvider;
import org.camunda.bpm.engine.runtime.DeserializationTypeValidator;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractVariablesResource
implements VariableResource {
    protected static final String DEFAULT_BINARY_VALUE_TYPE = "Bytes";
    protected ProcessEngine engine;
    protected String resourceId;
    protected ObjectMapper objectMapper;

    public AbstractVariablesResource(ProcessEngine engine, String resourceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.resourceId = resourceId;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, VariableValueDto> getVariables(boolean deserializeValues) {
        VariableMap variables = this.getVariableEntities(deserializeValues);
        return VariableValueDto.fromMap(variables);
    }

    @Override
    public VariableValueDto getVariable(String variableName, boolean deserializeValue) {
        TypedValue value = this.getTypedValueForVariable(variableName, deserializeValue);
        return VariableValueDto.fromTypedValue(value);
    }

    protected TypedValue getTypedValueForVariable(String variableName, boolean deserializeValue) {
        TypedValue value = null;
        try {
            value = this.getVariableEntity(variableName, deserializeValue);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot get %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        if (value == null) {
            String errorMessage = String.format("%s variable with name %s does not exist", this.getResourceTypeName(), variableName);
            throw new InvalidRequestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return value;
    }

    @Override
    public Response getVariableBinary(String variableName) {
        TypedValue typedValue = this.getTypedValueForVariable(variableName, false);
        return new VariableResponseProvider().getResponseForTypedVariable(typedValue, this.resourceId);
    }

    @Override
    public void putVariable(String variableName, VariableValueDto variable) {
        try {
            TypedValue typedValue = variable.toTypedValue(this.engine, this.objectMapper);
            this.setVariableEntity(variableName, typedValue);
        }
        catch (RestException e) {
            throw new InvalidRequestException(e.getStatus(), e, String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage()));
        }
        catch (BadUserRequestException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage()));
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage()));
        }
    }

    @Override
    public void setBinaryVariable(String variableKey, MultipartFormData payload) {
        MultipartFormData.FormPart dataPart = payload.getNamedPart("data");
        MultipartFormData.FormPart objectTypePart = payload.getNamedPart("type");
        MultipartFormData.FormPart valueTypePart = payload.getNamedPart("valueType");
        if (objectTypePart != null) {
            Object object = null;
            if (dataPart.getContentType() == null || !dataPart.getContentType().toLowerCase().contains("application/json")) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unrecognized content type for serialized java type: " + dataPart.getContentType());
            }
            object = this.deserializeJsonObject(objectTypePart.getTextContent(), dataPart.getBinaryContent());
            if (object != null) {
                this.setVariableEntity(variableKey, Variables.objectValue((Object)object).create());
            }
        } else {
            String valueTypeName = DEFAULT_BINARY_VALUE_TYPE;
            if (valueTypePart != null) {
                if (valueTypePart.getTextContent() == null) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Form part with name 'valueType' must have a text/plain value");
                }
                valueTypeName = valueTypePart.getTextContent();
            }
            VariableValueDto valueDto = VariableValueDto.fromFormPart(valueTypeName, dataPart);
            try {
                TypedValue typedValue = valueDto.toTypedValue(this.engine, this.objectMapper);
                this.setVariableEntity(variableKey, typedValue);
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ProcessEngineException e) {
                String errorMessage = String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableKey, e.getMessage());
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
            }
        }
    }

    protected Object deserializeJsonObject(String className, byte[] data) {
        try {
            JavaType type = TypeFactory.defaultInstance().constructFromCanonical(className);
            this.validateType(type);
            return this.objectMapper.readValue(new String(data, Charset.forName("UTF-8")), type);
        }
        catch (Exception e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not deserialize JSON object: " + e.getMessage());
        }
    }

    protected void validateType(JavaType type) {
        DeserializationTypeValidator validator;
        if (this.getProcessEngineConfiguration().isDeserializationTypeValidationEnabled() && (validator = this.getProcessEngineConfiguration().getDeserializationTypeValidator()) != null) {
            ArrayList<String> invalidTypes = new ArrayList<String>();
            this.validateType(type, validator, invalidTypes);
            if (!invalidTypes.isEmpty()) {
                throw new IllegalArgumentException("The following classes are not whitelisted for deserialization: " + invalidTypes);
            }
        }
    }

    protected void validateType(JavaType type, DeserializationTypeValidator validator, List<String> invalidTypes) {
        if (!type.isPrimitive()) {
            if (!type.isArrayType()) {
                this.validateTypeInternal(type, validator, invalidTypes);
            }
            if (type.isMapLikeType()) {
                this.validateType(type.getKeyType(), validator, invalidTypes);
            }
            if (type.isContainerType() || type.hasContentType()) {
                this.validateType(type.getContentType(), validator, invalidTypes);
            }
        }
    }

    protected void validateTypeInternal(JavaType type, DeserializationTypeValidator validator, List<String> invalidTypes) {
        String className = type.getRawClass().getName();
        if (!validator.validate(className) && !invalidTypes.contains(className)) {
            invalidTypes.add(className);
        }
    }

    protected ProcessEngineConfiguration getProcessEngineConfiguration() {
        return this.engine.getProcessEngineConfiguration();
    }

    @Override
    public void deleteVariable(String variableName) {
        try {
            this.removeVariableEntity(variableName);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot delete %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    @Override
    public void modifyVariables(PatchVariablesDto patch) {
        VariableMap variableModifications = null;
        try {
            variableModifications = VariableValueDto.toMap(patch.getModifications(), this.engine, this.objectMapper);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot modify variables for %s: %s", this.getResourceTypeName(), e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        List<String> variableDeletions = patch.getDeletions();
        try {
            this.updateVariableEntities(variableModifications, variableDeletions);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot modify variables for %s %s: %s", this.getResourceTypeName(), this.resourceId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    protected abstract VariableMap getVariableEntities(boolean var1);

    protected abstract void updateVariableEntities(VariableMap var1, List<String> var2);

    protected abstract TypedValue getVariableEntity(String var1, boolean var2);

    protected abstract void setVariableEntity(String var1, TypedValue var2);

    protected abstract void removeVariableEntity(String var1);

    protected abstract String getResourceTypeName();
}

