/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.tomcat.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.deployment.AbstractParseBpmPlatformXmlStep;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;

public class TomcatParseBpmPlatformXmlStep
extends AbstractParseBpmPlatformXmlStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    public static final String CATALINA_BASE = "catalina.base";
    public static final String CATALINA_HOME = "catalina.home";

    @Override
    public URL getBpmPlatformXmlStream(DeploymentOperation operationcontext) {
        URL fileLocation = this.lookupBpmPlatformXml();
        if (fileLocation == null) {
            fileLocation = this.lookupBpmPlatformXmlFromCatalinaConfDirectory();
        }
        return fileLocation;
    }

    public URL lookupBpmPlatformXmlFromCatalinaConfDirectory() {
        String catalinaHome = System.getProperty(CATALINA_BASE);
        if (catalinaHome == null) {
            catalinaHome = System.getProperty(CATALINA_HOME);
        }
        String bpmPlatformFileLocation = catalinaHome + File.separator + "conf" + File.separator + "bpm-platform.xml";
        try {
            URL fileLocation = this.checkValidFileLocation(bpmPlatformFileLocation);
            if (fileLocation != null) {
                LOG.foundTomcatDeploymentDescriptor(bpmPlatformFileLocation, fileLocation.toString());
            }
            return fileLocation;
        }
        catch (MalformedURLException e) {
            throw LOG.invalidDeploymentDescriptorLocation(bpmPlatformFileLocation, e);
        }
    }
}

