/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.ExternalTaskQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ExternalTaskQueryImpl
extends AbstractQuery<ExternalTaskQuery, ExternalTask>
implements ExternalTaskQuery {
    private static final long serialVersionUID = 1L;
    protected String externalTaskId;
    protected String workerId;
    protected Date lockExpirationBefore;
    protected Date lockExpirationAfter;
    protected String topicName;
    protected Boolean locked;
    protected Boolean notLocked;
    protected String executionId;
    protected String processInstanceId;
    protected String[] processInstanceIdIn;
    protected String processDefinitionId;
    protected String activityId;
    protected String[] activityIdIn;
    protected SuspensionState suspensionState;
    protected Long priorityHigherThanOrEquals;
    protected Long priorityLowerThanOrEquals;
    protected Boolean retriesLeft;
    protected String[] tenantIds;

    public ExternalTaskQueryImpl() {
    }

    public ExternalTaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ExternalTaskQuery externalTaskId(String externalTaskId) {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)externalTaskId);
        this.externalTaskId = externalTaskId;
        return this;
    }

    @Override
    public ExternalTaskQuery workerId(String workerId) {
        EnsureUtil.ensureNotNull("workerId", (Object)workerId);
        this.workerId = workerId;
        return this;
    }

    @Override
    public ExternalTaskQuery lockExpirationBefore(Date lockExpirationDate) {
        EnsureUtil.ensureNotNull("lockExpirationBefore", (Object)lockExpirationDate);
        this.lockExpirationBefore = lockExpirationDate;
        return this;
    }

    @Override
    public ExternalTaskQuery lockExpirationAfter(Date lockExpirationDate) {
        EnsureUtil.ensureNotNull("lockExpirationAfter", (Object)lockExpirationDate);
        this.lockExpirationAfter = lockExpirationDate;
        return this;
    }

    @Override
    public ExternalTaskQuery topicName(String topicName) {
        EnsureUtil.ensureNotNull("topicName", (Object)topicName);
        this.topicName = topicName;
        return this;
    }

    @Override
    public ExternalTaskQuery locked() {
        this.locked = Boolean.TRUE;
        return this;
    }

    @Override
    public ExternalTaskQuery notLocked() {
        this.notLocked = Boolean.TRUE;
        return this;
    }

    @Override
    public ExternalTaskQuery executionId(String executionId) {
        EnsureUtil.ensureNotNull("executionId", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public ExternalTaskQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ExternalTaskQuery processInstanceIdIn(String ... processInstanceIdIn) {
        EnsureUtil.ensureNotNull("processInstanceIdIn", processInstanceIdIn);
        this.processInstanceIdIn = processInstanceIdIn;
        return this;
    }

    @Override
    public ExternalTaskQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ExternalTaskQuery activityId(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public ExternalTaskQuery activityIdIn(String ... activityIdIn) {
        EnsureUtil.ensureNotNull("activityIdIn", activityIdIn);
        this.activityIdIn = activityIdIn;
        return this;
    }

    @Override
    public ExternalTaskQuery priorityHigherThanOrEquals(long priority) {
        this.priorityHigherThanOrEquals = priority;
        return this;
    }

    @Override
    public ExternalTaskQuery priorityLowerThanOrEquals(long priority) {
        this.priorityLowerThanOrEquals = priority;
        return this;
    }

    @Override
    public ExternalTaskQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ExternalTaskQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ExternalTaskQuery withRetriesLeft() {
        this.retriesLeft = Boolean.TRUE;
        return this;
    }

    @Override
    public ExternalTaskQuery noRetriesLeft() {
        this.retriesLeft = Boolean.FALSE;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.areNotInAscendingOrder((Comparable[])new Long[]{this.priorityHigherThanOrEquals, this.priorityLowerThanOrEquals});
    }

    @Override
    public ExternalTaskQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public ExternalTaskQuery orderById() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.ID);
    }

    @Override
    public ExternalTaskQuery orderByLockExpirationTime() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.LOCK_EXPIRATION_TIME);
    }

    @Override
    public ExternalTaskQuery orderByProcessInstanceId() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public ExternalTaskQuery orderByProcessDefinitionId() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public ExternalTaskQuery orderByProcessDefinitionKey() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public ExternalTaskQuery orderByTenantId() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.TENANT_ID);
    }

    @Override
    public ExternalTaskQuery orderByPriority() {
        return (ExternalTaskQuery)this.orderBy(ExternalTaskQueryProperty.PRIORITY);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getExternalTaskManager().findExternalTaskCountByQueryCriteria(this);
    }

    @Override
    public List<ExternalTask> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getExternalTaskManager().findExternalTasksByQueryCriteria(this);
    }

    @Override
    public List<String> executeIdsList(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getExternalTaskManager().findExternalTaskIdsByQueryCriteria(this);
    }

    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Date getLockExpirationBefore() {
        return this.lockExpirationBefore;
    }

    public Date getLockExpirationAfter() {
        return this.lockExpirationAfter;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Boolean getNotLocked() {
        return this.notLocked;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public Boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public Date getNow() {
        return ClockUtil.getCurrentTime();
    }
}

