/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ModificationBatchConfiguration;
import org.camunda.bpm.engine.impl.ModificationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractModificationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.BatchUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ProcessInstanceModificationBatchCmd
extends AbstractModificationCmd<Batch> {
    protected static final CommandLogger LOGGER = ProcessEngineLogger.CMD_LOGGER;

    public ProcessInstanceModificationBatchCmd(ModificationBuilderImpl modificationBuilderImpl) {
        super(modificationBuilderImpl);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getInstructions();
        Collection<String> processInstanceIds = this.collectProcessInstanceIds(commandContext);
        String annotation = this.builder.getAnnotation();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Modification instructions cannot be empty", instructions);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "Process instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "Process instance ids", processInstanceIds);
        this.checkPermissions(commandContext);
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, this.builder.getProcessDefinitionId());
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process definition id cannot be null", (Object)processDefinition);
        this.writeUserOperationLog(commandContext, processDefinition, processInstanceIds.size(), true, annotation);
        BatchEntity batch = this.createBatch(commandContext, instructions, processInstanceIds, processDefinition);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected void checkPermissions(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateBatch(BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES);
        }
    }

    protected BatchEntity createBatch(CommandContext commandContext, List<AbstractProcessInstanceModificationCommand> instructions, Collection<String> processInstanceIds, ProcessDefinitionEntity processDefinition) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<ModificationBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        ModificationBatchConfiguration configuration = new ModificationBatchConfiguration(new ArrayList<String>(processInstanceIds), this.builder.getProcessDefinitionId(), instructions, this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(BatchUtil.calculateBatchSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        batch.setTenantId(processDefinition.getTenantId());
        commandContext.getBatchManager().insertBatch(batch);
        return batch;
    }

    protected BatchJobHandler<ModificationBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Map<String, BatchJobHandler<?>> batchHandlers = processEngineConfiguration.getBatchHandlers();
        return batchHandlers.get("instance-modification");
    }
}

