/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.camunda.bpm.engine.impl.cmd.UnlockJobCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.interceptor.ProcessDataLoggingContext;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.jobexecutor.JobFailureCollector;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;

public class ExecuteJobsRunnable
implements Runnable {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected final List<String> jobIds;
    protected JobExecutor jobExecutor;
    protected ProcessEngineImpl processEngine;

    public ExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        this.jobIds = jobIds;
        this.processEngine = processEngine;
        this.jobExecutor = processEngine.getProcessEngineConfiguration().getJobExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        JobExecutorContext jobExecutorContext = new JobExecutorContext();
        List<String> currentProcessorJobQueue = jobExecutorContext.getCurrentProcessorJobQueue();
        ProcessEngineConfigurationImpl engineConfiguration = this.processEngine.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = engineConfiguration.getCommandExecutorTxRequired();
        currentProcessorJobQueue.addAll(this.jobIds);
        Context.setJobExecutorContext(jobExecutorContext);
        ClassLoader classLoaderBeforeExecution = this.switchClassLoader();
        try {
            while (!currentProcessorJobQueue.isEmpty()) {
                String nextJobId = currentProcessorJobQueue.remove(0);
                if (this.jobExecutor.isActive()) {
                    JobFailureCollector jobFailureCollector = new JobFailureCollector(nextJobId);
                    try {
                        ExecuteJobHelper.executeJob(nextJobId, commandExecutor, jobFailureCollector, new ExecuteJobsCmd(nextJobId, jobFailureCollector), engineConfiguration);
                        continue;
                    }
                    catch (Throwable t) {
                        if (!ProcessEngineLogger.shouldLogJobException(engineConfiguration, jobFailureCollector.getJob())) continue;
                        ExecuteJobHelper.LOGGING_HANDLER.exceptionWhileExecutingJob(nextJobId, t);
                        continue;
                    }
                    finally {
                        new ProcessDataLoggingContext(engineConfiguration).clearMdc();
                        continue;
                    }
                }
                try {
                    this.unlockJob(nextJobId, commandExecutor);
                }
                catch (Throwable t) {
                    LOG.exceptionWhileUnlockingJob(nextJobId, t);
                }
            }
            this.jobExecutor.jobWasAdded();
            return;
        }
        finally {
            Context.removeJobExecutorContext();
            ClassLoaderUtil.setContextClassloader(classLoaderBeforeExecution);
        }
    }

    protected void executeJob(String nextJobId, CommandExecutor commandExecutor) {
        ExecuteJobHelper.executeJob(nextJobId, commandExecutor);
    }

    protected void unlockJob(String nextJobId, CommandExecutor commandExecutor) {
        commandExecutor.execute(new UnlockJobCmd(nextJobId));
    }

    protected ClassLoader switchClassLoader() {
        ClassLoader classLoaderBeforeExecution = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ProcessEngine.class.getClassLoader());
        return classLoaderBeforeExecution;
    }
}

