/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;

public class CommandCounterInterceptor
extends CommandInterceptor {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public CommandCounterInterceptor(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        try {
            T t = this.next.execute(command);
            return t;
        }
        finally {
            TelemetryRegistry telemetryRegistry = this.processEngineConfiguration.getTelemetryRegistry();
            if (telemetryRegistry != null && telemetryRegistry.isCollectingTelemetryDataEnabled()) {
                String className = ClassNameUtil.getClassNameWithoutPackage(command);
                if (!command.getClass().isAnonymousClass() && !className.contains("$$Lambda$")) {
                    className = this.parseLocalClassName(className);
                    telemetryRegistry.markOccurrence(className);
                }
            }
        }
    }

    protected String parseLocalClassName(String className) {
        return className.replace("$", "_");
    }
}

