/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DeleteJobCmd.class.getName());
    protected String jobId;

    public DeleteJobCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting job " + this.jobId);
        }
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull("No job found with id '" + this.jobId + "'", "job", (Object)job);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstance(job);
        if (job.getLockOwner() != null || job.getLockExpirationTime() != null) {
            throw new ProcessEngineException("Cannot delete job when the job is being executed. Try again later.");
        }
        job.delete();
        return null;
    }
}

