/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobListener;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecuteJobsCmd.class.getName());
    protected String jobId;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing job " + this.jobId);
        }
        JobEntity job = commandContext.getDbEntityManager().selectById(JobEntity.class, this.jobId);
        CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        if (job == null) {
            if (jobExecutorContext != null) {
                log.log(Level.FINE, "Job with Id " + this.jobId + " was acquired but cannot be found in database.");
                return null;
            }
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'");
        }
        if (jobExecutorContext == null) {
            AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
            authorizationManager.checkUpdateProcessInstance(job);
        }
        job.setExecuting(true);
        FailedJobListener failedJobListener = this.createFailedJobListener(commandExecutor);
        commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, failedJobListener);
        commandContext.registerCommandContextListener(failedJobListener);
        if (jobExecutorContext != null) {
            jobExecutorContext.setCurrentJob(job);
        }
        try {
            job.execute(commandContext);
            Object var6_6 = null;
            return var6_6;
        }
        catch (RuntimeException exception) {
            log.warning("Exception while excuting job '" + job + "': " + exception.getMessage());
            failedJobListener.setException(exception);
            throw exception;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
            }
        }
    }

    protected FailedJobListener createFailedJobListener(CommandExecutor commandExecutor) {
        return new FailedJobListener(commandExecutor, this.jobId);
    }
}

