/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.type;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.lang.model.type.NullType;
import org.camunda.bpm.engine.impl.core.variable.type.AbstractValueTypeImpl;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BooleanValue;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.DateValue;
import org.camunda.bpm.engine.variable.value.DoubleValue;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.NumberValue;
import org.camunda.bpm.engine.variable.value.ShortValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class PrimitiveValueTypeImpl
extends AbstractValueTypeImpl
implements PrimitiveValueType {
    private static final long serialVersionUID = 1L;
    protected Class<?> javaType;

    public PrimitiveValueTypeImpl(Class<?> javaType) {
        this(javaType.getSimpleName().toLowerCase(), javaType);
    }

    public PrimitiveValueTypeImpl(String name, Class<?> javaType) {
        super(name);
        this.javaType = javaType;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public boolean isPrimitiveValueType() {
        return true;
    }

    @Override
    public String toString() {
        return "PrimitiveValueType[" + this.getName() + "]";
    }

    @Override
    public Map<String, Object> getValueInfo(TypedValue typedValue) {
        return Collections.emptyMap();
    }

    public static class NumberTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public NumberTypeImpl() {
            super(Number.class);
        }

        @Override
        public NumberValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.numberValue((Number)value);
        }

        @Override
        public boolean isAbstract() {
            return true;
        }
    }

    public static class StringTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public StringTypeImpl() {
            super(String.class);
        }

        @Override
        public StringValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.stringValue((String)value);
        }
    }

    public static class ShortTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public ShortTypeImpl() {
            super(Short.class);
        }

        @Override
        public ShortValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.shortValue((Short)value);
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public ShortValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            NumberValue numberValue = (NumberValue)typedValue;
            if (numberValue.getValue() != null) {
                return Variables.shortValue(((Number)numberValue.getValue()).shortValue());
            }
            return Variables.shortValue(null);
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                return false;
            }
            if (typedValue.getValue() != null) {
                NumberValue numberValue = (NumberValue)typedValue;
                double doubleValue = ((Number)numberValue.getValue()).doubleValue();
                if ((double)((Number)numberValue.getValue()).shortValue() != doubleValue) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class NullTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public NullTypeImpl() {
            super("null", NullType.class);
        }

        @Override
        public TypedValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.untypedNullValue();
        }
    }

    public static class LongTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public LongTypeImpl() {
            super(Long.class);
        }

        @Override
        public LongValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.longValue((Long)value);
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                return false;
            }
            if (typedValue.getValue() != null) {
                NumberValue numberValue = (NumberValue)typedValue;
                double doubleValue = ((Number)numberValue.getValue()).doubleValue();
                if ((double)((Number)numberValue.getValue()).longValue() != doubleValue) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public LongValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            NumberValue numberValue = (NumberValue)typedValue;
            if (numberValue.getValue() != null) {
                return Variables.longValue(((Number)numberValue.getValue()).longValue());
            }
            return Variables.longValue(null);
        }
    }

    public static class IntegerTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public IntegerTypeImpl() {
            super(Integer.class);
        }

        @Override
        public IntegerValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.integerValue((Integer)value);
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                return false;
            }
            if (typedValue.getValue() != null) {
                NumberValue numberValue = (NumberValue)typedValue;
                double doubleValue = ((Number)numberValue.getValue()).doubleValue();
                if ((double)((Number)numberValue.getValue()).intValue() != doubleValue) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public IntegerValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            NumberValue numberValue = (NumberValue)typedValue;
            if (numberValue.getValue() != null) {
                return Variables.integerValue(((Number)numberValue.getValue()).intValue());
            }
            return Variables.integerValue(null);
        }
    }

    public static class DoubleTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public DoubleTypeImpl() {
            super(Double.class);
        }

        @Override
        public DoubleValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.doubleValue((Double)value);
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            return typedValue.getType() == ValueType.NUMBER;
        }

        @Override
        public DoubleValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            NumberValue numberValue = (NumberValue)typedValue;
            if (numberValue.getValue() != null) {
                return Variables.doubleValue(((Number)numberValue.getValue()).doubleValue());
            }
            return Variables.doubleValue(null);
        }
    }

    public static class DateTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public DateTypeImpl() {
            super(Date.class);
        }

        @Override
        public DateValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.dateValue((Date)value);
        }
    }

    public static class BytesTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public BytesTypeImpl() {
            super("bytes", byte[].class);
        }

        @Override
        public BytesValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.byteArrayValue((byte[])value);
        }
    }

    public static class BooleanTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public BooleanTypeImpl() {
            super(Boolean.class);
        }

        @Override
        public BooleanValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.booleanValue((Boolean)value);
        }
    }
}

