/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class TimerCatchIntermediateEventJobHandler
extends TimerEventJobHandler {
    private static Logger log = Logger.getLogger(TimerCatchIntermediateEventJobHandler.class.getName());
    public static final String TYPE = "timer-intermediate-transition";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String activityId = TimerCatchIntermediateEventJobHandler.getKey(configuration);
        ActivityImpl intermediateEventActivity = execution.getProcessDefinition().findActivity(activityId);
        EnsureUtil.ensureNotNull("Error while firing timer: intermediate event activity " + configuration + " not found", "intermediateEventActivity", (Object)intermediateEventActivity);
        try {
            if (activityId.equals(execution.getActivityId())) {
                execution.signal("signal", null);
            } else {
                execution.executeEventHandlerActivity(intermediateEventActivity);
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw e;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw new ProcessEngineException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

