/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class HistoricDetailVariableInstanceUpdateEntity
extends HistoricVariableUpdateEventEntity
implements ValueFields,
HistoricVariableUpdate,
DbEntityLifecycleAware {
    private static final long serialVersionUID = 1L;
    protected TypedValueSerializer<?> serializer;
    protected ByteArrayEntity byteArrayValue;
    protected TypedValue cachedValue;
    protected String errorMessage;

    @Override
    public Object getValue() {
        TypedValue typedValue = this.getTypedValue();
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    @Override
    public TypedValue getTypedValue() {
        return this.getTypedValue(true);
    }

    public TypedValue getTypedValue(boolean deserializeValue) {
        if (this.cachedValue == null && this.errorMessage == null) {
            try {
                this.cachedValue = this.getSerializer().readValue(this, deserializeValue);
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    @Override
    public void delete() {
        DbEntityManager dbEntityManger = Context.getCommandContext().getDbEntityManager();
        dbEntityManger.delete(this);
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
        }
    }

    public TypedValueSerializer<?> getSerializer() {
        this.ensureSerializerInitialized();
        return this.serializer;
    }

    protected void ensureSerializerInitialized() {
        if (this.serializerName != null && this.serializer == null) {
            this.serializer = HistoricDetailVariableInstanceUpdateEntity.getSerializers().getSerializerByName(this.serializerName);
            if (this.serializer == null) {
                throw new ProcessEngineException("No serializer defined for variable instance '" + this + "'.");
            }
        }
    }

    public static VariableSerializers getSerializers() {
        if (Context.getCommandContext() != null) {
            return Context.getProcessEngineConfiguration().getVariableSerializers();
        }
        throw new ProcessEngineException("Cannot work with serializers outside of command context.");
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayId;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayId != null && Context.getCommandContext() != null) {
            this.byteArrayValue = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.byteArrayId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
        }
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbEntityManager().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
        }
    }

    @Override
    public String getName() {
        return this.getVariableName();
    }

    @Override
    public void postLoad() {
        this.ensureSerializerInitialized();
    }

    @Override
    public String getTypeName() {
        if (this.serializerName == null) {
            return ValueType.NULL.getName();
        }
        return this.getSerializer().getType().getName();
    }

    @Override
    public String getVariableTypeName() {
        return this.getTypeName();
    }

    @Override
    public Date getTime() {
        return this.timestamp;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[byteArrayValue=" + this.byteArrayValue + ", variableName=" + this.variableName + ", variableInstanceId=" + this.variableInstanceId + ", revision=" + this.revision + ", serializerName=" + this.serializerName + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayId=" + this.byteArrayId + ", activityInstanceId=" + this.activityInstanceId + ", eventType=" + this.eventType + ", executionId=" + this.executionId + ", id=" + this.id + ", processDefinitionId=" + this.processInstanceId + ", processInstanceId=" + this.processInstanceId + ", taskId=" + this.taskId + ", timestamp=" + this.timestamp + "]";
    }
}

