/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.AbstractPvmEventAtomicOperation;

public class PvmAtomicOperationProcessStart
extends AbstractPvmEventAtomicOperation {
    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        ProcessInstanceStartContext startContext = execution.getProcessInstanceStartContext();
        return startContext != null && startContext.isAsync();
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.getProcessInstanceStartContext();
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        ProcessInstanceStartContext processInstanceStartContext = execution.getProcessInstanceStartContext();
        InstantiationStack instantiationStack = processInstanceStartContext.getInstantiationStack();
        if (instantiationStack.getActivities().isEmpty()) {
            execution.setActivity(instantiationStack.getTargetActivity());
            execution.performOperation(ACTIVITY_START_CREATE_SCOPE);
        } else {
            execution.setActivityInstanceId(execution.getId());
            execution.performOperation(ACTIVITY_INIT_STACK);
        }
    }

    @Override
    public String getCanonicalName() {
        return "process-start";
    }
}

