/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ByteArrayValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractSerializableValueSerializer<T extends SerializableValue>
extends AbstractTypedValueSerializer<T> {
    protected String serializationDataFormat;

    public AbstractSerializableValueSerializer(SerializableValueType type, String serializationDataFormat) {
        super(type);
        this.serializationDataFormat = serializationDataFormat;
    }

    @Override
    public String getSerializationDataformat() {
        return this.serializationDataFormat;
    }

    @Override
    public void writeValue(T value, ValueFields valueFields) {
        String serializedStringValue = value.getValueSerialized();
        byte[] serializedByteValue = null;
        if (value.isDeserialized()) {
            Object objectToSerialize = value.getValue();
            if (objectToSerialize != null) {
                try {
                    serializedByteValue = this.serializeToByteArray(objectToSerialize);
                    serializedStringValue = this.getSerializedStringValue(serializedByteValue);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Cannot serialize object in variable '" + valueFields.getName() + "': " + e.getMessage(), e);
                }
            }
        } else if (serializedStringValue != null) {
            serializedByteValue = this.getSerializedBytesValue(serializedStringValue);
        }
        this.writeToValueFields(value, valueFields, serializedByteValue);
        this.updateTypedValue(value, serializedStringValue);
    }

    @Override
    public T readValue(ValueFields valueFields, boolean deserializeObjectValue) {
        byte[] serializedByteValue = this.readSerializedValueFromFields(valueFields);
        String serializedStringValue = this.getSerializedStringValue(serializedByteValue);
        if (deserializeObjectValue) {
            Object deserializedObject = null;
            if (serializedByteValue != null) {
                try {
                    deserializedObject = this.deserializeFromByteArray(serializedByteValue, valueFields);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Cannot deserialize object in variable '" + valueFields.getName() + "': " + e.getMessage(), e);
                }
            }
            T value = this.createDeserializedValue(deserializedObject, serializedStringValue, valueFields);
            return value;
        }
        return this.createSerializedValue(serializedStringValue, valueFields);
    }

    protected abstract T createDeserializedValue(Object var1, String var2, ValueFields var3);

    protected abstract T createSerializedValue(String var1, ValueFields var2);

    protected abstract void writeToValueFields(T var1, ValueFields var2, byte[] var3);

    protected abstract void updateTypedValue(T var1, String var2);

    protected byte[] readSerializedValueFromFields(ValueFields valueFields) {
        return ByteArrayValueSerializer.getBytes(valueFields);
    }

    protected String getSerializedStringValue(byte[] serializedByteValue) {
        if (serializedByteValue != null) {
            if (!this.isSerializationTextBased()) {
                serializedByteValue = Base64.encodeBase64(serializedByteValue);
            }
            return StringUtil.fromBytes(serializedByteValue);
        }
        return null;
    }

    protected byte[] getSerializedBytesValue(String serializedStringValue) {
        if (serializedStringValue != null) {
            byte[] serializedByteValue = StringUtil.toByteArray(serializedStringValue);
            if (!this.isSerializationTextBased()) {
                serializedByteValue = Base64.decodeBase64(serializedByteValue);
            }
            return serializedByteValue;
        }
        return null;
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        boolean canSerialize;
        Object objectToSerialize = null;
        String requestedDataformat = null;
        if (typedValue instanceof UntypedValueImpl) {
            objectToSerialize = typedValue.getValue();
            requestedDataformat = null;
        } else if (typedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)typedValue;
            String requestedDataFormat = serializableValue.getSerializationDataFormat();
            if (!serializableValue.isDeserialized()) {
                return this.serializationDataFormat.equals(requestedDataFormat);
            }
            objectToSerialize = typedValue.getValue();
            requestedDataformat = serializableValue.getSerializationDataFormat();
        } else {
            return false;
        }
        boolean bl = canSerialize = objectToSerialize == null || this.canSerializeValue(objectToSerialize);
        if (requestedDataformat != null) {
            if (requestedDataformat.equals(this.serializationDataFormat)) {
                return canSerialize;
            }
            return false;
        }
        return canSerialize;
    }

    protected abstract boolean canSerializeValue(Object var1);

    protected abstract byte[] serializeToByteArray(Object var1) throws Exception;

    protected abstract Object deserializeFromByteArray(byte[] var1, ValueFields var2) throws Exception;

    protected abstract boolean isSerializationTextBased();
}

