/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;

import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.impl.HistoricActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;

/**
 *
 * @author Roman Smirnov
 *
 */
public class HistoricStatisticsManager extends AbstractManager {

  @SuppressWarnings("unchecked")
  public List<HistoricActivityStatistics> getHistoricStatisticsGroupedByActivity(HistoricActivityStatisticsQueryImpl query, Page page) {
    getAuthorizationManager().configureHistoricActivityStatisticsQuery(query);
    return getDbEntityManager().selectList("selectHistoricActivityStatistics", query, page);
  }

  public long getHistoricStatisticsCountGroupedByActivity(HistoricActivityStatisticsQueryImpl query) {
    getAuthorizationManager().configureHistoricActivityStatisticsQuery(query);
    return (Long) getDbEntityManager().selectOne("selectHistoricActivityStatisticsCount", query);
  }

}
