/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.AuthorizationQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;

public class AuthorizationQueryImpl
extends AbstractQuery<AuthorizationQuery, Authorization>
implements AuthorizationQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] userIds;
    protected String[] groupIds;
    protected int resourceType;
    protected String resourceId;
    protected int permission = 0;
    protected Integer authorizationType;
    protected boolean queryByPermission = false;
    protected boolean queryByResourceType = false;

    public AuthorizationQueryImpl() {
    }

    public AuthorizationQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public AuthorizationQuery authorizationId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public AuthorizationQuery userIdIn(String ... userIdIn) {
        if (this.groupIds != null) {
            throw new ProcessEngineException("Cannot query for user and group authorizations at the same time.");
        }
        this.userIds = userIdIn;
        return this;
    }

    @Override
    public AuthorizationQuery groupIdIn(String ... groupIdIn) {
        if (this.userIds != null) {
            throw new ProcessEngineException("Cannot query for user and group authorizations at the same time.");
        }
        this.groupIds = groupIdIn;
        return this;
    }

    @Override
    public AuthorizationQuery resourceType(Resource resource) {
        return this.resourceType(resource.resourceType());
    }

    @Override
    public AuthorizationQuery resourceType(int resourceType) {
        this.resourceType = resourceType;
        this.queryByResourceType = true;
        return this;
    }

    @Override
    public AuthorizationQuery resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public AuthorizationQuery hasPermission(Permission p) {
        this.queryByPermission = true;
        this.permission |= p.getValue();
        return this;
    }

    @Override
    public AuthorizationQuery authorizationType(Integer type) {
        this.authorizationType = type;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getAuthorizationManager().selectAuthorizationCountByQueryCriteria(this);
    }

    @Override
    public List<Authorization> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getAuthorizationManager().selectAuthorizationByQueryCriteria(this);
    }

    public String getId() {
        return this.id;
    }

    public boolean isQueryByPermission() {
        return this.queryByPermission;
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public String[] getGroupIds() {
        return this.groupIds;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public int getPermission() {
        return this.permission;
    }

    public boolean isQueryByResourceType() {
        return this.queryByResourceType;
    }

    @Override
    public AuthorizationQuery orderByResourceType() {
        this.orderBy(AuthorizationQueryProperty.RESOURCE_TYPE);
        return this;
    }

    @Override
    public AuthorizationQuery orderByResourceId() {
        this.orderBy(AuthorizationQueryProperty.RESOURCE_ID);
        return this;
    }
}

