/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.CompensationUtil;
import org.camunda.bpm.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class CompensationEventActivityBehavior
extends FlowNodeActivityBehavior {
    protected final CompensateEventDefinition compensateEventDefinition;

    public CompensationEventActivityBehavior(CompensateEventDefinition compensateEventDefinition) {
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        List<CompensateEventSubscriptionEntity> eventSubscriptions = this.collectEventSubscriptions(execution);
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            CompensationUtil.throwCompensationEvent(eventSubscriptions, execution, false);
        }
    }

    protected List<CompensateEventSubscriptionEntity> collectEventSubscriptions(ActivityExecution execution) {
        String activityRef = this.compensateEventDefinition.getActivityRef();
        if (activityRef != null) {
            return CompensationUtil.collectCompensateEventSubscriptionsForActivity(execution, activityRef);
        }
        return CompensationUtil.collectCompensateEventSubscriptionsForScope(execution);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (((PvmExecutionImpl)execution).getNonEventScopeExecutions().isEmpty()) {
            this.leave(execution);
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }
}

