/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;

public abstract class AbstractSetStateCmd
implements Command<Void> {
    protected static final String SUSPENSION_STATE_PROPERTY = "suspensionState";
    protected boolean includeSubResources;
    protected boolean isLogUserOperationDisabled;
    protected Date executionDate;

    public AbstractSetStateCmd(boolean includeSubResources, Date executionDate) {
        this.includeSubResources = includeSubResources;
        this.executionDate = executionDate;
    }

    @Override
    public Void execute(final CommandContext commandContext) {
        this.checkParameters(commandContext);
        this.checkAuthorization(commandContext);
        if (this.executionDate == null) {
            AbstractSetStateCmd cmd;
            this.updateSuspensionState(commandContext, this.getNewSuspensionState());
            if (this.isIncludeSubResources() && (cmd = this.getNextCommand()) != null) {
                cmd.disableLogUserOperation();
                commandContext.runWithoutAuthorization(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        cmd.execute(commandContext);
                        return null;
                    }
                });
            }
        } else {
            this.scheduleSuspensionStateUpdate(commandContext);
        }
        if (!this.isLogUserOperationDisabled()) {
            this.logUserOperation(commandContext);
        }
        return null;
    }

    public void disableLogUserOperation() {
        this.isLogUserOperationDisabled = true;
    }

    protected boolean isLogUserOperationDisabled() {
        return this.isLogUserOperationDisabled;
    }

    protected boolean isIncludeSubResources() {
        return this.includeSubResources;
    }

    protected void scheduleSuspensionStateUpdate(CommandContext commandContext) {
        TimerEntity timer = new TimerEntity();
        String jobHandlerConfiguration = this.getJobHandlerConfiguration();
        timer.setDuedate(this.executionDate);
        timer.setJobHandlerType(this.getDelayedExecutionJobHandlerType());
        timer.setJobHandlerConfiguration(jobHandlerConfiguration);
        commandContext.getJobManager().schedule(timer);
    }

    protected String getDelayedExecutionJobHandlerType() {
        return null;
    }

    protected String getJobHandlerConfiguration() {
        return null;
    }

    protected AbstractSetStateCmd getNextCommand() {
        return null;
    }

    protected abstract void checkAuthorization(CommandContext var1);

    protected abstract void checkParameters(CommandContext var1);

    protected abstract void updateSuspensionState(CommandContext var1, SuspensionState var2);

    protected abstract void logUserOperation(CommandContext var1);

    protected abstract String getLogEntryOperation();

    protected abstract SuspensionState getNewSuspensionState();
}

