/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CompleteExternalTaskCmd
implements Command<Void> {
    protected String externalTaskId;
    protected String workerId;
    protected Map<String, Object> variables;

    public CompleteExternalTaskCmd(String externalTaskId, String workerId, Map<String, Object> variables) {
        this.externalTaskId = externalTaskId;
        this.workerId = workerId;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find external task with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        if (!this.workerId.equals(externalTask.getWorkerId())) {
            throw new BadUserRequestException("External Task " + this.externalTaskId + " cannot be completed by worker '" + this.workerId + "'. It is locked by worker '" + externalTask.getWorkerId() + "'.");
        }
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        externalTask.complete(this.variables);
        return null;
    }

    protected void validateInput() {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        EnsureUtil.ensureNotNull("workerId", (Object)this.workerId);
    }
}

