/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.FoxFailedJobParseListener;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.cmd.DecrementJobRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.JobRetryCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class FoxJobRetryCmd
extends JobRetryCmd {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;

    public FoxJobRetryCmd(String jobId, Throwable exception) {
        super(jobId, exception);
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job = this.getJob();
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        if (activity == null) {
            LOG.debugFallbackToDefaultRetryStrategy();
            this.executeStandardStrategy(commandContext);
        } else {
            try {
                this.executeCustomStrategy(commandContext, job, activity);
            }
            catch (Exception e) {
                LOG.debugFallbackToDefaultRetryStrategy();
                this.executeStandardStrategy(commandContext);
            }
        }
        return null;
    }

    protected void executeStandardStrategy(CommandContext commandContext) {
        DecrementJobRetriesCmd decrementCmd = new DecrementJobRetriesCmd(this.jobId, this.exception);
        decrementCmd.execute(commandContext);
    }

    protected void executeCustomStrategy(CommandContext commandContext, JobEntity job, ActivityImpl activity) throws Exception {
        String failedJobRetryTimeCycle = this.getFailedJobRetryTimeCycle(activity);
        if (failedJobRetryTimeCycle == null) {
            this.executeStandardStrategy(commandContext);
        } else {
            DurationHelper durationHelper = this.getDurationHelper(failedJobRetryTimeCycle);
            this.setLockExpirationTime(job, failedJobRetryTimeCycle, durationHelper);
            if (this.isFirstJobExecution(job)) {
                this.initializeRetries(job, failedJobRetryTimeCycle, durationHelper);
            } else {
                LOG.debugDecrementingRetriesForJob(job.getId());
            }
            this.logException(job);
            this.decrementRetries(job);
            this.notifyAcquisition(commandContext);
        }
    }

    protected ActivityImpl getCurrentActivity(CommandContext commandContext, JobEntity job) {
        ExecutionEntity execution;
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        String configuration = job.getJobHandlerConfiguration();
        if ("timer-transition".equals(type) || "timer-intermediate-transition".equals(type)) {
            ExecutionEntity execution2 = this.fetchExecutionEntity(job.getExecutionId());
            if (execution2 != null) {
                String acitivtyId = TimerEventJobHandler.getKey(configuration);
                activity = execution2.getProcessDefinition().findActivity(acitivtyId);
            }
        } else if ("timer-start-event".equals(type)) {
            String definitionKey;
            DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(definitionKey = TimerEventJobHandler.getKey(configuration));
            if (processDefinition != null) {
                activity = processDefinition.getInitial();
            }
        } else if ("async-continuation".equals(type) && (execution = this.fetchExecutionEntity(job.getExecutionId())) != null) {
            activity = execution.getActivity();
        }
        return activity;
    }

    protected ExecutionEntity fetchExecutionEntity(String executionId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
    }

    protected String getFailedJobRetryTimeCycle(ActivityImpl activity) {
        return activity.getProperties().get(FoxFailedJobParseListener.FOX_FAILED_JOB_CONFIGURATION);
    }

    protected DurationHelper getDurationHelper(String failedJobRetryTimeCycle) throws Exception {
        return new DurationHelper(failedJobRetryTimeCycle);
    }

    protected void setLockExpirationTime(JobEntity job, String failedJobRetryTimeCycle, DurationHelper durationHelper) {
        job.setLockExpirationTime(durationHelper.getDateAfter());
    }

    protected boolean isFirstJobExecution(JobEntity job) {
        return job.getExceptionByteArrayId() == null && job.getExceptionMessage() == null;
    }

    protected void initializeRetries(JobEntity job, String failedJobRetryTimeCycle, DurationHelper durationHelper) {
        LOG.debugInitiallyAppyingRetryCycleForJob(job.getId(), durationHelper.getTimes());
        job.setRetries(durationHelper.getTimes());
    }
}

