/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheck;

public class PermissionCheckBuilder {
    protected List<PermissionCheck> atomicChecks = new ArrayList<PermissionCheck>();
    protected List<CompositePermissionCheck> compositeChecks = new ArrayList<CompositePermissionCheck>();
    protected boolean disjunctive = true;
    protected PermissionCheckBuilder parent;

    public PermissionCheckBuilder() {
    }

    public PermissionCheckBuilder(PermissionCheckBuilder parent) {
        this.parent = parent;
    }

    public PermissionCheckBuilder disjunctive() {
        this.disjunctive = true;
        return this;
    }

    public PermissionCheckBuilder conjunctive() {
        this.disjunctive = false;
        return this;
    }

    public PermissionCheckBuilder atomicCheck(Resource resource, String queryParam, Permission permission) {
        PermissionCheck permCheck = new PermissionCheck();
        permCheck.setResource(resource);
        permCheck.setResourceIdQueryParam(queryParam);
        permCheck.setPermission(permission);
        this.atomicChecks.add(permCheck);
        return this;
    }

    public PermissionCheckBuilder composite() {
        return new PermissionCheckBuilder(this);
    }

    public PermissionCheckBuilder done() {
        this.parent.compositeChecks.add(this.build());
        return this.parent;
    }

    public CompositePermissionCheck build() {
        this.validate();
        CompositePermissionCheck permissionCheck = new CompositePermissionCheck(this.disjunctive);
        permissionCheck.setAtomicChecks(this.atomicChecks);
        permissionCheck.setCompositeChecks(this.compositeChecks);
        return permissionCheck;
    }

    protected void validate() {
        if (!this.atomicChecks.isEmpty() && !this.compositeChecks.isEmpty()) {
            throw new ProcessEngineException("Mixed authorization checks of atomic and composite permissions are not supported");
        }
    }
}

