/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstanceCmd
implements Command<Object> {
    protected final String decisionDefinitionId;

    public DeleteHistoricDecisionInstanceCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decisionDefinitionId", (Object)this.decisionDefinitionId);
        DecisionDefinitionEntity decisionDefinition = commandContext.getDecisionDefinitionManager().findDecisionDefinitionById(this.decisionDefinitionId);
        EnsureUtil.ensureNotNull("No decision definition found with id: " + this.decisionDefinitionId, "decisionDefinition", (Object)decisionDefinition);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkDeleteHistoricDecisionInstance(decisionDefinition.getKey());
        commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstancesByDecisionDefinitionId(this.decisionDefinitionId);
        return null;
    }
}

