/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.DecisionTableUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class EvaluateDecisionByIdCmd
implements Command<DmnDecisionTableResult> {
    protected String decisionDefinitionId;
    protected VariableMap variables;

    public EvaluateDecisionByIdCmd(String decisionDefinitionId, Map<String, Object> variables) {
        this.decisionDefinitionId = decisionDefinitionId;
        this.variables = Variables.fromMap(variables);
    }

    @Override
    public DmnDecisionTableResult execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decision definition id is null", "processDefinitionId", (Object)this.decisionDefinitionId);
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        DecisionDefinitionEntity decisionDefinition = deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkEvaluateDecision(decisionDefinition.getKey());
        return this.doEvaluateDecision(decisionDefinition, this.variables);
    }

    protected DmnDecisionTableResult doEvaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) {
        try {
            return DecisionTableUtil.evaluateDecisionTable(decisionDefinition, variables);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while evaluating decision with id '" + this.decisionDefinitionId + "'", e);
        }
    }
}

