/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.el;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.JuelExpression;
import org.camunda.bpm.engine.impl.el.ProcessApplicationBeanElResolverDelegate;
import org.camunda.bpm.engine.impl.el.ProcessApplicationElResolverDelegate;
import org.camunda.bpm.engine.impl.el.ProcessEngineElContext;
import org.camunda.bpm.engine.impl.el.ReadOnlyMapELResolver;
import org.camunda.bpm.engine.impl.el.VariableContextElResolver;
import org.camunda.bpm.engine.impl.el.VariableScopeElResolver;
import org.camunda.bpm.engine.impl.javax.el.ArrayELResolver;
import org.camunda.bpm.engine.impl.javax.el.CompositeELResolver;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;
import org.camunda.bpm.engine.impl.javax.el.ExpressionFactory;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.javax.el.ListELResolver;
import org.camunda.bpm.engine.impl.javax.el.MapELResolver;
import org.camunda.bpm.engine.impl.javax.el.ValueExpression;
import org.camunda.bpm.engine.impl.juel.ExpressionFactoryImpl;
import org.camunda.bpm.engine.variable.context.VariableContext;

public class ExpressionManager {
    protected List<FunctionMapper> functionMappers = new ArrayList<FunctionMapper>();
    protected ExpressionFactory expressionFactory;
    protected ELContext parsingElContext = new ProcessEngineElContext(this.functionMappers);
    protected Map<Object, Object> beans;
    protected ELResolver elResolver;

    public ExpressionManager() {
        this(null);
    }

    public ExpressionManager(Map<Object, Object> beans) {
        this.expressionFactory = new ExpressionFactoryImpl();
        this.beans = beans;
    }

    public Expression createExpression(String expression) {
        ValueExpression valueExpression = this.createValueExpression(expression);
        return new JuelExpression(valueExpression, this, expression);
    }

    public ValueExpression createValueExpression(String expression) {
        return this.expressionFactory.createValueExpression(this.parsingElContext, expression, Object.class);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof AbstractVariableScope) {
            AbstractVariableScope variableScopeImpl = (AbstractVariableScope)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof AbstractVariableScope) {
                ((AbstractVariableScope)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    public ELContext createElContext(VariableContext variableContext) {
        ELResolver elResolver = this.getCachedElResolver();
        ProcessEngineElContext elContext = new ProcessEngineElContext(this.functionMappers, elResolver);
        elContext.putContext(ExpressionFactory.class, this.expressionFactory);
        elContext.putContext(VariableContext.class, variableContext);
        return elContext;
    }

    protected ProcessEngineElContext createElContext(VariableScope variableScope) {
        ELResolver elResolver = this.getCachedElResolver();
        ProcessEngineElContext elContext = new ProcessEngineElContext(this.functionMappers, elResolver);
        elContext.putContext(ExpressionFactory.class, this.expressionFactory);
        elContext.putContext(VariableScope.class, variableScope);
        return elContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ELResolver getCachedElResolver() {
        if (this.elResolver == null) {
            ExpressionManager expressionManager = this;
            synchronized (expressionManager) {
                if (this.elResolver == null) {
                    this.elResolver = this.createElResolver();
                }
            }
        }
        return this.elResolver;
    }

    protected ELResolver createElResolver() {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add(new VariableScopeElResolver());
        elResolver.add(new VariableContextElResolver());
        if (this.beans != null) {
            elResolver.add(new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add(new ProcessApplicationElResolverDelegate());
        elResolver.add(new ArrayELResolver());
        elResolver.add(new ListELResolver());
        elResolver.add(new MapELResolver());
        elResolver.add(new ProcessApplicationBeanElResolverDelegate());
        return elResolver;
    }

    public void addFunctionMapper(FunctionMapper elFunctionMapper) {
        this.functionMappers.add(elFunctionMapper);
    }
}

