/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

public class HistoricProcessInstanceManager
extends AbstractHistoricManager {
    public HistoricProcessInstanceEntity findHistoricProcessInstance(String processInstanceId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEntity.class, processInstanceId);
        }
        return null;
    }

    public HistoricProcessInstanceEventEntity findHistoricProcessInstanceEvent(String eventId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, eventId);
        }
        return null;
    }

    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEnabled()) {
            List historicProcessInstanceIds = this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.deleteHistoricProcessInstanceById(historicProcessInstanceId);
            }
        }
    }

    public void deleteHistoricProcessInstanceById(String historicProcessInstanceId) {
        if (this.isHistoryEnabled()) {
            CommandContext commandContext = Context.getCommandContext();
            this.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricIncidentManager().deleteHistoricIncidentsByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricJobLogManager().deleteHistoricJobLogsByProcessInstanceId(historicProcessInstanceId);
            commandContext.getDbEntityManager().delete(HistoricProcessInstanceEntity.class, "deleteHistoricProcessInstance", historicProcessInstanceId);
        }
    }

    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.getAuthorizationManager().configureHistoricProcessInstanceQuery(historicProcessInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", historicProcessInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.getAuthorizationManager().configureHistoricProcessInstanceQuery(historicProcessInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricProcessInstancesByQueryCriteria", historicProcessInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricProcessInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByNativeQuery", parameterMap);
    }
}

