/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.nio.charset.Charset;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public final class StringUtil {
    public static boolean isExpression(String text) {
        return (text = text.trim()).startsWith("${") || text.startsWith("#{");
    }

    public static String[] split(String text, String regex) {
        if (text == null) {
            return null;
        }
        if (regex == null) {
            return new String[]{text};
        }
        String[] result = text.split(regex);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static boolean hasAnySuffix(String text, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!text.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String fromBytes(byte[] bytes) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.fromBytes");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        return StringUtil.fromBytes(bytes, processEngineConfiguration.getProcessEngine());
    }

    public static String fromBytes(byte[] bytes, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Charset charset = processEngineConfiguration.getDefaultCharset();
        return new String(bytes, charset);
    }

    public static byte[] toByteArray(String string) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.toByteArray");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        return StringUtil.toByteArray(string, processEngineConfiguration.getProcessEngine());
    }

    public static byte[] toByteArray(String string, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Charset charset = processEngineConfiguration.getDefaultCharset();
        return string.getBytes(charset);
    }
}

