/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobListener;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.jobexecutor.SuccessfulJobListener;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected String jobId;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        JobEntity job = commandContext.getDbEntityManager().selectById(JobEntity.class, this.jobId);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
        IdentityService identityService = processEngineConfiguration.getIdentityService();
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        if (job == null) {
            if (jobExecutorContext != null) {
                LOG.debugAcquiredJobNotFound(this.jobId);
                return null;
            }
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'");
        }
        if (jobExecutorContext == null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateJob(job);
            }
        } else {
            String tenantId = job.getTenantId();
            if (tenantId != null) {
                identityService.setAuthentication(null, null, Collections.singletonList(tenantId));
            }
        }
        job.setExecuting(true);
        FailedJobListener failedJobListener = this.createFailedJobListener(commandExecutor);
        commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, failedJobListener);
        commandContext.registerCommandContextListener(failedJobListener);
        SuccessfulJobListener successListener = this.createSuccessfulJobListener(commandExecutor);
        commandContext.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, successListener);
        if (jobExecutorContext != null) {
            jobExecutorContext.setCurrentJob(job);
        }
        try {
            job.execute(commandContext);
            Object var9_9 = null;
            return var9_9;
        }
        catch (RuntimeException exception) {
            LOG.exceptionWhileExecutingJob(job, exception);
            failedJobListener.setException(exception);
            throw exception;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
                identityService.clearAuthentication();
            }
        }
    }

    protected FailedJobListener createFailedJobListener(CommandExecutor commandExecutor) {
        return new FailedJobListener(commandExecutor, this.jobId);
    }

    protected SuccessfulJobListener createSuccessfulJobListener(CommandExecutor commandExecutor) {
        return new SuccessfulJobListener();
    }
}

