/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chainmaker.sdk.ChainClient;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.ConnectionPool;
import org.chainmaker.sdk.Node;
import org.chainmaker.sdk.RpcServiceClient;
import org.chainmaker.sdk.RpcServiceClientException;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.config.ArchiveConfig;
import org.chainmaker.sdk.config.ChainClientConfig;
import org.chainmaker.sdk.config.NodeConfig;
import org.chainmaker.sdk.config.SdkConfig;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.utils.FileUtils;
import org.chainmaker.sdk.utils.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainManager {
    private static final Logger logger = LoggerFactory.getLogger(ChainManager.class);
    static String OPENSSL_PROVIDER = "openSSL";
    static String TLS_NEGOTIATION = "TLS";
    private Map<String, ChainClient> chains = new HashMap<String, ChainClient>();
    private static ChainManager chainManager = new ChainManager();

    private ChainManager() {
    }

    public static ChainManager getInstance() {
        return chainManager;
    }

    public ChainClient getChainClient(String chainId) {
        return this.chains.get(chainId);
    }

    public synchronized ChainClient createChainClient(SdkConfig sdkConfig) throws ChainClientException, RpcServiceClientException, UtilsException, ChainMakerCryptoSuiteException {
        this.checkConfig(sdkConfig.getChainClient());
        String chainId = sdkConfig.getChainClient().getChainId();
        ChainClientConfig chainClientConfig = sdkConfig.getChainClient();
        this.dealChainClientConfig(chainClientConfig);
        User clientUser = new User(sdkConfig.getChainClient().getOrgId(), chainClientConfig.getUserSignKeyBytes(), chainClientConfig.getUserSignCrtBytes(), chainClientConfig.getUserKeyBytes(), chainClientConfig.getUserCrtBytes());
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (NodeConfig nodeConfig : sdkConfig.getChainClient().getNodes()) {
            ArrayList<byte[]> tlsCaCertList = new ArrayList<byte[]>();
            if (nodeConfig.getTrustRootBytes() == null) {
                for (String rootPath : nodeConfig.getTrustRootPaths()) {
                    List<String> filePathList = FileUtils.getFilesByPath(rootPath);
                    for (String filePath : filePathList) {
                        tlsCaCertList.add(FileUtils.getFileBytes(filePath));
                    }
                }
                byte[][] tlsCaCerts = new byte[tlsCaCertList.size()][];
                tlsCaCertList.toArray((T[])tlsCaCerts);
                nodeConfig.setTrustRootBytes(tlsCaCerts);
            }
            String url = nodeConfig.isEnableTls() ? "grpcs://" + nodeConfig.getNodeAddr() : "grpc://" + nodeConfig.getNodeAddr();
            Node node = new Node();
            node.setTlsCertBytes(nodeConfig.getTrustRootBytes());
            node.setHostname(nodeConfig.getTlsHostName());
            node.setGrpcUrl(url);
            node.setSslProvider(OPENSSL_PROVIDER);
            node.setNegotiationType(TLS_NEGOTIATION);
            node.setConnectCount(nodeConfig.getConnCnt());
            nodeList.add(node);
        }
        Node[] nodes = new Node[nodeList.size()];
        nodeList.toArray(nodes);
        return this.createChainClient(chainId, clientUser, nodes, chainClientConfig.getRpcClient().getMaxReceiveMessageSize(), chainClientConfig.getArchive());
    }

    private void dealChainClientConfig(ChainClientConfig chainClientConfig) throws UtilsException {
        byte[] userSignCrtBytes;
        byte[] userSignKeyBytes;
        byte[] userCrtBytes;
        byte[] userKeyBytes = chainClientConfig.getUserKeyBytes();
        if (userKeyBytes == null) {
            chainClientConfig.setUserKeyBytes(FileUtils.getFileBytes(chainClientConfig.getUserKeyFilePath()));
        }
        if ((userCrtBytes = chainClientConfig.getUserCrtBytes()) == null) {
            chainClientConfig.setUserCrtBytes(FileUtils.getFileBytes(chainClientConfig.getUserCrtFilePath()));
        }
        if ((userSignKeyBytes = chainClientConfig.getUserSignKeyBytes()) == null) {
            chainClientConfig.setUserSignKeyBytes(FileUtils.getFileBytes(chainClientConfig.getUserSignKeyFilePath()));
        }
        if ((userSignCrtBytes = chainClientConfig.getUserSignCrtBytes()) == null) {
            chainClientConfig.setUserSignCrtBytes(FileUtils.getFileBytes(chainClientConfig.getUserSignCrtFilePath()));
        }
    }

    private ChainClient createChainClient(String chainId, User clientUser, Node[] nodes, int messageSize, ArchiveConfig archiveConfig) throws RpcServiceClientException, UtilsException {
        ChainClient chainClient = this.chains.get(chainId);
        if (chainClient != null) {
            return chainClient;
        }
        ArrayList<RpcServiceClient> rpcServiceClients = new ArrayList<RpcServiceClient>();
        for (Node node : nodes) {
            for (int i = 0; i < node.getConnectCount(); ++i) {
                RpcServiceClient rpcServiceClient = RpcServiceClient.newServiceClient(node, clientUser, messageSize);
                rpcServiceClients.add(rpcServiceClient);
            }
        }
        Collections.shuffle(rpcServiceClients);
        ConnectionPool connectionPool = new ConnectionPool();
        connectionPool.setPrivateKey(clientUser.getTlsPrivateKey());
        connectionPool.setCertificate(clientUser.getTlsCertificate());
        connectionPool.setRpcServiceClients(rpcServiceClients);
        chainClient = new ChainClient();
        chainClient.setChainId(chainId);
        chainClient.setClientUser(clientUser);
        chainClient.setConnectionPool(connectionPool);
        chainClient.setArchiveConfig(archiveConfig);
        this.chains.put(chainId, chainClient);
        return chainClient;
    }

    private void checkConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        if (chainClientConfig == null) {
            logger.error("chainClientConfig is null, please check config");
            throw new ChainClientException("chainClientConfig is null");
        }
        this.checkNodeListConfig(chainClientConfig);
        this.checkUserConfig(chainClientConfig);
        this.checkChainConfig(chainClientConfig);
    }

    private void checkNodeListConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        NodeConfig[] nodeConfigs;
        for (NodeConfig nodeConfig : nodeConfigs = chainClientConfig.getNodes()) {
            if (nodeConfig.getConnCnt() <= 0 || nodeConfig.getConnCnt() > NodeConfig.MaxConnCnt) {
                throw new ChainClientException(String.format("node connection count should >0 && <=%d", NodeConfig.MaxConnCnt));
            }
            if (nodeConfig.isEnableTls() && nodeConfig.getTrustRootBytes() == null && nodeConfig.getTrustRootPaths() == null) {
                throw new ChainClientException("if node useTLS is open, should set caPaths or caCerts");
            }
            if (!"".equals(nodeConfig.getTlsHostName())) continue;
            throw new ChainClientException("if node useTLS is open, should set tls hostname");
        }
    }

    private void checkUserConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        if ("".equals(chainClientConfig.getUserKeyFilePath()) && chainClientConfig.getUserKeyBytes() == null) {
            throw new ChainClientException("user key cannot be empty");
        }
        if ("".equals(chainClientConfig.getUserCrtFilePath()) && chainClientConfig.getUserCrtBytes() == null) {
            throw new ChainClientException("user cert cannot be empty");
        }
    }

    private void checkChainConfig(ChainClientConfig chainClientConfig) throws ChainClientException {
        if ("".equals(chainClientConfig.getChainId())) {
            throw new ChainClientException("chainId cannot be empty");
        }
        if ("".equals(chainClientConfig.getOrgId())) {
            throw new ChainClientException("orgId cannot be empty");
        }
    }
}

