/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import io.grpc.ConnectivityState;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;
import org.chainmaker.sdk.RpcServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final int RETRY_INTERVAL = 500;
    private static final int RETRY_LIMIT = 5;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private List<RpcServiceClient> rpcServiceClients;
    private PrivateKey privateKey;
    private Certificate certificate;

    public List<RpcServiceClient> getRpcServiceClients() {
        return this.rpcServiceClients;
    }

    public void setRpcServiceClients(List<RpcServiceClient> rpcServiceClients) {
        this.rpcServiceClients = rpcServiceClients;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public RpcServiceClient getConnection() {
        for (int i = 0; i < 5; ++i) {
            for (RpcServiceClient rpcServiceClient : this.rpcServiceClients) {
                ConnectivityState connectivityState = rpcServiceClient.getManagedChannel().getState(true);
                if (!connectivityState.equals((Object)ConnectivityState.IDLE) && !connectivityState.equals((Object)ConnectivityState.READY)) continue;
                return rpcServiceClient;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Thread sleep error : ", (Throwable)e);
            }
        }
        return null;
    }
}

