/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.chainmaker.pb.api.RpcNodeGrpc;
import org.chainmaker.sdk.Node;
import org.chainmaker.sdk.RpcServiceClientException;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.utils.Utils;
import org.chainmaker.sdk.utils.UtilsException;

public class RpcServiceClient {
    private static final Map<Class<?>, Class<?>> WRAPPERS_TO_PRIM = new ImmutableMap.Builder().put(Boolean.class, Boolean.TYPE).put(Byte.class, Byte.TYPE).put(Character.class, Character.TYPE).put(Double.class, Double.TYPE).put(Float.class, Float.TYPE).put(Integer.class, Integer.TYPE).put(Long.class, Long.TYPE).put(Short.class, Short.TYPE).put(Void.class, Void.TYPE).build();
    private ManagedChannel managedChannel;
    private RpcNodeGrpc.RpcNodeFutureStub rpcNodeFutureStub;
    private RpcNodeGrpc.RpcNodeStub rpcNodeStub;

    public ManagedChannel getManagedChannel() {
        return this.managedChannel;
    }

    public void setManagedChannel(ManagedChannel managedChannel) {
        this.managedChannel = managedChannel;
    }

    public RpcNodeGrpc.RpcNodeFutureStub getRpcNodeFutureStub() {
        return this.rpcNodeFutureStub;
    }

    public void setRpcNodeFutureStub(RpcNodeGrpc.RpcNodeFutureStub rpcNodeFutureStub) {
        this.rpcNodeFutureStub = rpcNodeFutureStub;
    }

    public RpcNodeGrpc.RpcNodeStub getRpcNodeStub() {
        return this.rpcNodeStub;
    }

    public void setRpcNodeStub(RpcNodeGrpc.RpcNodeStub rpcNodeStub) {
        this.rpcNodeStub = rpcNodeStub;
    }

    RpcServiceClient(Node node, User user, int messageSize) throws RpcServiceClientException, UtilsException {
        this.managedChannel = this.initManagedChannel(node, user, messageSize);
        this.rpcNodeFutureStub = RpcNodeGrpc.newFutureStub((Channel)this.managedChannel);
        this.rpcNodeStub = RpcNodeGrpc.newStub((Channel)this.managedChannel);
    }

    public static RpcServiceClient newServiceClient(Node node, User user, int messageSize) throws RpcServiceClientException, UtilsException {
        return new RpcServiceClient(node, user, messageSize);
    }

    private ManagedChannel initManagedChannel(Node node, User user, int messageSize) throws RpcServiceClientException, UtilsException {
        Properties grpcProperties = Utils.parseGrpcUrl(node.getGrpcUrl());
        String protocol = grpcProperties.getProperty("protocol");
        int port = Integer.parseInt(grpcProperties.getProperty("port"));
        String host = grpcProperties.getProperty("host");
        NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
        if (messageSize > 0) {
            nettyChannelBuilder.maxInboundMessageSize(messageSize * 1024 * 1024);
        }
        Properties nettyBuilderProperties = new Properties();
        nettyBuilderProperties.put("keepAliveTime", new Object[]{5L, TimeUnit.MINUTES});
        nettyBuilderProperties.put("keepAliveTimeout", new Object[]{8L, TimeUnit.SECONDS});
        nettyBuilderProperties.put("keepAliveWithoutCalls", new Object[]{true});
        try {
            if (protocol.equalsIgnoreCase("grpc")) {
                nettyChannelBuilder.usePlaintext(true);
                this.addNettyBuilderProps(nettyChannelBuilder, nettyBuilderProperties);
                return nettyChannelBuilder.build();
            }
            if (!protocol.equalsIgnoreCase("grpcs")) {
                throw new RpcServiceClientException("invalid protocol");
            }
            X509Certificate[] clientCert = new X509Certificate[]{(X509Certificate)user.getTlsCertificate()};
            PrivateKey clientKey = user.getTlsPrivateKey();
            AbstractMap.SimpleImmutableEntry<PrivateKey, X509Certificate[]> clientTLSProps = new AbstractMap.SimpleImmutableEntry<PrivateKey, X509Certificate[]>(clientKey, clientCert);
            clientCert = clientTLSProps.getValue();
            clientKey = clientTLSProps.getKey();
            if (!"openSSL".equals(node.getSslProvider()) && !"JDK".equals(node.getSslProvider())) {
                throw new RpcServiceClientException(String.format("Endpoint %s property of sslProvider has to be either openSSL or JDK. value: '%s'", node.getGrpcUrl(), node.getSslProvider()));
            }
            if (!"TLS".equals(node.getNegotiationType()) && !"plainText".equals(node.getNegotiationType())) {
                throw new RpcServiceClientException(String.format("Endpoint %s property of negotiationType has to be either TLS or plainText. value: '%s'", node.getGrpcUrl(), node.getNegotiationType()));
            }
            if (node.getTlsCertBytes() == null) {
                throw new RpcServiceClientException("can't find tls cert");
            }
            SslProvider sslprovider = node.getSslProvider().equals("openSSL") ? SslProvider.OPENSSL : SslProvider.JDK;
            NegotiationType ntype = node.getNegotiationType().equals("TLS") ? NegotiationType.TLS : NegotiationType.PLAINTEXT;
            SslContextBuilder clientContextBuilder = RpcServiceClient.getSslContextBuilder(clientCert, clientKey, sslprovider);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> x509CertificateList = new ArrayList<X509Certificate>();
            for (int i = 0; i < node.getTlsCertBytes().length; ++i) {
                X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(node.getTlsCertBytes()[i]));
                x509CertificateList.add(x509Certificate);
            }
            X509Certificate[] x509Certificates = new X509Certificate[x509CertificateList.size()];
            SslContext sslContext = clientContextBuilder.trustManager(x509CertificateList.toArray(x509Certificates)).build();
            nettyChannelBuilder.sslContext(sslContext).negotiationType(ntype);
            if (node.getHostname() != null) {
                nettyChannelBuilder.overrideAuthority(node.getHostname());
            }
            this.addNettyBuilderProps(nettyChannelBuilder, nettyBuilderProperties);
        }
        catch (Exception e) {
            throw new RpcServiceClientException(e.toString());
        }
        return nettyChannelBuilder.build();
    }

    private static X509Certificate getX509Certificate(byte[] pemCertificate) throws RpcServiceClientException {
        X509Certificate ret = null;
        LinkedList<Provider> providerList = new LinkedList<Provider>(Arrays.asList(Security.getProviders()));
        try {
            providerList.add((Provider)BouncyCastleProvider.class.newInstance());
        }
        catch (Exception e) {
            throw new RpcServiceClientException(e.toString());
        }
        for (Provider provider : providerList) {
            try {
                if (null == provider) continue;
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509", provider);
                ByteArrayInputStream bis = new ByteArrayInputStream(pemCertificate);
                Throwable throwable = null;
                try {
                    Certificate certificate = certFactory.generateCertificate(bis);
                    if (!(certificate instanceof X509Certificate)) continue;
                    ret = (X509Certificate)certificate;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bis == null) continue;
                    if (throwable != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bis.close();
                }
            }
            catch (Exception e) {
                throw new RpcServiceClientException(e.toString());
            }
        }
        return ret;
    }

    private static SslContextBuilder getSslContextBuilder(X509Certificate[] clientCert, PrivateKey clientKey, SslProvider sslprovider) {
        SslContextBuilder clientContextBuilder = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient(), (SslProvider)sslprovider);
        if (clientKey != null && clientCert != null) {
            clientContextBuilder = clientContextBuilder.keyManager(clientKey, clientCert);
        }
        return clientContextBuilder;
    }

    private void addNettyBuilderProps(NettyChannelBuilder channelBuilder, Properties props) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> es : props.entrySet()) {
            Object methodprop = es.getKey();
            if (methodprop == null) continue;
            String methodName = String.valueOf(methodprop);
            Object parmsArrayO = es.getValue();
            Object[] parmsArray = !(parmsArrayO instanceof Object[]) ? new Object[]{parmsArrayO} : (Object[])parmsArrayO;
            Class<?>[] classParams = this.getClassParams(parmsArray);
            Method method = channelBuilder.getClass().getMethod(methodName, classParams);
            method.invoke((Object)channelBuilder, parmsArray);
        }
    }

    private Class<?>[] getClassParams(Object[] parmsArray) {
        Class[] classParams = new Class[parmsArray.length];
        int i = -1;
        for (Object oparm : parmsArray) {
            ++i;
            if (null == oparm) {
                classParams[i] = Object.class;
                continue;
            }
            Class<?> unwrapped = WRAPPERS_TO_PRIM.get(oparm.getClass());
            if (null != unwrapped) {
                classParams[i] = unwrapped;
                continue;
            }
            Class<?> clz = oparm.getClass();
            Class<?> ecz = clz.getEnclosingClass();
            if (null != ecz && ecz.isEnum()) {
                clz = ecz;
            }
            classParams[i] = clz;
        }
        return classParams;
    }
}

