/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import com.google.protobuf.ByteString;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.crypto.ChainmakerX509CryptoSuite;
import org.chainmaker.sdk.crypto.CryptoSuite;
import org.chainmaker.sdk.utils.CryptoUtils;

public class User {
    private String orgId;
    private PrivateKey privateKey;
    private Certificate certificate;
    private PrivateKey tlsPrivateKey;
    private Certificate tlsCertificate;
    private byte[] certBytes;
    private byte[] certHash;
    private CryptoSuite cryptoSuite;

    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] tlsUserKeyBytes, byte[] tlsUserCertBytes) throws ChainMakerCryptoSuiteException {
        PrivateKey generatedPrivateKey = CryptoUtils.getPrivateKeyFromBytes(userKeyBytes);
        PrivateKey generatedTlsPrivateKey = CryptoUtils.getPrivateKeyFromBytes(tlsUserKeyBytes);
        ChainmakerX509CryptoSuite generatedCryptoSuite = ChainmakerX509CryptoSuite.newInstance();
        Certificate generatedCertificate = generatedCryptoSuite.getCertificateFromBytes(userCertBytes);
        Certificate generatedTlsCertificate = generatedCryptoSuite.getCertificateFromBytes(tlsUserCertBytes);
        this.orgId = orgId;
        this.certBytes = userCertBytes;
        this.privateKey = generatedPrivateKey;
        this.tlsCertificate = generatedTlsCertificate;
        this.tlsPrivateKey = generatedTlsPrivateKey;
        this.cryptoSuite = generatedCryptoSuite;
        this.certificate = generatedCertificate;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public PrivateKey getTlsPrivateKey() {
        return this.tlsPrivateKey;
    }

    public void setTlsPrivateKey(PrivateKey tlsPrivateKey) {
        this.tlsPrivateKey = tlsPrivateKey;
    }

    public Certificate getTlsCertificate() {
        return this.tlsCertificate;
    }

    public void setTlsCertificate(Certificate tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
    }

    public byte[] getCertBytes() {
        return this.certBytes;
    }

    public void setCertBytes(byte[] certBytes) {
        this.certBytes = certBytes;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public void setCertHash(byte[] certHash) {
        this.certHash = certHash;
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public byte[] signPayload(byte[] payload, boolean isEnabledCertHash) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry endorsementEntry = Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])this.cryptoSuite.sign(this.privateKey, payload))).setSigner(this.getSerializedMember(isEnabledCertHash)).build();
        return endorsementEntry.toByteArray();
    }

    public Request.EndorsementEntry signPayloadOfMultiSign(byte[] payload, boolean isEnabledCertHash) throws ChainMakerCryptoSuiteException {
        return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])this.cryptoSuite.sign(this.privateKey, payload))).setSigner(this.getSerializedMember(isEnabledCertHash)).build();
    }

    public MemberOuterClass.Member getSerializedMember(boolean isEnabledCertHash) {
        if (isEnabledCertHash && this.certHash != null && this.certHash.length > 0) {
            return MemberOuterClass.Member.newBuilder().setOrgId(this.orgId).setMemberInfo(ByteString.copyFrom((byte[])this.certHash)).setMemberType(MemberOuterClass.MemberType.CERT_HASH).build();
        }
        return MemberOuterClass.Member.newBuilder().setOrgId(this.orgId).setMemberInfo(ByteString.copyFrom((byte[])this.certBytes)).setMemberType(MemberOuterClass.MemberType.CERT).build();
    }
}

