/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.chainmaker.sdk.utils.UtilsException;

public class FileUtils {
    private FileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] getResourceFileBytes(String resourcePath) throws UtilsException {
        byte[] fileBytes = null;
        try {
            fileBytes = IOUtils.toByteArray((InputStream)((BufferedInputStream)Resources.getResource((String)resourcePath).getContent()));
        }
        catch (IOException e) {
            throw new UtilsException("get file by path err : " + e.getMessage());
        }
        return fileBytes;
    }

    public static byte[] getFileBytes(String filePath) throws UtilsException {
        byte[] fileBytes = null;
        try {
            fileBytes = IOUtils.toByteArray((InputStream)new FileInputStream(new File(filePath)));
        }
        catch (IOException e) {
            throw new UtilsException("get file by path err : " + e.getMessage());
        }
        return fileBytes;
    }

    public static List<String> getFilesByPath(String path) {
        ArrayList<String> files = new ArrayList<String>();
        File file = new File(path);
        File[] tempList = file.listFiles();
        if (tempList != null) {
            for (File value : tempList) {
                if (!value.isFile() || !value.getName().contains(".crt")) continue;
                files.add(value.toString());
            }
        }
        return files;
    }

    public static String getResourceFilePath(String resourcePath) {
        return System.getProperty("user.dir") + "/src/main/resources/" + resourcePath;
    }

    public static boolean isFileExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }
}

