/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import com.google.protobuf.ByteString;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;

public class SdkUtils {
    public static Request.EndorsementEntry[] getEndorsers(Request.Payload payload, User[] users) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry[] endorsementEntries = new Request.EndorsementEntry[users.length];
        for (int i = 0; i < users.length; ++i) {
            Request.EndorsementEntry entry;
            endorsementEntries[i] = entry = SdkUtils.signPayload(users[i], payload.toByteArray());
        }
        return endorsementEntries;
    }

    private static Request.EndorsementEntry signPayload(User user, byte[] payload) throws ChainMakerCryptoSuiteException {
        return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])user.getCryptoSuite().sign(user.getPrivateKey(), payload))).setSigner(SdkUtils.getSerializedMember(user)).build();
    }

    public static MemberOuterClass.Member getSerializedMember(User user) {
        return MemberOuterClass.Member.newBuilder().setOrgId(user.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])user.getCertBytes())).setMemberType(MemberOuterClass.MemberType.CERT).build();
    }
}

