/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.cr;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.cleartk.util.ViewUriUtil;

public class UriCollectionReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_FILES = "files";
    @ConfigurationParameter(name="files", mandatory=false, description="provides a list of files whose URI should be written to the default sofa within the CAS")
    private Collection<File> files = new ArrayList<File>();
    public static final String PARAM_DIRECTORY = "directory";
    @ConfigurationParameter(name="directory", mandatory=false, description="provids a directory containing files whose URIs should be written to the defaul sofa within the CAS")
    private File directory = null;
    public static final String PARAM_URIS = "uris";
    @ConfigurationParameter(name="uris", mandatory=false, description="This parameter provides a list of URIs that should be written to the default sofa within the CAS.  Proper URI construction is the responsibility of the caller")
    private Collection<URI> uris = new ArrayList<URI>();
    public static final String PARAM_FILE_FILTER_CLASS = "fileFilterClass";
    @ConfigurationParameter(name="fileFilterClass", defaultValue={"org.cleartk.util.cr.UriCollectionReader.RejectSystemFiles"}, mandatory=false, description="The class used for filtering files when PARAM_DIRECTORY is set")
    private Class<? extends IOFileFilter> fileFilterClass;
    public static final String PARAM_DIRECTORY_FILTER_CLASS = "directoryFilterClass";
    @ConfigurationParameter(name="directoryFilterClass", defaultValue={"org.cleartk.util.cr.UriCollectionReader.RejectSystemDirectories"}, mandatory=false, description="The class used for filtering sub-directories when PARAM_DIRECTORY is set.  To disable recursion, pass in a directory filter that rejects all directory files")
    private Class<? extends IOFileFilter> directoryFilterClass;
    protected Iterator<URI> uriIter;
    protected int numUrisCompleted = 0;
    protected int uriCount = 0;
    protected Function<String, URI> stringToUri = new Function<String, URI>(){

        public URI apply(String input) {
            try {
                return new URI(input);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    };
    protected Function<File, URI> fileToUri = new Function<File, URI>(){

        public URI apply(File input) {
            return input.toURI();
        }
    };

    public static CollectionReaderDescription getDescriptionFromDirectory(File directory) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(UriCollectionReader.class, null, (Object[])new Object[]{PARAM_DIRECTORY, directory});
    }

    public static CollectionReaderDescription getDescriptionFromDirectory(File directory, Class<? extends IOFileFilter> fileFilterClass, Class<? extends IOFileFilter> dirFilterClass) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(UriCollectionReader.class, null, (Object[])new Object[]{PARAM_DIRECTORY, directory, PARAM_FILE_FILTER_CLASS, fileFilterClass, PARAM_DIRECTORY_FILTER_CLASS, dirFilterClass});
    }

    public static CollectionReader getCollectionReaderFromDirectory(File directory) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)UriCollectionReader.getDescriptionFromDirectory(directory), (Object[])new Object[0]);
    }

    public static CollectionReader getCollectionReaderFromDirectory(File directory, Class<? extends IOFileFilter> fileFilterClass, Class<? extends IOFileFilter> dirFilterClass) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)UriCollectionReader.getDescriptionFromDirectory(directory, fileFilterClass, dirFilterClass), (Object[])new Object[0]);
    }

    public static CollectionReaderDescription getDescriptionFromFiles(Collection<File> files) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(UriCollectionReader.class, null, (Object[])new Object[]{PARAM_FILES, files});
    }

    public static CollectionReader getCollectionReaderFromFiles(Collection<File> files) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)UriCollectionReader.getDescriptionFromFiles(files), (Object[])new Object[0]);
    }

    public static CollectionReaderDescription getDescriptionFromUris(Collection<URI> uris) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(UriCollectionReader.class, null, (Object[])new Object[]{PARAM_URIS, uris});
    }

    public static CollectionReader getCollectionReaderFromUris(Collection<URI> uris) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)UriCollectionReader.getDescriptionFromUris(uris), (Object[])new Object[0]);
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.uriCount += this.files.size();
        Iterable urisFromFiles = Iterables.transform(this.files, this.fileToUri);
        Iterable urisFromDirectory = new ArrayList();
        if (this.isDirectoryValid()) {
            IOFileFilter directoryFilter;
            IOFileFilter fileFilter;
            try {
                fileFilter = this.fileFilterClass.newInstance();
                directoryFilter = this.directoryFilterClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            Collection filesInDir = FileUtils.listFiles((File)this.directory, (IOFileFilter)fileFilter, (IOFileFilter)directoryFilter);
            urisFromDirectory = Iterables.transform((Iterable)filesInDir, this.fileToUri);
            this.uriCount += filesInDir.size();
        }
        this.uriIter = Iterables.concat(this.uris, (Iterable)urisFromFiles, urisFromDirectory).iterator();
    }

    private boolean isDirectoryValid() throws ResourceInitializationException {
        if (this.directory == null) {
            return false;
        }
        if (!this.directory.exists()) {
            String format = "Directory %s does not exist";
            String message = String.format(format, this.directory.getPath());
            throw new ResourceInitializationException((Throwable)new IOException(message));
        }
        if (!this.directory.isDirectory()) {
            String format = "Directory %s is not a directory.  For specific files set PARAM_FILES instead of PARAM_DIRECTORY.";
            String message = String.format(format, this.directory.getPath());
            throw new ResourceInitializationException((Throwable)new IOException(message));
        }
        return true;
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.uriIter.hasNext();
    }

    public Progress[] getProgress() {
        ProgressImpl progress = new ProgressImpl(this.numUrisCompleted, this.uriCount, "entities");
        return new Progress[]{progress};
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        if (!this.hasNext()) {
            throw new RuntimeException("getNext(jCas) was called but hasNext() returns false");
        }
        ViewUriUtil.setURI(jCas, this.uriIter.next());
    }

    public static class RejectSystemDirectories
    implements IOFileFilter {
        public boolean accept(File file) {
            return FileFilterUtils.directoryFileFilter().accept(file) && HiddenFileFilter.VISIBLE.accept(file);
        }

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            return FileFilterUtils.directoryFileFilter().accept(file) && HiddenFileFilter.VISIBLE.accept(file) && this.accept(file);
        }
    }

    public static class RejectSystemFiles
    implements IOFileFilter {
        FileFilter f = FileFilterUtils.fileFileFilter();

        public boolean accept(File file) {
            return FileFilterUtils.fileFileFilter().accept(file) && HiddenFileFilter.VISIBLE.accept(file);
        }

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            return FileFilterUtils.directoryFileFilter().accept(file) && HiddenFileFilter.VISIBLE.accept(file) && this.accept(file);
        }
    }
}

