/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.curl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import org.codelibs.curl.CurlException;

public class CurlResponse
implements Closeable {
    private int httpStatusCode;
    private Path tempFile;
    private String encoding;
    private Exception contentException;

    @Override
    public void close() throws IOException {
        if (this.tempFile != null) {
            Files.delete(this.tempFile);
        }
    }

    public <T> T getContent(Function<CurlResponse, T> parser) {
        return parser.apply(this);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getContentAsString() {
        byte[] bytes = new byte[4096];
        try {
            Throwable throwable = null;
            try (BufferedInputStream bis = new BufferedInputStream(this.getContentAsStream());){
                String string;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                try {
                    int length = bis.read(bytes);
                    while (length != -1) {
                        if (length != 0) {
                            baos.write(bytes, 0, length);
                        }
                        length = bis.read(bytes);
                    }
                    string = baos.toString(this.encoding);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            CurlResponse.$closeResource(throwable2, baos);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                CurlResponse.$closeResource(throwable2, baos);
                return string;
            }
        }
        catch (Exception e) {
            throw new CurlException("Failed to access the content.", e);
        }
    }

    public InputStream getContentAsStream() throws IOException {
        if (this.tempFile == null) {
            if (this.contentException != null) {
                throw new CurlException("The content does not exist.", this.contentException);
            }
            throw new CurlException("The content does not exist.");
        }
        return Files.newInputStream(this.tempFile, StandardOpenOption.READ);
    }

    public void setContentFile(Path tempFile) {
        this.tempFile = tempFile;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setContentException(Exception e) {
        this.contentException = e;
    }

    public Exception getContentException() {
        return this.contentException;
    }
}

